/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.panel;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.ui.panel.GridBagPanelBuilder;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.ProgressPanel;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SeparatorOrientation;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressPanelBuilder
implements GridBagPanelBuilder,
PanelBuilder {
    private static final Color SEPARATOR_COLOR = JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
    private final JProgressBar myProgressBar;
    private @NlsContexts.Label String initialLabelText;
    private boolean labelAbove = true;
    private Runnable cancelAction;
    private Runnable resumeAction;
    private Runnable pauseAction;
    @NlsContexts.Button
    private String cancelText = CommonBundle.getCancelButtonText();
    private boolean cancelAsButton;
    private boolean smallVariant;
    private boolean commentEnabled = true;
    private boolean text2Enabled;
    private boolean topSeparatorEnabled;

    public ProgressPanelBuilder(JProgressBar progressBar) {
        this.myProgressBar = progressBar;
    }

    public ProgressPanelBuilder withLabel(@NlsContexts.Label @NotNull String text) {
        if (text == null) {
            ProgressPanelBuilder.$$$reportNull$$$0(0);
        }
        this.initialLabelText = text;
        return this;
    }

    public ProgressPanelBuilder moveLabelLeft() {
        this.labelAbove = false;
        return this;
    }

    public ProgressPanelBuilder withCancel(@NotNull Runnable cancelAction) {
        if (cancelAction == null) {
            ProgressPanelBuilder.$$$reportNull$$$0(1);
        }
        this.cancelAction = cancelAction;
        return this;
    }

    public ProgressPanelBuilder andCancelText(String cancelText) {
        this.cancelText = cancelText;
        return this;
    }

    public ProgressPanelBuilder andCancelAsButton() {
        this.cancelAsButton = true;
        return this;
    }

    public ProgressPanelBuilder withResume(@NotNull Runnable playAction) {
        if (playAction == null) {
            ProgressPanelBuilder.$$$reportNull$$$0(2);
        }
        this.resumeAction = playAction;
        return this;
    }

    public ProgressPanelBuilder withPause(@NotNull Runnable pauseAction) {
        if (pauseAction == null) {
            ProgressPanelBuilder.$$$reportNull$$$0(3);
        }
        this.pauseAction = pauseAction;
        return this;
    }

    public ProgressPanelBuilder andSmallIcons() {
        this.smallVariant = true;
        return this;
    }

    public ProgressPanelBuilder withoutComment() {
        this.commentEnabled = false;
        return this;
    }

    @NotNull
    public ProgressPanelBuilder withText2() {
        this.text2Enabled = true;
        ProgressPanelBuilder progressPanelBuilder = this;
        if (progressPanelBuilder == null) {
            ProgressPanelBuilder.$$$reportNull$$$0(4);
        }
        return progressPanelBuilder;
    }

    public ProgressPanelBuilder withTopSeparator() {
        this.topSeparatorEnabled = true;
        return this;
    }

    @Override
    @NotNull
    public JPanel createPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, null, 0, 0);
        this.addToPanel(panel2, gc, false);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ProgressPanelBuilder.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @Override
    public boolean constrainsValid() {
        return true;
    }

    @Override
    public void addToPanel(JPanel panel2, GridBagConstraints gc, boolean splitColumns) {
        if (this.constrainsValid()) {
            new LabeledPanelImpl().addToPanel(panel2, gc);
        }
    }

    @Override
    public int gridWidth() {
        int width = this.labelAbove ? 1 : 2;
        width += this.cancelAction != null ? 1 : 0;
        return width += this.resumeAction != null && this.pauseAction != null ? 1 : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "playAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pauseAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/panel/ProgressPanelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/panel/ProgressPanelBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withText2";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withLabel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withCancel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withResume";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withPause";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class LabeledPanelImpl
    extends ProgressPanel {
        private final JLabel label;
        private final JLabel comment;
        private final JLabel text2;
        private @NlsContexts.DetailedDescription String myCommentText = this.emptyComment();
        private boolean myServiceComment = false;
        private final IconButton cancelIcon;
        private final IconButton resumeIcon;
        private final IconButton pauseIcon;
        private JButton myCancelButtonAsButton;
        private InplaceButton myCancelButton;
        private InplaceButton mySuspendButton;
        private final SeparatorComponent mySeparatorComponent = new SeparatorComponent(SEPARATOR_COLOR, SeparatorOrientation.HORIZONTAL);
        private ProgressPanel.State state = ProgressPanel.State.PLAYING;

        private LabeledPanelImpl() {
            this.label = new JLabel(StringUtil.isNotEmpty((String)ProgressPanelBuilder.this.initialLabelText) ? ProgressPanelBuilder.this.initialLabelText : " ");
            this.comment = new JLabel(this.myCommentText);
            this.comment.setForeground(UIUtil.getContextHelpForeground());
            if (ProgressPanelBuilder.this.text2Enabled) {
                this.text2 = new JLabel();
                this.text2.setForeground(UIUtil.getContextHelpForeground());
            } else {
                this.text2 = null;
            }
            if (SystemInfo.isMac) {
                Font font = this.comment.getFont();
                float size = font.getSize2D();
                Font smallFont = font.deriveFont(size - 2.0f);
                this.comment.setFont(smallFont);
                if (this.text2 != null) {
                    this.text2.setFont(smallFont);
                }
            }
            if (StringUtil.isNotEmpty((String)ProgressPanelBuilder.this.initialLabelText)) {
                Dimension size = this.comment.getPreferredSize();
                size.width = this.label.getMinimumSize().width;
                this.comment.setMinimumSize(size);
                if (this.text2 != null) {
                    this.text2.setMinimumSize(size);
                }
            }
            this.cancelIcon = new IconButton(null, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.StopSmall : AllIcons.Process.Stop, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.StopSmallHovered : AllIcons.Process.StopHovered);
            this.resumeIcon = new IconButton(null, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.ProgressResumeSmall : AllIcons.Process.ProgressResume, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.ProgressResumeSmallHover : AllIcons.Process.ProgressResumeHover);
            this.pauseIcon = new IconButton(null, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.ProgressPauseSmall : AllIcons.Process.ProgressPause, ProgressPanelBuilder.this.smallVariant ? AllIcons.Process.ProgressPauseSmallHover : AllIcons.Process.ProgressPauseHover);
        }

        private String emptyComment() {
            return ProgressPanelBuilder.this.commentEnabled ? " " : "";
        }

        @Override
        public String getLabelText() {
            return this.label.getText();
        }

        @Override
        public void setLabelText(String labelText) {
            this.label.setText(StringUtil.isNotEmpty((String)labelText) ? labelText : " ");
            if (StringUtil.isNotEmpty((String)labelText)) {
                Dimension size = this.comment.getPreferredSize();
                size.width = this.label.getMinimumSize().width;
                this.comment.setMinimumSize(size);
                if (this.text2 != null) {
                    this.text2.setMinimumSize(size);
                }
            }
        }

        @Override
        public String getCommentText() {
            return this.myServiceComment ? this.myCommentText : this.comment.getText();
        }

        @Override
        public void setCommentText(String commentText) {
            if (ProgressPanelBuilder.this.commentEnabled) {
                this.setCommentText(commentText, false);
            }
        }

        @Override
        public void setLabelEnabled(boolean enabled) {
            this.label.setEnabled(enabled);
        }

        @Override
        public void setCommentEnabled(boolean enabled) {
            this.comment.setEnabled(enabled);
        }

        @Override
        public void setText2(@Nullable String text) {
            if (this.text2 != null) {
                boolean empty = StringUtil.isEmpty((String)text);
                if (empty && !this.text2.isVisible()) {
                    return;
                }
                this.text2.setText(empty ? " " : text);
                this.text2.setVisible(true);
            }
        }

        @Override
        public void setText2Enabled(boolean enabled) {
            if (this.text2 != null) {
                this.text2.setEnabled(enabled);
            }
        }

        @Override
        public void setSeparatorEnabled(boolean enabled) {
            this.mySeparatorComponent.setVisible(enabled);
        }

        @Override
        @Nullable
        public JButton getCancelButtonAsButton() {
            return this.myCancelButtonAsButton;
        }

        @Override
        @Nullable
        public InplaceButton getCancelButton() {
            return this.myCancelButton;
        }

        @Override
        @Nullable
        public InplaceButton getSuspendButton() {
            return this.mySuspendButton;
        }

        private void setCommentText(String commentText, boolean serviceComment) {
            if (serviceComment) {
                this.myServiceComment = commentText != null;
                this.comment.setText(commentText == null ? this.myCommentText : commentText);
            } else {
                String string = this.myCommentText = StringUtil.isNotEmpty((String)commentText) ? commentText : this.emptyComment();
                if (!this.myServiceComment) {
                    this.comment.setText(this.myCommentText);
                }
            }
        }

        @Override
        @NotNull
        public ProgressPanel.State getState() {
            ProgressPanel.State state = this.state;
            if (state == null) {
                LabeledPanelImpl.$$$reportNull$$$0(0);
            }
            return state;
        }

        @Override
        public void setState(@NotNull ProgressPanel.State state) {
            if (state == null) {
                LabeledPanelImpl.$$$reportNull$$$0(1);
            }
            if (this.state == state || state == ProgressPanel.State.CANCELLED || this.mySuspendButton == null) {
                return;
            }
            this.state = state;
            if (state == ProgressPanel.State.PLAYING) {
                this.mySuspendButton.setIcons(this.pauseIcon);
                this.setCommentText(null, true);
            } else {
                this.mySuspendButton.setIcons(this.resumeIcon);
                this.setCommentText(IdeBundle.message("comment.text.paused", new Object[0]), true);
            }
            this.mySuspendButton.revalidate();
            this.mySuspendButton.repaint();
        }

        private void addToPanel(JPanel panel2, GridBagConstraints gc) {
            gc.gridx = 0;
            gc.anchor = 21;
            gc.fill = 2;
            if (ProgressPanelBuilder.this.topSeparatorEnabled) {
                gc.insets = JBUI.insets((int)14, (int)0, (int)10, (int)0);
                gc.gridwidth = ProgressPanelBuilder.this.gridWidth();
                gc.weightx = 1.0;
                panel2.add((Component)this.mySeparatorComponent, gc);
                ++gc.gridy;
            }
            gc.weightx = 0.0;
            gc.gridwidth = 1;
            gc.insets = JBUI.insets((int)(ProgressPanelBuilder.this.topSeparatorEnabled || ProgressPanelBuilder.this.smallVariant ? 0 : 12), (int)13, (int)0, (int)(ProgressPanelBuilder.this.labelAbove ? 13 : 0));
            panel2.add((Component)this.label, gc);
            if (ProgressPanelBuilder.this.labelAbove) {
                gc.insets = JBUI.insets((int)4, (int)13, (int)4, (int)0);
                ++gc.gridy;
            } else {
                gc.insets = JBUI.insets((int)(ProgressPanelBuilder.this.topSeparatorEnabled || ProgressPanelBuilder.this.smallVariant ? 2 : 14), (int)12, (int)0, (int)0);
                ++gc.gridx;
            }
            gc.weightx = 1.0;
            panel2.add((Component)ProgressPanelBuilder.this.myProgressBar, gc);
            ++gc.gridx;
            ProgressPanelBuilder.this.myProgressBar.putClientProperty("JComponent.decoratedPanel", this);
            gc.weightx = 0.0;
            gc.insets = JBUI.insets((int)(ProgressPanelBuilder.this.labelAbove || ProgressPanelBuilder.this.topSeparatorEnabled || ProgressPanelBuilder.this.smallVariant ? 1 : 14), (int)(UIUtil.isUnderWin10LookAndFeel() ? 9 : 10), (int)0, (int)13);
            if (ProgressPanelBuilder.this.cancelAction != null) {
                if (ProgressPanelBuilder.this.cancelAsButton) {
                    this.myCancelButtonAsButton = new JButton(ProgressPanelBuilder.this.cancelText);
                    this.myCancelButtonAsButton.addActionListener(e -> ProgressPanelBuilder.this.cancelAction.run());
                    panel2.add((Component)this.myCancelButtonAsButton, gc);
                } else {
                    this.myCancelButton = new InplaceButton(this.cancelIcon, a -> {
                        this.myCancelButton.setPainting(false);
                        this.state = ProgressPanel.State.CANCELLED;
                        ProgressPanelBuilder.this.cancelAction.run();
                    }).setFillBg(false);
                }
            }
            if (ProgressPanelBuilder.this.resumeAction != null && ProgressPanelBuilder.this.pauseAction != null) {
                this.mySuspendButton = new InplaceButton(this.pauseIcon, a -> {
                    if (this.state == ProgressPanel.State.CANCELLED) {
                        return;
                    }
                    if (this.state == ProgressPanel.State.PLAYING) {
                        this.mySuspendButton.setIcons(this.resumeIcon);
                        this.state = ProgressPanel.State.PAUSED;
                        this.setCommentText(IdeBundle.message("comment.text.resume", new Object[0]), true);
                        ProgressPanelBuilder.this.pauseAction.run();
                    } else {
                        this.mySuspendButton.setIcons(this.pauseIcon);
                        this.state = ProgressPanel.State.PLAYING;
                        this.setCommentText(IdeBundle.message("comment.text.pause", new Object[0]), true);
                        ProgressPanelBuilder.this.resumeAction.run();
                    }
                }).setFillBg(false);
            }
            if (this.mySuspendButton != null) {
                this.addButton(panel2, gc, this.mySuspendButton, false);
            }
            if (this.myCancelButton != null) {
                if (this.mySuspendButton != null) {
                    ++gc.gridx;
                }
                this.addButton(panel2, gc, this.myCancelButton, true);
            }
            if (ProgressPanelBuilder.this.commentEnabled) {
                this.addLabel(panel2, gc, this.comment);
            }
            if (this.text2 != null) {
                this.addLabel(panel2, gc, this.text2);
                this.text2.setVisible(false);
            }
            ++gc.gridy;
        }

        private void addLabel(@NotNull JPanel panel2, @NotNull GridBagConstraints gc, @NotNull JComponent label) {
            if (panel2 == null) {
                LabeledPanelImpl.$$$reportNull$$$0(2);
            }
            if (gc == null) {
                LabeledPanelImpl.$$$reportNull$$$0(3);
            }
            if (label == null) {
                LabeledPanelImpl.$$$reportNull$$$0(4);
            }
            ++gc.gridy;
            gc.gridx = ProgressPanelBuilder.this.labelAbove ? 0 : 1;
            gc.insets = ProgressPanelBuilder.this.labelAbove ? JBUI.insets((int)-1, (int)13, (int)0, (int)13) : JBUI.insets((int)-1, (int)12, (int)0, (int)13);
            gc.weightx = 1.0;
            gc.anchor = 21;
            gc.fill = 2;
            panel2.add((Component)label, gc);
        }

        private void addButton(@NotNull JPanel panel2, @NotNull GridBagConstraints gc, @NotNull InplaceButton button, boolean cancel) {
            if (panel2 == null) {
                LabeledPanelImpl.$$$reportNull$$$0(5);
            }
            if (gc == null) {
                LabeledPanelImpl.$$$reportNull$$$0(6);
            }
            if (button == null) {
                LabeledPanelImpl.$$$reportNull$$$0(7);
            }
            button.setMinimumSize(button.getPreferredSize());
            if (ProgressPanelBuilder.this.commentEnabled) {
                button.addMouseListener(new HoverListener(cancel));
            }
            gc.anchor = 13;
            gc.fill = 0;
            panel2.add((Component)button, gc);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/panel/ProgressPanelBuilder$LabeledPanelImpl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gc";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "button";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/panel/ProgressPanelBuilder$LabeledPanelImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addLabel";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addButton";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private final class HoverListener
        extends MouseAdapter {
            private final boolean myCancel;

            private HoverListener(boolean cancel) {
                this.myCancel = cancel;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (this.myCancel) {
                    LabeledPanelImpl.this.setCommentText(ProgressPanelBuilder.this.cancelText, true);
                } else {
                    LabeledPanelImpl.this.setCommentText(LabeledPanelImpl.this.state == ProgressPanel.State.PLAYING ? IdeBundle.message("comment.text.pause", new Object[0]) : IdeBundle.message("comment.text.resume", new Object[0]), true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LabeledPanelImpl.this.setCommentText(LabeledPanelImpl.this.state == ProgressPanel.State.PAUSED ? IdeBundle.message("comment.text.paused", new Object[0]) : null, true);
            }
        }
    }
}

