/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection.metadata;

import com.intellij.internal.statistic.StatisticsStringUtil;
import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupRemoteDescriptors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventGroupFilterRules {
    private final List<BuildRange> builds;
    private final List<VersionRange> versions;

    public EventGroupFilterRules(@NotNull List<BuildRange> builds, @NotNull List<VersionRange> versions) {
        if (builds == null) {
            EventGroupFilterRules.$$$reportNull$$$0(0);
        }
        if (versions == null) {
            EventGroupFilterRules.$$$reportNull$$$0(1);
        }
        this.builds = builds;
        this.versions = versions;
    }

    @NotNull
    public static EventGroupFilterRules create(@NotNull EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group) {
        if (group == null) {
            EventGroupFilterRules.$$$reportNull$$$0(2);
        }
        return EventGroupFilterRules.create(group.builds, group.versions);
    }

    @NotNull
    private static EventGroupFilterRules create(@Nullable List<EventGroupRemoteDescriptors.GroupBuildRange> builds, @Nullable List<EventGroupRemoteDescriptors.GroupVersionRange> versions) {
        List<BuildRange> buildRanges = builds != null && !builds.isEmpty() ? EventGroupFilterRules.toBuildRanges(builds) : Collections.emptyList();
        List<VersionRange> versionRanges = versions != null && !versions.isEmpty() ? EventGroupFilterRules.toVersionRanges(versions) : Collections.emptyList();
        return new EventGroupFilterRules(buildRanges, versionRanges);
    }

    @NotNull
    private static List<BuildRange> toBuildRanges(@NotNull List<EventGroupRemoteDescriptors.GroupBuildRange> builds) {
        if (builds == null) {
            EventGroupFilterRules.$$$reportNull$$$0(3);
        }
        ArrayList<BuildRange> result = new ArrayList<BuildRange>();
        for (EventGroupRemoteDescriptors.GroupBuildRange build : builds) {
            result.add(BuildRange.create(build.from, build.to));
        }
        ArrayList<BuildRange> arrayList = result;
        if (arrayList == null) {
            EventGroupFilterRules.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static List<VersionRange> toVersionRanges(@NotNull List<EventGroupRemoteDescriptors.GroupVersionRange> versions) {
        if (versions == null) {
            EventGroupFilterRules.$$$reportNull$$$0(5);
        }
        ArrayList<VersionRange> result = new ArrayList<VersionRange>();
        for (EventGroupRemoteDescriptors.GroupVersionRange version : versions) {
            result.add(VersionRange.create(version.from, version.to));
        }
        ArrayList<VersionRange> arrayList = result;
        if (arrayList == null) {
            EventGroupFilterRules.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public boolean accepts(@Nullable EventLogBuild build, int version) {
        return this.accepts(build) && this.acceptsVersion(version);
    }

    public boolean accepts(@Nullable EventLogBuild build) {
        if (!this.isValid()) {
            return false;
        }
        return this.acceptsBuild(build);
    }

    private boolean acceptsBuild(@Nullable EventLogBuild build) {
        if (this.builds.isEmpty()) {
            return true;
        }
        return build != null && this.builds.stream().anyMatch(b -> b.contains(build));
    }

    private boolean acceptsVersion(int version) {
        if (this.versions.isEmpty()) {
            return true;
        }
        return version > 0 && this.versions.stream().anyMatch(v -> v.contains(version));
    }

    private boolean isValid() {
        return !this.builds.isEmpty() || !this.versions.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventGroupFilterRules condition = (EventGroupFilterRules)o;
        return Objects.equals(this.builds, condition.builds) && Objects.equals(this.versions, condition.versions);
    }

    public int hashCode() {
        return Objects.hash(this.builds, this.versions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builds";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/connection/metadata/EventGroupFilterRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/connection/metadata/EventGroupFilterRules";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toBuildRanges";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toVersionRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toBuildRanges";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toVersionRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VersionRange {
        private final int myFrom;
        private final int myTo;

        public VersionRange(int from, int to) {
            this.myFrom = from;
            this.myTo = to;
        }

        @NotNull
        public static VersionRange create(@Nullable String from, @Nullable String to) {
            return new VersionRange(from == null ? 0 : VersionRange.tryToParse(from, Integer.MAX_VALUE), to == null ? Integer.MAX_VALUE : VersionRange.tryToParse(to, 0));
        }

        private static int tryToParse(@Nullable String value, int defaultValue) {
            try {
                if (value != null) {
                    return Integer.parseInt(value.trim());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return defaultValue;
        }

        public boolean contains(int current) {
            return current >= this.myFrom && current < this.myTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionRange range = (VersionRange)o;
            return this.myFrom == range.myFrom && this.myTo == range.myTo;
        }

        public int hashCode() {
            return Objects.hash(this.myFrom, this.myTo);
        }
    }

    public static class BuildRange {
        private final EventLogBuild myFrom;
        private final EventLogBuild myTo;

        public BuildRange(@Nullable EventLogBuild from, @Nullable EventLogBuild to) {
            this.myFrom = from;
            this.myTo = to;
        }

        @NotNull
        public static BuildRange create(@Nullable String from, @Nullable String to) {
            return new BuildRange(StatisticsStringUtil.isNotEmpty((String)from) ? EventLogBuild.fromString((String)from) : null, StatisticsStringUtil.isNotEmpty((String)to) ? EventLogBuild.fromString((String)to) : null);
        }

        public boolean contains(@NotNull EventLogBuild build) {
            if (build == null) {
                BuildRange.$$$reportNull$$$0(0);
            }
            if (this.myTo == null && this.myFrom == null) {
                return false;
            }
            return !(this.myTo != null && this.myTo.compareTo(build) <= 0 || this.myFrom != null && this.myFrom.compareTo(build) > 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuildRange range = (BuildRange)o;
            return Objects.equals(this.myFrom, range.myFrom) && Objects.equals(this.myTo, range.myTo);
        }

        public int hashCode() {
            return Objects.hash(this.myFrom, this.myTo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "build", "com/intellij/internal/statistic/eventLog/connection/metadata/EventGroupFilterRules$BuildRange", "contains"));
        }
    }
}

