/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreemptiveSafeFileOutputStream
extends OutputStream {
    private static final String TEMP_EXT = ".tmp";
    private static final String BACKUP_EXT = "~";
    private static final OpenOption[] TEMP_WRITE = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DSYNC};
    private static final CopyOption[] RENAME = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
    private final Path myTarget;
    private final Path myTemp;
    private final OutputStream myOutputStream;
    private boolean myFailed;
    private boolean myClosed;

    public PreemptiveSafeFileOutputStream(@NotNull Path target) throws IOException {
        if (target == null) {
            PreemptiveSafeFileOutputStream.$$$reportNull$$$0(0);
        }
        this.myFailed = false;
        this.myClosed = false;
        this.myTarget = target;
        this.myTemp = this.myTarget.getFileSystem().getPath(this.myTarget + TEMP_EXT, new String[0]);
        this.myOutputStream = Files.newOutputStream(this.myTemp, TEMP_WRITE);
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.myOutputStream.write(b);
        }
        catch (IOException e) {
            this.myFailed = true;
            throw e;
        }
    }

    @Override
    public void write(byte @NotNull [] b, int off, int len) throws IOException {
        if (b == null) {
            PreemptiveSafeFileOutputStream.$$$reportNull$$$0(1);
        }
        try {
            this.myOutputStream.write(b, off, len);
        }
        catch (IOException e) {
            this.myFailed = true;
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.myOutputStream.flush();
        }
        catch (IOException e) {
            this.myFailed = true;
            throw e;
        }
    }

    public void abort() {
        if (this.myClosed) {
            return;
        }
        this.myClosed = true;
        try {
            this.myOutputStream.close();
        }
        catch (IOException e) {
            Logger.getInstance(this.getClass()).warn(e);
        }
        PreemptiveSafeFileOutputStream.deleteFile(this.myTemp);
    }

    @Override
    public void close() throws IOException {
        if (this.myClosed) {
            return;
        }
        this.myClosed = true;
        try {
            this.myOutputStream.close();
        }
        catch (IOException e) {
            PreemptiveSafeFileOutputStream.deleteFile(this.myTemp);
            this.error("Cannot write a temporary file " + this.myTemp.getFileName(), e);
        }
        if (this.myFailed) {
            PreemptiveSafeFileOutputStream.deleteFile(this.myTemp);
            this.error("Cannot write a temporary file " + this.myTemp.getFileName(), null);
        }
        Path backup = null;
        if (Files.exists(this.myTarget, new LinkOption[0])) {
            backup = this.myTarget.getFileSystem().getPath(this.myTarget + BACKUP_EXT, new String[0]);
            try {
                Files.move(this.myTarget, backup, RENAME);
            }
            catch (IOException e) {
                PreemptiveSafeFileOutputStream.deleteFile(this.myTemp);
                this.error("Cannot create a backup file " + backup.getFileName() + ".\nThe original file is unchanged; new data are written into " + this.myTemp.getFileName(), e);
            }
        }
        try {
            Files.move(this.myTemp, this.myTarget, RENAME);
        }
        catch (IOException e) {
            if (backup == null) {
                this.error("Cannot rename a temporary file " + this.myTemp.getFileName(), e);
            }
            try {
                Files.move(backup, this.myTarget, RENAME);
            }
            catch (IOException ee) {
                this.error("Cannot rename a temporary file " + this.myTemp.getFileName() + ".\nThe original file was renamed into " + backup.getFileName() + "; new data are written into " + this.myTemp.getFileName(), e);
            }
            this.error("Cannot rename a temporary file " + this.myTemp.getFileName() + ".\nThe original file was restored from a backup; new data are written into " + this.myTemp.getFileName(), e);
        }
        if (backup != null) {
            PreemptiveSafeFileOutputStream.deleteFile(backup);
        }
    }

    @Contract(value="_, _ -> fail")
    private void error(String text, @Nullable IOException e) throws IOException {
        throw new IOException("Cannot save " + this.myTarget + ".\n" + text, e);
    }

    private static void deleteFile(Path file) {
        try {
            Files.delete(file);
        }
        catch (IOException e) {
            Logger.getInstance(PreemptiveSafeFileOutputStream.class).warn("cannot delete " + file, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/PreemptiveSafeFileOutputStream";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

