/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.facet;

import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.module.JpsModule;

public abstract class JpsFacetConfigurationSerializer<E extends JpsElement> {
    private final JpsElementChildRole<E> myRole;
    private final String myFacetTypeId;
    private final String myFacetName;

    public JpsFacetConfigurationSerializer(JpsElementChildRole<E> role, String facetTypeId, @Nullable String facetName) {
        this.myRole = role;
        this.myFacetTypeId = facetTypeId;
        this.myFacetName = facetName;
    }

    public String getFacetTypeId() {
        return this.myFacetTypeId;
    }

    public E loadExtension(Element configurationElement, String facetName, JpsModule module, JpsElement parentFacet) {
        E e = this.loadExtension(configurationElement, facetName, parentFacet, module);
        return (E)module.getContainer().setChild(this.myRole, e);
    }

    protected abstract E loadExtension(@NotNull Element var1, String var2, JpsElement var3, JpsModule var4);

    public boolean hasExtension(JpsModule module) {
        return module.getContainer().getChild(this.myRole) != null;
    }

    @Deprecated
    protected void saveExtension(E extension, Element facetConfigurationTag, JpsModule module) {
    }
}

