/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScriptTargetedCommandLineBuilder;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.rest.run.RestRunConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RestCommandLineState
extends PythonCommandLineState {
    protected final RestRunConfiguration myConfiguration;

    public RestCommandLineState(RestRunConfiguration configuration, ExecutionEnvironment env) {
        super(configuration, env);
        this.myConfiguration = configuration;
    }

    @Override
    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
        ParametersList parametersList = commandLine.getParametersList();
        ParamsGroup exeOptions = parametersList.getParamsGroup("Exe Options");
        assert (exeOptions != null);
        exeOptions.addParametersString(this.myConfiguration.getInterpreterOptions());
        ParamsGroup scriptParameters = parametersList.getParamsGroup("Script");
        assert (scriptParameters != null);
        this.getRunner().addToGroup(scriptParameters, commandLine);
        String key = this.getKey();
        if (key != null) {
            scriptParameters.addParameter(key);
        }
        scriptParameters.addParameter(this.getTask());
        String params = this.myConfiguration.getParams();
        if (params != null) {
            scriptParameters.addParametersString(params);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfiguration.getInputFile())) {
            scriptParameters.addParameter(this.myConfiguration.getInputFile());
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfiguration.getOutputFile())) {
            scriptParameters.addParameter(this.myConfiguration.getOutputFile());
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfiguration.getWorkingDirectory())) {
            commandLine.setWorkDirectory(this.myConfiguration.getWorkingDirectory());
        }
    }

    @Override
    @NotNull
    protected PythonExecution buildPythonExecution(@NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        if (targetEnvironmentRequest == null) {
            RestCommandLineState.$$$reportNull$$$0(0);
        }
        PythonScriptExecution pythonScriptExecution = PythonScripts.prepareHelperScriptExecution(this.getRunner(), targetEnvironmentRequest);
        String key = this.getKey();
        if (key != null) {
            pythonScriptExecution.addParameter(key);
        }
        pythonScriptExecution.addParameter(this.getTask());
        String params = this.myConfiguration.getParams();
        if (params != null) {
            PythonScripts.addParametersString(pythonScriptExecution, params);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfiguration.getInputFile())) {
            pythonScriptExecution.addParameter(this.myConfiguration.getInputFile());
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfiguration.getOutputFile())) {
            pythonScriptExecution.addParameter(this.myConfiguration.getOutputFile());
        }
        PythonScriptExecution pythonScriptExecution2 = pythonScriptExecution;
        if (pythonScriptExecution2 == null) {
            RestCommandLineState.$$$reportNull$$$0(1);
        }
        return pythonScriptExecution2;
    }

    @Override
    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        final Runnable afterTask = this.getAfterTask();
        ProcessHandler processHandler = PythonProcessRunner.createProcess(commandLine, false);
        if (afterTask != null) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(afterTask);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/rest/run/RestCommandLineState$1", "processTerminated"));
                }
            });
        }
        return processHandler;
    }

    @Override
    @NotNull
    protected ProcessHandler startProcess(@NotNull PythonScriptTargetedCommandLineBuilder builder) throws ExecutionException {
        if (builder == null) {
            RestCommandLineState.$$$reportNull$$$0(2);
        }
        final Runnable afterTask = this.getAfterTask();
        ProcessHandler processHandler = super.startProcess(builder);
        if (afterTask != null) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(afterTask);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/rest/run/RestCommandLineState$2", "processTerminated"));
                }
            });
        }
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            RestCommandLineState.$$$reportNull$$$0(3);
        }
        return processHandler2;
    }

    @Nullable
    protected Runnable getAfterTask() {
        return null;
    }

    @Nullable
    protected VirtualFile findOutput() {
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfiguration.getOutputFile())) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myConfiguration.getOutputFile());
            if (virtualFile == null) {
                virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myConfiguration.getWorkingDirectory() + this.myConfiguration.getOutputFile());
            }
            return virtualFile;
        }
        return null;
    }

    protected abstract HelperPackage getRunner();

    protected abstract String getTask();

    @Nullable
    protected abstract String getKey();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironmentRequest";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/rest/run/RestCommandLineState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/rest/run/RestCommandLineState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPythonExecution";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildPythonExecution";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

