/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ThreeState;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.testing.PyPsiLocationWithFixedClass;
import com.jetbrains.python.testing.PythonUnitTestDetectorsBasedOnSettings;
import com.jetbrains.python.testing.PythonUnitTestDetectorsKt;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonUnitTestUtil {
    private PythonUnitTestUtil() {
    }

    public static List<Location> findLocations(@NotNull Project project, @NotNull String fileName, @Nullable String className, @Nullable String methodName) {
        ArrayList<Location> locations;
        block10: {
            block9: {
                if (project == null) {
                    PythonUnitTestUtil.$$$reportNull$$$0(0);
                }
                if (fileName == null) {
                    PythonUnitTestUtil.$$$reportNull$$$0(1);
                }
                if (fileName.contains("%")) {
                    fileName = fileName.substring(0, fileName.lastIndexOf("%"));
                }
                locations = new ArrayList<Location>();
                if (methodName == null && className == null) {
                    VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(fileName);
                    if (virtualFile == null) {
                        return locations;
                    }
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (psiFile != null) {
                        locations.add((Location)new PsiLocation(project, (PsiElement)psiFile));
                    }
                }
                if (className == null) break block9;
                for (PyClass cls : PyClassNameIndex.find(className, project, false)) {
                    ProgressManager.checkCanceled();
                    PsiFile containingFile = cls.getContainingFile();
                    VirtualFile virtualFile = containingFile.getVirtualFile();
                    String clsFileName = virtualFile == null ? containingFile.getName() : virtualFile.getPath();
                    String clsFileNameWithoutExt = FileUtilRt.getNameWithoutExtension((String)clsFileName);
                    if (!clsFileNameWithoutExt.endsWith(fileName) && !fileName.equals(clsFileName)) continue;
                    if (methodName == null) {
                        locations.add((Location)new PsiLocation(project, (PsiElement)cls));
                        continue;
                    }
                    PyFunction method = cls.findMethodByName(methodName, true, null);
                    if (method == null) continue;
                    locations.add((Location)new PyPsiLocationWithFixedClass(project, method, cls));
                }
                break block10;
            }
            if (methodName == null) break block10;
            for (PyFunction function : PyFunctionNameIndex.find(methodName, project)) {
                PsiFile containingFile;
                VirtualFile virtualFile;
                String clsFileName;
                String clsFileNameWithoutExt;
                ProgressManager.checkCanceled();
                if (function.getContainingClass() != null || !(clsFileNameWithoutExt = FileUtilRt.getNameWithoutExtension((String)(clsFileName = (virtualFile = (containingFile = function.getContainingFile()).getVirtualFile()) == null ? containingFile.getName() : virtualFile.getPath()))).endsWith(fileName)) continue;
                locations.add((Location)new PsiLocation(project, (PsiElement)function));
            }
        }
        return locations;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isUnitTestCaseClass(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            PythonUnitTestUtil.$$$reportNull$$$0(2);
        }
        return PythonUnitTestDetectorsKt.isUnitTestCaseClass(pyClass, TypeEvalContext.codeInsightFallback(pyClass.getProject()));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isTestClass(@NotNull PyClass cls, @NotNull ThreeState testCaseClassRequired, @Nullable TypeEvalContext context) {
        if (cls == null) {
            PythonUnitTestUtil.$$$reportNull$$$0(3);
        }
        if (testCaseClassRequired == null) {
            PythonUnitTestUtil.$$$reportNull$$$0(4);
        }
        return PythonUnitTestDetectorsBasedOnSettings.isTestClass(cls, testCaseClassRequired, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseClassRequired";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/testing/PythonUnitTestUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findLocations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnitTestCaseClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

