/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.jetbrains.python.PythonPluginDisposable;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkAdditionalData
implements SdkAdditionalData {
    @NonNls
    private static final String PATHS_ADDED_BY_USER_ROOT = "PATHS_ADDED_BY_USER_ROOT";
    @NonNls
    private static final String PATH_ADDED_BY_USER = "PATH_ADDED_BY_USER";
    @NonNls
    private static final String PATHS_REMOVED_BY_USER_ROOT = "PATHS_REMOVED_BY_USER_ROOT";
    @NonNls
    private static final String PATH_REMOVED_BY_USER = "PATH_REMOVED_BY_USER";
    @NonNls
    private static final String ASSOCIATED_PROJECT_PATH = "ASSOCIATED_PROJECT_PATH";
    private final VirtualFilePointerContainer myAddedPaths;
    private final VirtualFilePointerContainer myExcludedPaths;
    private final PythonSdkFlavor myFlavor;
    private String myAssociatedModulePath;

    public PythonSdkAdditionalData(@Nullable PythonSdkFlavor flavor) {
        this.myFlavor = flavor;
        this.myAddedPaths = VirtualFilePointerManager.getInstance().createContainer(PythonPluginDisposable.getInstance());
        this.myExcludedPaths = VirtualFilePointerManager.getInstance().createContainer(PythonPluginDisposable.getInstance());
    }

    protected PythonSdkAdditionalData(@NotNull PythonSdkAdditionalData from) {
        if (from == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(0);
        }
        this.myFlavor = from.getFlavor();
        this.myAddedPaths = from.myAddedPaths.clone(PythonPluginDisposable.getInstance());
        this.myExcludedPaths = from.myExcludedPaths.clone(PythonPluginDisposable.getInstance());
        this.myAssociatedModulePath = from.myAssociatedModulePath;
    }

    @NotNull
    public PythonSdkAdditionalData copy() {
        return new PythonSdkAdditionalData(this);
    }

    public void setAddedPathsFromVirtualFiles(@NotNull Set<VirtualFile> addedPaths) {
        if (addedPaths == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(1);
        }
        this.myAddedPaths.killAll();
        for (VirtualFile file : addedPaths) {
            this.myAddedPaths.add(file);
        }
    }

    public void setExcludedPathsFromVirtualFiles(@NotNull Set<VirtualFile> addedPaths) {
        if (addedPaths == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(2);
        }
        this.myExcludedPaths.killAll();
        for (VirtualFile file : addedPaths) {
            this.myExcludedPaths.add(file);
        }
    }

    public String getAssociatedModulePath() {
        return this.myAssociatedModulePath;
    }

    public void resetAssociatedModulePath() {
        this.setAssociatedModulePath(null);
    }

    public void setAssociatedModulePath(@Nullable String associatedModulePath) {
        this.myAssociatedModulePath = associatedModulePath;
    }

    public void associateWithModule(@NotNull Module module) {
        String path;
        if (module == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(3);
        }
        if ((path = BasePySdkExtKt.getBasePath(module)) != null) {
            this.associateWithModulePath(path);
        }
    }

    public void associateWithModulePath(@NotNull String modulePath) {
        if (modulePath == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(4);
        }
        this.myAssociatedModulePath = FileUtil.toSystemIndependentName((String)modulePath);
    }

    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(5);
        }
        PythonSdkAdditionalData.savePaths(rootElement, this.myAddedPaths, PATHS_ADDED_BY_USER_ROOT, PATH_ADDED_BY_USER);
        PythonSdkAdditionalData.savePaths(rootElement, this.myExcludedPaths, PATHS_REMOVED_BY_USER_ROOT, PATH_REMOVED_BY_USER);
        if (this.myAssociatedModulePath != null) {
            rootElement.setAttribute(ASSOCIATED_PROJECT_PATH, this.myAssociatedModulePath);
        }
    }

    private static void savePaths(Element rootElement, VirtualFilePointerContainer paths2, String root, String element) {
        for (String addedPath : paths2.getUrls()) {
            Element child = new Element(root);
            child.setAttribute(element, addedPath);
            rootElement.addContent(child);
        }
    }

    @Nullable
    public PythonSdkFlavor getFlavor() {
        return this.myFlavor;
    }

    @NotNull
    public static PythonSdkAdditionalData load(Sdk sdk, @Nullable Element element) {
        PythonSdkAdditionalData data = new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor(sdk.getHomePath()));
        data.load(element);
        PythonSdkAdditionalData pythonSdkAdditionalData = data;
        if (pythonSdkAdditionalData == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(6);
        }
        return pythonSdkAdditionalData;
    }

    protected void load(@Nullable Element element) {
        PythonSdkAdditionalData.collectPaths(JDOMExternalizer.loadStringsList((Element)element, (String)PATHS_ADDED_BY_USER_ROOT, (String)PATH_ADDED_BY_USER), this.myAddedPaths);
        PythonSdkAdditionalData.collectPaths(JDOMExternalizer.loadStringsList((Element)element, (String)PATHS_REMOVED_BY_USER_ROOT, (String)PATH_REMOVED_BY_USER), this.myExcludedPaths);
        if (element != null) {
            this.setAssociatedModulePath(element.getAttributeValue(ASSOCIATED_PROJECT_PATH));
        }
    }

    private static void collectPaths(@NotNull List<String> paths2, VirtualFilePointerContainer container) {
        if (paths2 == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(7);
        }
        for (String path : paths2) {
            if (StringUtil.isEmpty((String)path)) continue;
            String protocol = VirtualFileManager.extractProtocol((String)path);
            String url = protocol != null ? path : VirtualFileManager.constructUrl((String)"file", (String)path);
            container.add(url);
        }
    }

    public Set<VirtualFile> getAddedPathFiles() {
        return PythonSdkAdditionalData.getPathsAsVirtualFiles(this.myAddedPaths);
    }

    public Set<VirtualFile> getExcludedPathFiles() {
        return PythonSdkAdditionalData.getPathsAsVirtualFiles(this.myExcludedPaths);
    }

    private static Set<VirtualFile> getPathsAsVirtualFiles(VirtualFilePointerContainer paths2) {
        HashSet<VirtualFile> ret = new HashSet<VirtualFile>();
        Collections.addAll(ret, paths2.getFiles());
        return ret;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedPaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkAdditionalData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkAdditionalData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setAddedPathsFromVirtualFiles";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setExcludedPathsFromVirtualFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "associateWithModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "associateWithModulePath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

