/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.stubs.PyStarImportElementStub;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.toolbox.ChainIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PyStarImportElementImpl
extends PyBaseElementImpl<PyStarImportElementStub>
implements PyStarImportElement {
    public PyStarImportElementImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyStarImportElementImpl(PyStarImportElementStub stub) {
        super(stub, PyElementTypes.STAR_IMPORT_ELEMENT);
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        if (this.getParent() instanceof PyFromImportStatement) {
            PyFromImportStatement fromImportStatement = (PyFromImportStatement)this.getParent();
            List<PsiElement> importedFiles = fromImportStatement.resolveImportSourceCandidates();
            ChainIterable<PyElement> chain = new ChainIterable<PyElement>();
            for (PsiElement importedFile : new HashSet<PsiElement>(importedFiles)) {
                PsiElement source = PyUtil.turnDirIntoInit(importedFile);
                if (!(source instanceof PyFile)) continue;
                PyFile sourceFile = (PyFile)source;
                chain.add(PyStarImportElementImpl.filterStarImportableNames(sourceFile.iterateNames(), sourceFile));
            }
            ChainIterable<PyElement> chainIterable = chain;
            if (chainIterable == null) {
                PyStarImportElementImpl.$$$reportNull$$$0(0);
            }
            return chainIterable;
        }
        List<PyElement> list = Collections.emptyList();
        if (list == null) {
            PyStarImportElementImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private static Iterable<PyElement> filterStarImportableNames(@NotNull Iterable<PyElement> declaredNames, @NotNull PyFile file) {
        if (declaredNames == null) {
            PyStarImportElementImpl.$$$reportNull$$$0(2);
        }
        if (file == null) {
            PyStarImportElementImpl.$$$reportNull$$$0(3);
        }
        Iterable iterable = Iterables.filter(declaredNames, input -> {
            String name = input != null ? input.getName() : null;
            return name != null && PyUtil.isStarImportableFrom(name, file);
        });
        if (iterable == null) {
            PyStarImportElementImpl.$$$reportNull$$$0(4);
        }
        return iterable;
    }

    @Override
    @NotNull
    public List<RatedResolveResult> multiResolveName(@NotNull String name) {
        if (name == null) {
            PyStarImportElementImpl.$$$reportNull$$$0(5);
        }
        List list = (List)PyUtil.getParameterizedCachedValue((PsiElement)this, name, this::calculateMultiResolveName);
        if (list == null) {
            PyStarImportElementImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private List<RatedResolveResult> calculateMultiResolveName(@NotNull String name) {
        PsiElement parent;
        if (name == null) {
            PyStarImportElementImpl.$$$reportNull$$$0(7);
        }
        if ((parent = this.getParentByStub()) instanceof PyFromImportStatement) {
            PyFromImportStatement fromImportStatement = (PyFromImportStatement)parent;
            List<PsiElement> importedFiles = fromImportStatement.resolveImportSourceCandidates();
            for (PsiElement importedFile : new HashSet<PsiElement>(importedFiles)) {
                PyModuleType moduleType;
                List<? extends RatedResolveResult> results;
                PyFile sourceFile = PyUtil.as(PyUtil.turnDirIntoInit(importedFile), PyFile.class);
                if (sourceFile == null || !PyUtil.isStarImportableFrom(name, sourceFile) || ContainerUtil.isEmpty(results = (moduleType = new PyModuleType(sourceFile)).resolveMember(name, null, AccessDirection.READ, PyResolveContext.defaultContext()))) continue;
                ArrayList arrayList = Lists.newArrayList(results);
                if (arrayList == null) {
                    PyStarImportElementImpl.$$$reportNull$$$0(8);
                }
                return arrayList;
            }
        }
        List<RatedResolveResult> list = Collections.emptyList();
        if (list == null) {
            PyStarImportElementImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            private String getName() {
                PyReferenceExpression imp_src;
                PyFromImportStatement elt = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)PyStarImportElementImpl.this, PyFromImportStatement.class);
                if (elt != null && (imp_src = elt.getImportSource()) != null) {
                    return PyPsiUtils.toPath(imp_src);
                }
                return "<?>";
            }

            public String getPresentableText() {
                return this.getName();
            }

            public String getLocationString() {
                return "| from " + this.getName() + " import *";
            }

            public Icon getIcon(boolean open2) {
                return null;
            }
        };
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyStarImportElement(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyStarImportElementImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateNames";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyStarImportElementImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterStarImportableNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMultiResolveName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterStarImportableNames";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateMultiResolveName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

