/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.attach;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.attach.XLocalAttachDebugger;
import com.intellij.xdebugger.attach.XLocalAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XLocalAttachGroup;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.attach.PyAttachToProcessDebugRunner;
import com.jetbrains.python.debugger.attach.PyLocalAttachGroup;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PyLocalAttachDebuggerProvider
implements XLocalAttachDebuggerProvider {
    private static final Key<List<XLocalAttachDebugger>> DEBUGGERS_KEY = Key.create((String)"PyLocalAttachDebuggerProvider.DEBUGGERS");

    @NotNull
    public XLocalAttachGroup getAttachGroup() {
        PyLocalAttachGroup pyLocalAttachGroup = PyLocalAttachGroup.INSTANCE;
        if (pyLocalAttachGroup == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(0);
        }
        return pyLocalAttachGroup;
    }

    @NotNull
    private static List<XLocalAttachDebugger> getAttachDebuggersForAllLocalSdks(@NotNull Project project) {
        RunConfiguration runConfiguration;
        if (project == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(1);
        }
        Sdk selected = null;
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (settings != null && (runConfiguration = settings.getConfiguration()) instanceof AbstractPythonRunConfiguration) {
            selected = ((AbstractPythonRunConfiguration)runConfiguration).getSdk();
        }
        Sdk selectedSdk = selected;
        List<XLocalAttachDebugger> result = PythonSdkUtil.getAllLocalCPythons().stream().filter(sdk -> sdk != selectedSdk).filter(sdk -> !PythonSdkUtil.isInvalid(sdk)).sorted(PreferredSdkComparator.INSTANCE).map(PyLocalAttachDebugger::new).collect(Collectors.toList());
        if (selectedSdk != null) {
            result.add(0, new PyLocalAttachDebugger(selectedSdk));
        }
        List<XLocalAttachDebugger> list = result;
        if (list == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<XLocalAttachDebugger> getAvailableDebuggers(@NotNull Project project, @NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        if (project == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(3);
        }
        if (processInfo == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(4);
        }
        if (contextHolder == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(5);
        }
        String filter = PyDebuggerOptionsProvider.getInstance(project).getAttachProcessFilter();
        if (StringUtil.containsIgnoreCase((String)processInfo.getCommandLine(), (String)filter)) {
            ArrayList result;
            if (processInfo.getExecutableCannonicalPath().isPresent() && new File((String)processInfo.getExecutableCannonicalPath().get()).exists()) {
                result = Lists.newArrayList((Object[])new XLocalAttachDebugger[]{new PyLocalAttachDebugger((String)processInfo.getExecutableCannonicalPath().get())});
            } else {
                result = (ArrayList)contextHolder.getUserData(DEBUGGERS_KEY);
                if (result != null) {
                    ArrayList arrayList = result;
                    if (arrayList == null) {
                        PyLocalAttachDebuggerProvider.$$$reportNull$$$0(6);
                    }
                    return arrayList;
                }
                result = PyLocalAttachDebuggerProvider.getAttachDebuggersForAllLocalSdks(project);
                contextHolder.putUserData(DEBUGGERS_KEY, Collections.unmodifiableList(result));
            }
            ArrayList arrayList = result;
            if (arrayList == null) {
                PyLocalAttachDebuggerProvider.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        List<XLocalAttachDebugger> list = Collections.emptyList();
        if (list == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/attach/PyLocalAttachDebuggerProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachGroup";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/attach/PyLocalAttachDebuggerProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachDebuggersForAllLocalSdks";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDebuggers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAttachDebuggersForAllLocalSdks";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDebuggers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PyLocalAttachDebugger
    implements XLocalAttachDebugger {
        private final String mySdkHome;
        @NotNull
        @NlsSafe
        private final String myName;

        PyLocalAttachDebugger(@NotNull Sdk sdk) {
            if (sdk == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(0);
            }
            this.mySdkHome = sdk.getHomePath();
            this.myName = PythonSdkType.getInstance().getVersionString(sdk) + " (" + this.mySdkHome + ")";
        }

        PyLocalAttachDebugger(@NotNull String sdkHome) {
            if (sdkHome == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(1);
            }
            this.mySdkHome = sdkHome;
            this.myName = "Python Debugger";
        }

        @NotNull
        public String getDebuggerDisplayName() {
            String string = this.myName;
            if (string == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void attachDebugSession(@NotNull Project project, @NotNull ProcessInfo processInfo) throws ExecutionException {
            if (project == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(3);
            }
            if (processInfo == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(4);
            }
            PyAttachToProcessDebugRunner runner = new PyAttachToProcessDebugRunner(project, processInfo.getPid(), this.mySdkHome);
            runner.launch();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkHome";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/attach/PyLocalAttachDebuggerProvider$PyLocalAttachDebugger";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/attach/PyLocalAttachDebuggerProvider$PyLocalAttachDebugger";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebuggerDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "attachDebugSession";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

