/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.debugger.PyDebugValue;
import java.util.HashMap;
import java.util.Map;

public final class PyTypeHandler {
    private static final Formatter DEFAULT_FORMATTER = new Formatter(){

        @Override
        public String format(String value) {
            return value;
        }
    };
    private static final Formatter STR_FORMATTER = new Formatter(){

        @Override
        public String format(String value) {
            return "'" + StringUtil.replace((String)value, (String)"\\", (String)"\\\\").replace("'", "\\'") + "'";
        }
    };
    private static final Formatter UNI_FORMATTER = new Formatter(){

        @Override
        public String format(String value) {
            return "u'" + StringUtil.replace((String)value, (String)"\\", (String)"\\\\").replace("'", "\\'") + "'";
        }
    };
    private static final Map<String, Formatter> FORMATTERS = new HashMap<String, Formatter>();

    private PyTypeHandler() {
    }

    public static String format(PyDebugValue var) {
        return PyTypeHandler.format(var.getType(), var.getValue());
    }

    public static String format(String type, String value) {
        Formatter formatter = FORMATTERS.get(type);
        if (formatter == null) {
            formatter = DEFAULT_FORMATTER;
        }
        return formatter.format(value);
    }

    static {
        FORMATTERS.put("str", STR_FORMATTER);
        FORMATTERS.put("unicode", UNI_FORMATTER);
        FORMATTERS.put("string_", STR_FORMATTER);
        FORMATTERS.put("unicode_", UNI_FORMATTER);
    }

    private static interface Formatter {
        public String format(String var1);
    }
}

