/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.codeInsight.intentions.TypeIntention;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public class SpecifyTypeInPy3AnnotationsIntention
extends TypeIntention {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.NAME.specify.type.in.annotation", new Object[0]);
        if (string == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(1);
        }
        if (LanguageLevel.forElement((PsiElement)file).isPython2()) {
            return false;
        }
        return super.isAvailable(project, editor2, file);
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        PyNamedParameter parameter;
        if (project == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(2);
        }
        if ((parameter = this.findOnlySuitableParameter(editor2, file)) != null) {
            SpecifyTypeInPy3AnnotationsIntention.annotateParameter(project, editor2, parameter);
            return;
        }
        PyFunction function = this.findOnlySuitableFunction(editor2, file);
        if (function != null) {
            SpecifyTypeInPy3AnnotationsIntention.annotateReturnType(project, function);
        }
    }

    private static void annotateParameter(Project project, Editor editor2, @NotNull PyNamedParameter parameter) {
        if (parameter == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(3);
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)parameter)) {
            return;
        }
        WriteAction.run(() -> SpecifyTypeInPy3AnnotationsIntention.annotateParameter(project, editor2, parameter, true));
    }

    private static void annotateReturnType(Project project, PyFunction function) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)function)) {
            return;
        }
        WriteAction.run(() -> SpecifyTypeInPy3AnnotationsIntention.annotateReturnType(project, function, true));
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static PyNamedParameter annotateParameter(Project project, Editor editor2, @NotNull PyNamedParameter parameter, boolean createTemplate) {
        if (parameter == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(4);
        }
        PyExpression defaultParamValue = parameter.getDefaultValue();
        Object paramName = StringUtil.notNullize((String)parameter.getName());
        if (parameter.isPositionalContainer()) {
            paramName = "*" + (String)paramName;
        } else if (parameter.isKeywordContainer()) {
            paramName = "**" + (String)paramName;
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        String defaultParamText = defaultParamValue == null ? null : defaultParamValue.getText();
        String paramType = SpecifyTypeInPy3AnnotationsIntention.parameterType(parameter);
        PyNamedParameter namedParameter = elementGenerator.createParameter((String)paramName, defaultParamText, paramType, LanguageLevel.forElement(parameter));
        assert (namedParameter != null);
        parameter = (PyNamedParameter)parameter.replace(namedParameter);
        parameter = (PyNamedParameter)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)parameter);
        editor2.getCaretModel().moveToOffset(parameter.getTextOffset());
        PyAnnotation annotation = parameter.getAnnotation();
        if (annotation != null && createTemplate) {
            PyExpression annotationValue = annotation.getValue();
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)parameter);
            assert (annotationValue != null) : "Generated parameter must have annotation";
            int replacementStart = annotation.getStartOffsetInParent() + annotationValue.getStartOffsetInParent();
            builder.replaceRange(TextRange.from((int)replacementStart, (int)annotationValue.getTextLength()), paramType);
            builder.run(editor2, true);
        }
        return parameter;
    }

    static String parameterType(PyParameter parameter) {
        String paramType = "object";
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)parameter, PyFunction.class);
        if (function != null) {
            PySignature signature = PySignatureCacheManager.getInstance(parameter.getProject()).findSignature(function);
            String parameterName = parameter.getName();
            if (signature != null && parameterName != null) {
                paramType = (String)ObjectUtils.chooseNotNull((Object)signature.getArgTypeQualifiedName(parameterName), (Object)paramType);
            }
        }
        return paramType;
    }

    static String returnType(@NotNull PyFunction function) {
        if (function == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(5);
        }
        String returnType = "object";
        PySignature signature = PySignatureCacheManager.getInstance(function.getProject()).findSignature(function);
        if (signature != null) {
            returnType = (String)ObjectUtils.chooseNotNull((Object)signature.getReturnTypeQualifiedName(), (Object)returnType);
        }
        return returnType;
    }

    public static PyExpression annotateReturnType(Project project, PyFunction function, boolean createTemplate) {
        String returnType = SpecifyTypeInPy3AnnotationsIntention.returnType(function);
        String annotationText = "-> " + returnType;
        PyFunction annotatedFunction = (PyFunction)PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)function, document -> {
            PyAnnotation oldAnnotation = function.getAnnotation();
            if (oldAnnotation != null) {
                TextRange oldRange = oldAnnotation.getTextRange();
                document.replaceString(oldRange.getStartOffset(), oldRange.getEndOffset(), (CharSequence)annotationText);
            } else {
                PsiElement prevElem = PyPsiUtils.getPrevNonCommentSibling((PsiElement)function.getStatementList(), true);
                assert (prevElem != null);
                TextRange range = prevElem.getTextRange();
                if (prevElem.getNode().getElementType() == PyTokenTypes.COLON) {
                    document.insertString(range.getStartOffset(), (CharSequence)(" " + annotationText));
                } else {
                    document.insertString(range.getEndOffset(), (CharSequence)(" " + annotationText + ":"));
                }
            }
            return (PyFunction)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)function);
        });
        if (annotatedFunction == null) {
            return null;
        }
        PyAnnotation annotation = annotatedFunction.getAnnotation();
        assert (annotation != null);
        PyExpression annotationValue = annotation.getValue();
        assert (annotationValue != null) : "Generated function must have annotation";
        if (createTemplate) {
            int offset = annotationValue.getTextOffset();
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)annotationValue);
            builder.replaceRange(TextRange.create((int)0, (int)returnType.length()), returnType);
            Editor targetEditor = PythonUiService.getInstance().openTextEditor(project, annotatedFunction.getContainingFile().getVirtualFile(), offset);
            if (targetEditor != null) {
                builder.run(targetEditor, true);
            }
        }
        return annotationValue;
    }

    @Override
    protected boolean isParamTypeDefined(@NotNull PyNamedParameter parameter) {
        if (parameter == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(6);
        }
        return parameter.getAnnotation() != null;
    }

    @Override
    protected boolean isReturnTypeDefined(@NotNull PyFunction function) {
        if (function == null) {
            SpecifyTypeInPy3AnnotationsIntention.$$$reportNull$$$0(7);
        }
        return function.getAnnotation() != null;
    }

    @Override
    protected void updateText(boolean isReturn) {
        this.setText(isReturn ? PyPsiBundle.message("INTN.specify.return.type.in.annotation", new Object[0]) : PyPsiBundle.message("INTN.specify.type.in.annotation", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInPy3AnnotationsIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInPy3AnnotationsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "annotateParameter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "returnType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isParamTypeDefined";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReturnTypeDefined";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

