/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyPlainStringElement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyQuotedStringIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.quoted.string", new Object[0]);
        if (string == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(1);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyStringElement stringElement = PyQuotedStringIntention.findConvertibleStringElementUnderCaret(editor2, file);
        if (stringElement == null) {
            return false;
        }
        PyStringLiteralExpression stringLiteral = PyUtil.as(stringElement.getParent(), PyStringLiteralExpression.class);
        if (stringLiteral == null) {
            return false;
        }
        PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)stringLiteral, PyDocStringOwner.class);
        if (docStringOwner != null && docStringOwner.getDocStringExpression() == stringLiteral) {
            return false;
        }
        String currentQuote = stringElement.getQuote();
        if (currentQuote.equals("'")) {
            this.setText(PyPsiBundle.message("INTN.quoted.string.single.to.double", new Object[0]));
        } else {
            this.setText(PyPsiBundle.message("INTN.quoted.string.double.to.single", new Object[0]));
        }
        return true;
    }

    @Nullable
    private static PyStringElement findConvertibleStringElementUnderCaret(@NotNull Editor editor2, @NotNull PsiFile file) {
        PsiElement elementUnderCaret;
        if (editor2 == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(2);
        }
        if (file == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(3);
        }
        if ((elementUnderCaret = file.findElementAt(editor2.getCaretModel().getOffset())) == null) {
            return null;
        }
        IElementType elementType = elementUnderCaret.getNode().getElementType();
        if (!PyTokenTypes.STRING_NODES.contains(elementType) && !PyTokenTypes.FSTRING_TOKENS.contains(elementType)) {
            return null;
        }
        PyStringElement stringElement = (PyStringElement)PsiTreeUtil.getParentOfType((PsiElement)elementUnderCaret, PyStringElement.class, (boolean)false, (Class[])new Class[]{PyExpression.class});
        return stringElement != null && PyQuotedStringIntention.canBeConverted(stringElement, true) ? stringElement : null;
    }

    private static boolean canBeConverted(@NotNull PyStringElement stringElement, boolean checkContainingFString) {
        Collection innerStrings;
        PyFormattedStringElement fStringElement;
        if (stringElement == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(4);
        }
        if (stringElement.isTripleQuoted() || !stringElement.isTerminated()) {
            return false;
        }
        if (checkContainingFString) {
            PyFormattedStringElement parentFString = (PyFormattedStringElement)PsiTreeUtil.getParentOfType((PsiElement)stringElement, PyFormattedStringElement.class, (boolean)true, (Class[])new Class[]{PyStatement.class});
            char targetQuote = PyStringLiteralUtil.flipQuote(stringElement.getQuote().charAt(0));
            if (parentFString != null) {
                boolean parentFStringUsesTargetQuotes = parentFString.getQuote().equals(Character.toString(targetQuote));
                if (parentFStringUsesTargetQuotes) {
                    return false;
                }
                boolean conversionIntroducesBackslashEscapedQuote = stringElement.textContains(targetQuote);
                if (conversionIntroducesBackslashEscapedQuote) {
                    return false;
                }
            }
        }
        return (fStringElement = PyUtil.as(stringElement, PyFormattedStringElement.class)) == null || !ContainerUtil.exists((Iterable)(innerStrings = PsiTreeUtil.findChildrenOfType((PsiElement)fStringElement, PyStringElement.class)), s -> !PyQuotedStringIntention.canBeConverted(s, false));
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(5);
        }
        PsiElement elementUnderCaret = file.findElementAt(editor2.getCaretModel().getOffset());
        PyStringElement stringElement = (PyStringElement)PsiTreeUtil.getParentOfType((PsiElement)elementUnderCaret, PyStringElement.class, (boolean)false, (Class[])new Class[]{PyExpression.class});
        if (stringElement == null) {
            return;
        }
        PyStringLiteralExpression stringLiteral = PyUtil.as(stringElement.getParent(), PyStringLiteralExpression.class);
        if (stringLiteral == null) {
            return;
        }
        String originalQuote = stringElement.getQuote();
        boolean entireLiteralCanBeConverted = ContainerUtil.all(stringLiteral.getStringElements(), s -> s.getQuote().equals(originalQuote) && PyQuotedStringIntention.canBeConverted(s, true));
        if (entireLiteralCanBeConverted) {
            stringLiteral.getStringElements().forEach(PyQuotedStringIntention::convertStringElement);
        } else {
            PyQuotedStringIntention.convertStringElement(stringElement);
        }
    }

    private static void convertStringElement(@NotNull PyStringElement stringElement) {
        if (stringElement == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(6);
        }
        stringElement.replace(PyQuotedStringIntention.createCopyWithConvertedQuotes(stringElement));
    }

    @NotNull
    private static PyStringElement createCopyWithConvertedQuotes(@NotNull PyStringElement element) {
        if (element == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(7);
        }
        StringBuilder builder = new StringBuilder();
        PyQuotedStringIntention.processStringElement(builder, element);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(element.getProject());
        PyStringElement pyStringElement = (PyStringElement)elementGenerator.createStringLiteralAlreadyEscaped(builder.toString()).getFirstChild();
        if (pyStringElement == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(8);
        }
        return pyStringElement;
    }

    private static void processStringElement(final @NotNull StringBuilder builder, @NotNull PyStringElement stringElement) {
        if (builder == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(9);
        }
        if (stringElement == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(10);
        }
        final char originalQuote = stringElement.getQuote().charAt(0);
        if (stringElement instanceof PyPlainStringElement) {
            PyQuotedStringIntention.processStringElementText(builder, stringElement.getText(), originalQuote);
        } else {
            stringElement.acceptChildren(new PyRecursiveElementVisitor(){

                @Override
                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof PyStringElement) {
                        PyQuotedStringIntention.processStringElement(builder, (PyStringElement)element);
                    } else if (PyTokenTypes.FSTRING_TOKENS.contains(element.getNode().getElementType())) {
                        PyQuotedStringIntention.processStringElementText(builder, element.getText(), originalQuote);
                    } else if (element.getNode().getChildren(null).length == 0) {
                        builder.append(element.getText());
                    } else {
                        super.visitElement(element);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/intentions/PyQuotedStringIntention$1", "visitElement"));
                }
            });
        }
    }

    private static void processStringElementText(@NotNull StringBuilder builder, @NotNull String stringText, char originalQuote) {
        if (builder == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(11);
        }
        if (stringText == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(12);
        }
        char targetQuote = PyStringLiteralUtil.flipQuote(originalQuote);
        char[] charArr = stringText.toCharArray();
        for (int i = 0; i != charArr.length; ++i) {
            char ch2;
            char ch1 = charArr[i];
            char c = ch2 = i + 1 < charArr.length ? charArr[i + 1] : (char)'\u0000';
            if (ch1 == originalQuote) {
                builder.append(targetQuote);
                continue;
            }
            if (ch1 == targetQuote) {
                builder.append("\\").append(targetQuote);
                continue;
            }
            if (ch1 == '\\') {
                if (ch2 == originalQuote) {
                    builder.append(ch2);
                    ++i;
                    continue;
                }
                if (ch2 == '\u0000') {
                    builder.append(ch1);
                    continue;
                }
                builder.append(ch1).append(ch2);
                ++i;
                continue;
            }
            builder.append(ch1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyQuotedStringIntention";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyQuotedStringIntention";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopyWithConvertedQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findConvertibleStringElementUnderCaret";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canBeConverted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertStringElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCopyWithConvertedQuotes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processStringElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processStringElementText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

