/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.dataflow.scope;

import com.intellij.codeInsight.controlflow.impl.InstructionBaseImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.impl.PyExceptPartNavigator;
import com.jetbrains.python.psi.impl.PyForStatementNavigator;
import com.jetbrains.python.psi.impl.PyListCompExpressionNavigator;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScopeUtil {
    private ScopeUtil() {
    }

    @Nullable
    public static PsiElement getParameterScope(PsiElement element) {
        PyFunction function;
        if (element instanceof PyNamedParameter && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false)) != null) {
            return function;
        }
        PyExceptPart exceptPart = PyExceptPartNavigator.getPyExceptPartByTarget(element);
        if (exceptPart != null) {
            return exceptPart;
        }
        PyForStatement forStatement = PyForStatementNavigator.getPyForStatementByIterable(element);
        if (forStatement != null) {
            return forStatement;
        }
        PyListCompExpression listCompExpression = PyListCompExpressionNavigator.getPyListCompExpressionByVariable(element);
        if (listCompExpression != null) {
            return listCompExpression;
        }
        return null;
    }

    @Nullable
    public static ScopeOwner getScopeOwner(@Nullable PsiElement element) {
        StubElement stub;
        if (element == null) {
            return null;
        }
        if (element instanceof PyExpressionCodeFragment) {
            PsiElement context = element.getContext();
            return context instanceof ScopeOwner ? (ScopeOwner)context : ScopeUtil.getScopeOwner(context);
        }
        if (element instanceof StubBasedPsiElement && (stub = ((StubBasedPsiElement)element).getStub()) != null) {
            for (StubElement parentStub = stub.getParentStub(); parentStub != null; parentStub = parentStub.getParentStub()) {
                PsiElement parent = parentStub.getPsi();
                if (!(parent instanceof ScopeOwner)) continue;
                return (ScopeOwner)parent;
            }
            return null;
        }
        return (ScopeOwner)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create((Object)ScopeUtil.calculateScopeOwnerByAST(element), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static ScopeOwner calculateScopeOwnerByAST(@Nullable PsiElement element) {
        PyFunction function;
        PyClass containingClass;
        ScopeOwner firstOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)element, ScopeOwner.class);
        if (firstOwner == null) {
            return null;
        }
        ScopeOwner nextOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)firstOwner, ScopeOwner.class);
        PyElement decoratorAncestor = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, PyDecorator.class);
        if (decoratorAncestor != null && !PsiTreeUtil.isAncestor((PsiElement)decoratorAncestor, (PsiElement)firstOwner, (boolean)true)) {
            return nextOwner;
        }
        PyNamedParameter parameterAncestor = (PyNamedParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PyNamedParameter.class);
        if (parameterAncestor != null && !PsiTreeUtil.isAncestor((PsiElement)parameterAncestor, (PsiElement)firstOwner, (boolean)true)) {
            PyExpression defaultValue = parameterAncestor.getDefaultValue();
            PyAnnotation annotation = parameterAncestor.getAnnotation();
            if (PsiTreeUtil.isAncestor((PsiElement)defaultValue, (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)annotation, (PsiElement)element, (boolean)false)) {
                return nextOwner;
            }
        }
        if ((containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class)) != null && PsiTreeUtil.isAncestor((PsiElement)containingClass.getSuperClassExpressionList(), (PsiElement)element, (boolean)false)) {
            return nextOwner;
        }
        if (firstOwner instanceof PyFunction && (PsiTreeUtil.isAncestor((PsiElement)(function = (PyFunction)firstOwner).getAnnotation(), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)function.getTypeComment(), (PsiElement)element, (boolean)false))) {
            return nextOwner;
        }
        return firstOwner;
    }

    @Nullable
    public static ScopeOwner getDeclarationScopeOwner(@Nullable PsiElement anchor, @Nullable String name) {
        if (name != null) {
            ScopeOwner originalScopeOwner;
            ScopeOwner scopeOwner = originalScopeOwner = ScopeUtil.getScopeOwner(anchor);
            while (scopeOwner != null) {
                Scope scope;
                if ((!(scopeOwner instanceof PyClass) || scopeOwner == originalScopeOwner) && (scope = ControlFlowCache.getScope(scopeOwner)).containsDeclaration(name)) {
                    return scopeOwner;
                }
                scopeOwner = ScopeUtil.getScopeOwner((PsiElement)scopeOwner);
            }
        }
        return null;
    }

    @NotNull
    public static List<PsiElement> getElementsOfAccessType(@NotNull String name, @NotNull ScopeOwner scopeOwner, @NotNull ReadWriteInstruction.ACCESS type) {
        if (name == null) {
            ScopeUtil.$$$reportNull$$$0(0);
        }
        if (scopeOwner == null) {
            ScopeUtil.$$$reportNull$$$0(1);
        }
        if (type == null) {
            ScopeUtil.$$$reportNull$$$0(2);
        }
        List list = ((StreamEx)StreamEx.of((Object[])ControlFlowCache.getControlFlow(scopeOwner).getInstructions()).select(ReadWriteInstruction.class).filter(i -> name.equals(i.getName()) && type == i.getAccess())).map(InstructionBaseImpl::getElement).nonNull().toImmutableList();
        if (list == null) {
            ScopeUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeOwner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/dataflow/scope/ScopeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/dataflow/scope/ScopeUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsOfAccessType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementsOfAccessType";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

