/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.commandInterface.commandLine.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Key;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.commandInterface.command.Command;
import com.jetbrains.commandInterface.commandLine.CommandLineLanguage;
import com.jetbrains.commandInterface.commandLine.CommandLinePart;
import com.jetbrains.commandInterface.commandLine.ValidationResult;
import com.jetbrains.commandInterface.commandLine.psi.CommandLineArgument;
import com.jetbrains.commandInterface.commandLine.psi.CommandLineCommand;
import com.jetbrains.commandInterface.commandLine.psi.CommandLineOption;
import com.jetbrains.commandInterface.commandLine.psi.ValidationResultImpl;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandLineFile
extends PsiFileBase
implements CommandLinePart {
    private static final Key<List<Command>> COMMANDS = Key.create((String)"COMMANDS");

    public CommandLineFile(FileViewProvider provider) {
        super(provider, (Language)CommandLineLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.getViewProvider().getFileType();
        if (fileType == null) {
            CommandLineFile.$$$reportNull$$$0(0);
        }
        return fileType;
    }

    @Override
    @Nullable
    public CommandLineFile getCommandLineFile() {
        return this;
    }

    public void setCommands(@Nullable List<Command> commands) {
        this.putCopyableUserData(COMMANDS, commands);
    }

    @Nullable
    public List<Command> getCommands() {
        return (List)this.getCopyableUserData(COMMANDS);
    }

    @Override
    @Nullable
    public Command findRealCommand() {
        String command = this.getCommand();
        List<Command> commands = this.getCommands();
        if (commands == null || command == null) {
            return null;
        }
        for (Command realCommand : commands) {
            if (!realCommand.getName().equals(command)) continue;
            return realCommand;
        }
        return null;
    }

    @Nullable
    public ValidationResult getValidationResult() {
        return ValidationResultImpl.create(this);
    }

    @Nullable
    public String getCommand() {
        CommandLineCommand command = (CommandLineCommand)PsiTreeUtil.getChildOfType((PsiElement)this, CommandLineCommand.class);
        if (command != null) {
            return command.getText();
        }
        return null;
    }

    @NotNull
    public Collection<CommandLineArgument> getArguments() {
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)this, CommandLineArgument.class);
        if (collection == null) {
            CommandLineFile.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public Collection<CommandLineOption> getOptions() {
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)this, CommandLineOption.class);
        if (collection == null) {
            CommandLineFile.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/commandInterface/commandLine/psi/CommandLineFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

