/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.commandInterface.command;

import com.intellij.openapi.util.Pair;
import com.jetbrains.commandInterface.command.ArgumentType;
import com.jetbrains.commandInterface.command.Help;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Argument {
    @NotNull
    private final Help myHelpText;
    @Nullable
    private final Pair<List<String>, Boolean> myAvailableValues;
    @Nullable
    private final ArgumentType myType;

    public Argument(@NotNull Help helpText) {
        if (helpText == null) {
            Argument.$$$reportNull$$$0(0);
        }
        this(helpText, null, null);
    }

    public Argument(@NotNull ArgumentType type) {
        if (type == null) {
            Argument.$$$reportNull$$$0(1);
        }
        this(new Help(""), type);
    }

    public Argument(@NotNull Help helpText, @Nullable ArgumentType type) {
        if (helpText == null) {
            Argument.$$$reportNull$$$0(2);
        }
        this(helpText, null, type);
    }

    public Argument(@Nullable Pair<List<String>, Boolean> availableValues) {
        this(new Help(""), availableValues, null);
    }

    public Argument(@NotNull Help helpText, @NotNull Pair<List<String>, Boolean> availableValues) {
        if (helpText == null) {
            Argument.$$$reportNull$$$0(3);
        }
        if (availableValues == null) {
            Argument.$$$reportNull$$$0(4);
        }
        this(helpText, availableValues, null);
    }

    public Argument(@NotNull Help helpText, @Nullable Pair<List<String>, Boolean> availableValues, @Nullable ArgumentType type) {
        if (helpText == null) {
            Argument.$$$reportNull$$$0(5);
        }
        this.myHelpText = helpText;
        this.myAvailableValues = availableValues == null ? null : Pair.create(Collections.unmodifiableList((List)availableValues.first), (Object)((Boolean)availableValues.second));
        this.myType = type;
    }

    @NotNull
    public Help getHelp() {
        Help help = this.myHelpText;
        if (help == null) {
            Argument.$$$reportNull$$$0(6);
        }
        return help;
    }

    @Nullable
    public List<String> getAvailableValues() {
        return this.myAvailableValues == null ? null : Collections.unmodifiableList((List)this.myAvailableValues.first);
    }

    public boolean isValid(@NotNull String value) {
        if (value == null) {
            Argument.$$$reportNull$$$0(7);
        }
        if (!this.isTypeValid(value)) {
            return false;
        }
        if (this.myAvailableValues == null || !((Boolean)this.myAvailableValues.second).booleanValue()) {
            return true;
        }
        return ((List)this.myAvailableValues.first).contains(value);
    }

    private boolean isTypeValid(@NotNull String value) {
        if (value == null) {
            Argument.$$$reportNull$$$0(8);
        }
        if (this.myType == ArgumentType.INTEGER) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException ignored) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableValues";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/commandInterface/command/Argument";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/commandInterface/command/Argument";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTypeValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

