/*
 * Decompiled with CFR 0.152.
 */
package training.ui.views;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.interfaces.Lesson;
import training.ui.LearnToolWindow;
import training.ui.LessonMessagePane;
import training.ui.MessageFactory;
import training.ui.MessagePart;
import training.ui.UISettings;
import training.ui.views.LearnPanel;
import training.ui.views.LearnPanel$initLessonPanel$2;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\u0018\u00002\u00020\u0001:\u0001EB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!J\u001e\u0010\"\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\b\b\u0002\u0010 \u001a\u00020!J\b\u0010&\u001a\u00020\u001dH\u0002J\b\u0010'\u001a\u00020\u001dH\u0002J\u0006\u0010(\u001a\u00020\u001dJ\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u001fH\u0003J\b\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020\u001dH\u0002J\u0006\u00102\u001a\u00020\u001dJ\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020\u001d2\u0006\u0010/\u001a\u000200J\u000e\u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u000204J\u000e\u00108\u001a\u00020\u001d2\u0006\u00107\u001a\u000204J\b\u00109\u001a\u00020\u001dH\u0002J\u0010\u0010:\u001a\u00020\u001d2\b\b\u0001\u0010;\u001a\u00020\u001fJ\u0006\u0010<\u001a\u00020\u001dJ\u0010\u0010=\u001a\u00020\u001d2\b\b\u0001\u0010>\u001a\u00020\u001fJ\u0006\u0010?\u001a\u00020\u001dJ$\u0010@\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020\u00142\b\u0010B\u001a\u0004\u0018\u0001002\b\b\u0001\u0010C\u001a\u00020\u001fH\u0002J\b\u0010D\u001a\u00020\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006F"}, d2={"Ltraining/ui/views/LearnPanel;", "Ljavax/swing/JPanel;", "learnToolWindow", "Ltraining/ui/LearnToolWindow;", "(Ltraining/ui/LearnToolWindow;)V", "buttonPanel", "footer", "getLearnToolWindow", "()Ltraining/ui/LearnToolWindow;", "lessonMessagePane", "Ltraining/ui/LessonMessagePane;", "getLessonMessagePane", "()Ltraining/ui/LessonMessagePane;", "lessonNameLabel", "Ljavax/swing/JLabel;", "lessonPanel", "lessonPanelBoxLayout", "Ljavax/swing/BoxLayout;", "moduleNameLabel", "nextButton", "Ljavax/swing/JButton;", "prevButton", "scrollToNewMessages", "", "getScrollToNewMessages$intellij_featuresTrainer", "()Z", "setScrollToNewMessages$intellij_featuresTrainer", "(Z)V", "addMessage", "", "text", "", "state", "Ltraining/ui/LessonMessagePane$MessageState;", "addMessages", "messageParts", "", "Ltraining/ui/MessagePart;", "adjustMessagesArea", "clearMessages", "clearRestoreMessage", "getBackground", "Ljava/awt/Color;", "getNextLessonKeyStrokeText", "getPreferredSize", "Ljava/awt/Dimension;", "initFooterPanel", "lesson", "Ltraining/learn/interfaces/Lesson;", "initLessonPanel", "makeNextButtonSelected", "messagesNumber", "", "reinitMe", "removeInactiveMessages", "number", "resetMessagesNumber", "setButtonToNext", "setLessonName", "lessonName", "setLessonPassed", "setModuleName", "moduleName", "setPreviousMessagesPassed", "updateButton", "button", "targetLesson", "buttonText", "updateNavigationButtons", "LinkLabelWithBackArrow", "intellij.featuresTrainer"})
public final class LearnPanel
extends JPanel {
    private final JPanel lessonPanel;
    private final JLabel moduleNameLabel;
    private final JLabel lessonNameLabel;
    @NotNull
    private final LessonMessagePane lessonMessagePane;
    private final JPanel buttonPanel;
    private final JButton nextButton;
    private final JButton prevButton;
    private final JPanel footer;
    private final BoxLayout lessonPanelBoxLayout;
    private boolean scrollToNewMessages;
    @NotNull
    private final LearnToolWindow learnToolWindow;

    @NotNull
    public final LessonMessagePane getLessonMessagePane() {
        return this.lessonMessagePane;
    }

    public final boolean getScrollToNewMessages$intellij_featuresTrainer() {
        return this.scrollToNewMessages;
    }

    public final void setScrollToNewMessages$intellij_featuresTrainer(boolean bl) {
        this.scrollToNewMessages = bl;
    }

    public final void reinitMe(@NotNull Lesson lesson) {
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        this.scrollToNewMessages = true;
        this.clearMessages();
        this.footer.removeAll();
        this.lessonPanel.removeAll();
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.initLessonPanel();
        this.lessonPanel.setAlignmentX(0.0f);
        this.add((Component)this.lessonPanel, "Center");
        Map<String, String> map = lesson.getHelpLinks();
        boolean bl = false;
        if (!map.isEmpty() && Registry.is((String)"ift.help.links", (boolean)false)) {
            this.initFooterPanel(lesson);
            this.add((Component)this.footer, "Last");
        }
        this.setPreferredSize(new Dimension(UISettings.Companion.getInstance().getWidth(), 100));
        this.setBorder(UISettings.Companion.getInstance().getEmptyBorder());
    }

    /*
     * WARNING - void declaration
     */
    private final void initFooterPanel(Lesson lesson) {
        void it22;
        JPanel shiftedFooter = new JPanel();
        shiftedFooter.setName("footerLessonPanel");
        shiftedFooter.setLayout(new BoxLayout(shiftedFooter, 1));
        shiftedFooter.setFocusable(false);
        shiftedFooter.setOpaque(false);
        shiftedFooter.setBorder(new MatteBorder(1, 0, 0, 0, (Color)UISettings.Companion.getInstance().getSeparatorColor()));
        JPanel footerContent = new JPanel();
        footerContent.setOpaque(false);
        footerContent.setLayout((LayoutManager)new VerticalLayout(5));
        JLabel jLabel = new JLabel(IdeBundle.message((String)"welcome.screen.learnIde.help.and.resources.text", (Object[])new Object[0]));
        boolean bl = false;
        boolean bl2 = false;
        JLabel jLabel2 = jLabel;
        JPanel jPanel = footerContent;
        boolean bl3 = false;
        it22.setFont(UISettings.Companion.getInstance().getHelpHeaderFont());
        Unit unit = Unit.INSTANCE;
        jPanel.add(jLabel);
        Map<String, String> map = lesson.getHelpLinks();
        boolean it22 = false;
        for (Map.Entry<String, String> helpLink : map.entrySet()) {
            String text2 = helpLink.getKey();
            String link = helpLink.getValue();
            LinkLabel linkLabel2 = new LinkLabel(text2, null, (LinkListener)new LinkListener<Object>(link){
                final /* synthetic */ String $link;

                public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                    UtilsKt.openLinkInBrowser(this.$link);
                }
                {
                    this.$link = string;
                }
            });
            footerContent.add(UtilsKt.wrapWithUrlPanel((LinkLabel<Object>)linkLabel2));
        }
        shiftedFooter.add(footerContent);
        shiftedFooter.add(Box.createHorizontalGlue());
        this.footer.add(shiftedFooter);
        this.footer.setOpaque(false);
        this.footer.setLayout(new BoxLayout(this.footer, 1));
        this.footer.setBorder(UISettings.Companion.getInstance().getCheckmarkShiftBorder());
    }

    private final void initLessonPanel() {
        this.lessonPanel.setName("lessonPanel");
        this.lessonPanel.setLayout(this.lessonPanelBoxLayout);
        this.lessonPanel.setFocusable(false);
        this.lessonPanel.setOpaque(false);
        this.moduleNameLabel.setName("moduleNameLabel");
        this.moduleNameLabel.setFont(UISettings.Companion.getInstance().getModuleNameFont());
        this.moduleNameLabel.setFocusable(false);
        this.moduleNameLabel.setBorder(UISettings.Companion.getInstance().getCheckmarkShiftBorder());
        this.lessonNameLabel.setName("lessonNameLabel");
        this.lessonNameLabel.setBorder(UISettings.Companion.getInstance().getCheckmarkShiftBorder());
        this.lessonNameLabel.setFont(UISettings.Companion.getInstance().getLessonHeaderFont());
        this.lessonNameLabel.setAlignmentX(0.0f);
        this.lessonNameLabel.setFocusable(false);
        this.lessonMessagePane.setName("lessonMessagePane");
        this.lessonMessagePane.setFocusable(false);
        this.lessonMessagePane.setOpaque(false);
        this.lessonMessagePane.setAlignmentX(0.0f);
        this.lessonMessagePane.setMargin((Insets)JBUI.emptyInsets());
        this.lessonMessagePane.setBorder(new EmptyBorder(0, 0, UISettings.Companion.getInstance().getBeforeButtonGap(), UISettings.Companion.getInstance().getEastInset()));
        this.lessonMessagePane.setMaximumSize(new Dimension(UISettings.Companion.getInstance().getWidth(), 10000));
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new JButton[]{this.nextButton, this.prevButton});
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JButton it = (JButton)element$iv;
            boolean bl = false;
            it.setMargin((Insets)JBUI.emptyInsets());
            it.setFocusable(false);
            it.setVisible(true);
            it.setEnabled(true);
            it.setOpaque(false);
        }
        this.buttonPanel.setName("buttonPanel");
        this.buttonPanel.setBorder(UISettings.Companion.getInstance().getCheckmarkShiftButtonBorder());
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setFocusable(false);
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setAlignmentX(0.0f);
        this.updateNavigationButtons();
        this.lessonPanel.add(this.moduleNameLabel);
        this.lessonPanel.add(UISettings.Companion.rigidGap$default(UISettings.Companion, LearnPanel$initLessonPanel$2.INSTANCE, false, 2, null));
        this.lessonPanel.add(this.lessonNameLabel);
        this.lessonPanel.add(this.lessonMessagePane);
        this.lessonPanel.add(this.buttonPanel);
        this.lessonPanel.add(Box.createVerticalGlue());
    }

    public final void setLessonName(@Nls @NotNull String lessonName) {
        Intrinsics.checkNotNullParameter((Object)lessonName, (String)"lessonName");
        this.lessonNameLabel.setText(lessonName);
        this.lessonNameLabel.setForeground((Color)UISettings.Companion.getInstance().getDefaultTextColor());
        this.lessonNameLabel.setFocusable(false);
        this.revalidate();
        this.repaint();
    }

    public final void setModuleName(@Nls @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        this.moduleNameLabel.setText("    " + moduleName);
        this.moduleNameLabel.setForeground((Color)UISettings.Companion.getInstance().getDefaultTextColor());
        this.moduleNameLabel.setFocusable(false);
        this.revalidate();
        this.repaint();
    }

    public final void addMessage(@Language(value="HTML") @NotNull String text2, @NotNull LessonMessagePane.MessageState state) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        List<MessagePart> messages = MessageFactory.INSTANCE.convert(text2);
        MessageFactory.INSTANCE.setLinksHandlers(this.learnToolWindow.getProject(), messages);
        this.addMessages(messages, state);
    }

    public static /* synthetic */ void addMessage$default(LearnPanel learnPanel, String string, LessonMessagePane.MessageState messageState, int n, Object object) {
        if ((n & 2) != 0) {
            messageState = LessonMessagePane.MessageState.NORMAL;
        }
        learnPanel.addMessage(string, messageState);
    }

    public final void addMessages(@NotNull List<MessagePart> messageParts, @NotNull LessonMessagePane.MessageState state) {
        Intrinsics.checkNotNullParameter(messageParts, (String)"messageParts");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Rectangle needToShow = this.lessonMessagePane.addMessage(messageParts, state);
        this.adjustMessagesArea();
        if (this.scrollToNewMessages && state != LessonMessagePane.MessageState.INACTIVE && needToShow != null) {
            this.lessonMessagePane.scrollRectToVisible(needToShow);
        }
    }

    public static /* synthetic */ void addMessages$default(LearnPanel learnPanel, List list2, LessonMessagePane.MessageState messageState, int n, Object object) {
        if ((n & 2) != 0) {
            messageState = LessonMessagePane.MessageState.NORMAL;
        }
        learnPanel.addMessages(list2, messageState);
    }

    private final void adjustMessagesArea() {
        this.lessonMessagePane.getPreferredSize();
        this.lessonPanel.repaint();
        this.lessonPanelBoxLayout.invalidateLayout(this.lessonPanel);
        this.lessonPanelBoxLayout.layoutContainer(this.lessonPanel);
    }

    public final void resetMessagesNumber(int number) {
        this.lessonMessagePane.resetMessagesNumber(number);
        this.adjustMessagesArea();
    }

    public final void removeInactiveMessages(int number) {
        this.lessonMessagePane.removeInactiveMessages(number);
        this.adjustMessagesArea();
    }

    public final int messagesNumber() {
        return this.lessonMessagePane.messagesNumber();
    }

    public final void setPreviousMessagesPassed() {
        this.lessonMessagePane.passPreviousMessages();
        this.lessonMessagePane.revalidate();
        this.lessonMessagePane.repaint();
    }

    public final void setLessonPassed() {
        this.setButtonToNext();
        this.revalidate();
        this.repaint();
    }

    private final void setButtonToNext() {
        this.nextButton.setVisible(true);
        this.lessonPanel.revalidate();
        this.lessonPanel.repaint();
    }

    private final void clearMessages() {
        this.lessonNameLabel.setIcon(null);
        this.lessonMessagePane.clear();
    }

    private final void updateNavigationButtons() {
        this.buttonPanel.removeAll();
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            jRootPane.setDefaultButton(null);
        }
        this.updateButton(this.prevButton, UtilsKt.getPreviousLessonForCurrent(), LearnBundle.INSTANCE.message("learn.new.ui.button.back", new Object[0]));
        Lesson nextLesson = UtilsKt.getNextLessonForCurrent();
        Object[] objectArray = new Object[1];
        Object object = nextLesson;
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        objectArray[0] = object;
        this.updateButton(this.nextButton, nextLesson, LearnBundle.INSTANCE.message("learn.new.ui.button.next", objectArray));
    }

    private final void updateButton(JButton button2, Lesson targetLesson, @Nls String buttonText) {
        button2.setVisible(targetLesson != null);
        if (targetLesson != null) {
            button2.setAction(new AbstractAction(this, targetLesson){
                final /* synthetic */ LearnPanel this$0;
                final /* synthetic */ Lesson $targetLesson;

                public void actionPerformed(@NotNull ActionEvent actionEvent) {
                    Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"actionEvent");
                    CourseManager.Companion.getInstance().openLesson(this.this$0.getLearnToolWindow().getProject(), this.$targetLesson);
                }
                {
                    this.this$0 = this$0;
                    this.$targetLesson = $captured_local_variable$1;
                }
            });
            button2.setText(buttonText);
            button2.updateUI();
            button2.setSelected(true);
            if (!targetLesson.getPassed() && !targetLesson.getProperties().getCanStartInDumbMode()) {
                DumbService dumbService = DumbService.getInstance((Project)this.learnToolWindow.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(learnToolWindow.project)");
                if (dumbService.isDumb()) {
                    button2.setEnabled(false);
                    button2.setToolTipText(LearnBundle.INSTANCE.message("indexing.message", new Object[0]));
                    button2.setSelected(false);
                    DumbService.getInstance((Project)this.learnToolWindow.getProject()).runWhenSmart(new Runnable(button2){
                        final /* synthetic */ JButton $button;

                        public final void run() {
                            this.$button.setEnabled(true);
                            this.$button.setToolTipText("");
                            this.$button.setSelected(true);
                        }
                        {
                            this.$button = jButton;
                        }
                    });
                }
            }
            this.buttonPanel.add(button2);
        }
    }

    @NlsSafe
    private final String getNextLessonKeyStrokeText() {
        return "Enter";
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        if (this.lessonPanel.getMinimumSize() == null) {
            return new Dimension(10, 10);
        }
        return new Dimension((int)this.lessonPanel.getMinimumSize().getWidth() + UISettings.Companion.getInstance().getWestInset() + UISettings.Companion.getInstance().getEastInset(), (int)this.lessonPanel.getMinimumSize().getHeight() + (int)this.footer.getMinimumSize().getHeight() + UISettings.Companion.getInstance().getNorthInset() + UISettings.Companion.getInstance().getSouthInset());
    }

    @Override
    @NotNull
    public Color getBackground() {
        Color color;
        if (!UIUtil.isUnderDarcula()) {
            color = UISettings.Companion.getInstance().getBackgroundColor();
        } else {
            Color color2 = UIUtil.getPanelBackground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"UIUtil.getPanelBackground()");
        }
        return color;
    }

    public final void makeNextButtonSelected() {
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            jRootPane.setDefaultButton(this.nextButton);
        }
        this.nextButton.setSelected(true);
        this.nextButton.setFocusable(true);
        this.nextButton.requestFocus();
        if (this.scrollToNewMessages) {
            this.nextButton.scrollRectToVisible(new Rectangle(0, 0, this.nextButton.getWidth(), this.nextButton.getHeight()));
        }
    }

    public final void clearRestoreMessage() {
        this.lessonMessagePane.clearRestoreMessages();
    }

    @NotNull
    public final LearnToolWindow getLearnToolWindow() {
        return this.learnToolWindow;
    }

    public LearnPanel(@NotNull LearnToolWindow learnToolWindow) {
        Intrinsics.checkNotNullParameter((Object)((Object)learnToolWindow), (String)"learnToolWindow");
        this.learnToolWindow = learnToolWindow;
        this.lessonPanel = new JPanel();
        this.moduleNameLabel = (JLabel)((Object)new LinkLabelWithBackArrow(moduleNameLabel.1.INSTANCE));
        this.lessonNameLabel = new JLabel();
        this.lessonMessagePane = new LessonMessagePane();
        this.buttonPanel = new JPanel();
        this.nextButton = new JButton(LearnBundle.INSTANCE.message("learn.ui.button.skip", new Object[0]));
        this.prevButton = new JButton();
        this.footer = new JPanel();
        this.lessonPanelBoxLayout = new BoxLayout(this.lessonPanel, 1);
        this.scrollToNewMessages = true;
        this.setFocusable(false);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Ltraining/ui/views/LearnPanel$LinkLabelWithBackArrow;", "T", "Lcom/intellij/ui/components/labels/LinkLabel;", "linkListener", "Lcom/intellij/ui/components/labels/LinkListener;", "(Lcom/intellij/ui/components/labels/LinkListener;)V", "paint", "", "g", "Ljava/awt/Graphics;", "intellij.featuresTrainer"})
    public static final class LinkLabelWithBackArrow<T>
    extends LinkLabel<T> {
        public void paint(@Nullable Graphics g) {
            super.paint(g);
            int arrowWingHeight = this.getTextBounds().height / 4;
            Graphics graphics = g;
            if (graphics == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
            }
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font font = this.getFont();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"font");
            Stroke stroke3 = new BasicStroke(1.2f * (float)font.getSize() / (float)13, 1, 1);
            g2d.setStroke(stroke3);
            g2d.setColor(this.getForeground());
            g2d.drawLine(this.getTextBounds().x, this.getTextBounds().y + this.getTextBounds().height / 2, this.getTextBounds().x + 5 * this.getTextBounds().height / 17, this.getTextBounds().y + this.getTextBounds().height / 2 - arrowWingHeight);
            g2d.drawLine(this.getTextBounds().x, this.getTextBounds().y + this.getTextBounds().height / 2, this.getTextBounds().x + 9 * this.getTextBounds().height / 17, this.getTextBounds().y + this.getTextBounds().height / 2);
            g2d.drawLine(this.getTextBounds().x, this.getTextBounds().y + this.getTextBounds().height / 2, this.getTextBounds().x + 5 * this.getTextBounds().height / 17, this.getTextBounds().y + this.getTextBounds().height / 2 + arrowWingHeight);
        }

        public LinkLabelWithBackArrow(@NotNull LinkListener<T> linkListener) {
            Intrinsics.checkNotNullParameter(linkListener, (String)"linkListener");
            super("", null, linkListener);
            this.setFont(UIUtil.getLabelFont());
        }
    }
}

