/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class XDebuggerEvaluateActionHandler
extends XDebuggerActionHandler {
    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(0);
        }
        XDebuggerEditorsProvider editorsProvider = session2.getDebugProcess().getEditorsProvider();
        XStackFrame stackFrame = session2.getCurrentStackFrame();
        XDebuggerEvaluator evaluator = session2.getDebugProcess().getEvaluator();
        if (evaluator == null) {
            return;
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        XValue value2 = XDebuggerTreeActionBase.getSelectedValue(dataContext);
        XDebuggerEvaluateActionHandler.getSelectedTextAsync(evaluator, dataContext).onSuccess(pair -> {
            String evalExpression = (String)pair.first;
            EvaluationMode evalMode = (EvaluationMode)pair.second;
            if (evalExpression == null && value2 != null) {
                value2.calculateEvaluationExpression().onSuccess(expression -> AppUIUtil.invokeOnEdt(() -> XDebuggerEvaluateActionHandler.showDialog(session2, file2, editorsProvider, stackFrame, evaluator, expression)));
            } else {
                AppUIUtil.invokeOnEdt(() -> XDebuggerEvaluateActionHandler.showDialog(session2, file2, editorsProvider, stackFrame, evaluator, XExpressionImpl.fromText(evalExpression, evalMode)));
            }
        });
    }

    public static Promise<Pair<@Nullable String, EvaluationMode>> getSelectedTextAsync(@NotNull XDebuggerEvaluator evaluator, @NotNull DataContext dataContext) {
        String selectedText;
        if (evaluator == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(2);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        EvaluationMode mode = EvaluationMode.EXPRESSION;
        String string = selectedText = editor != null ? editor.getSelectionModel().getSelectedText() : null;
        if (selectedText != null) {
            selectedText = evaluator.formatTextForEvaluation(selectedText);
            mode = evaluator.getEvaluationMode(selectedText, editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd(), (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext));
        }
        Promise<String> expressionTextPromise = Promises.resolvedPromise((Object)selectedText);
        if (selectedText == null && editor != null) {
            expressionTextPromise = XDebuggerEvaluateActionHandler.getExpressionText(evaluator, (Project)CommonDataKeys.PROJECT.getData(dataContext), editor);
        } else if (editor != null) {
            expressionTextPromise = evaluator.getWhenDataIsReady(editor, (Object)selectedText);
        }
        EvaluationMode finalMode = mode;
        return expressionTextPromise.then(expression -> Pair.create((Object)expression, (Object)finalMode));
    }

    private static void showDialog(@NotNull XDebugSession session2, VirtualFile file2, XDebuggerEditorsProvider editorsProvider, XStackFrame stackFrame, XDebuggerEvaluator evaluator, @Nullable XExpression expression) {
        if (session2 == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(3);
        }
        if (expression == null) {
            expression = XExpressionImpl.EMPTY_EXPRESSION;
        }
        if (expression.getLanguage() == null) {
            XSourcePosition position;
            Language language = null;
            if (stackFrame != null && (position = stackFrame.getSourcePosition()) != null) {
                language = LanguageUtil.getFileLanguage((VirtualFile)position.getFile());
            }
            if (language == null && file2 != null) {
                language = LanguageUtil.getFileTypeLanguage((FileType)file2.getFileType());
            }
            expression = new XExpressionImpl(expression.getExpression(), language, expression.getCustomInfo(), expression.getMode());
        }
        XSourcePosition position = stackFrame == null ? null : stackFrame.getSourcePosition();
        new XDebuggerEvaluationDialog(session2, editorsProvider, expression, position, evaluator.isCodeFragmentEvaluationSupported()).show();
    }

    @NotNull
    public static Promise<String> getExpressionText(@Nullable XDebuggerEvaluator evaluator, @Nullable Project project, @NotNull Editor editor) {
        if (editor == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(4);
        }
        if (project == null || evaluator == null) {
            Promise promise = Promises.resolvedPromise(null);
            if (promise == null) {
                XDebuggerEvaluateActionHandler.$$$reportNull$$$0(5);
            }
            return promise;
        }
        Document document = editor.getDocument();
        Promise expressionInfoPromise = evaluator.getExpressionInfoAtOffsetAsync(project, document, editor.getCaretModel().getOffset(), true);
        Promise promise = expressionInfoPromise.then(expressionInfo -> XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, document));
        if (promise == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(6);
        }
        return promise;
    }

    @Nullable
    public static String getExpressionText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (document == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(7);
        }
        if (expressionInfo == null) {
            return null;
        }
        String text2 = expressionInfo.getExpressionText();
        return text2 == null ? document.getText(expressionInfo.getTextRange()) : text2;
    }

    @Nullable
    public static String getDisplayText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (document == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(8);
        }
        if (expressionInfo == null) {
            return null;
        }
        String text2 = expressionInfo.getDisplayText();
        return text2 == null ? document.getText(expressionInfo.getTextRange()) : text2;
    }

    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(9);
        }
        return session2.getDebugProcess().getEvaluator() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedTextAsync";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionText";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

