/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.InputMapExternalizer;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.EmptyForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.indexing.impl.forward.IntMapForwardIndex;
import com.intellij.util.indexing.impl.forward.MapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.indexing.impl.forward.SingleEntryIndexForwardIndexAccessor;
import com.intellij.util.indexing.impl.perFileVersion.PersistentSubIndexerRetriever;
import com.intellij.util.indexing.impl.storage.TransientChangesIndexStorage;
import com.intellij.util.indexing.memory.InMemoryForwardIndex;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingIndex;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import com.intellij.util.indexing.snapshot.SnapshotSingleValueIndexStorage;
import com.intellij.util.indexing.snapshot.UpdatableSnapshotInputMappingIndex;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashSet;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class VfsAwareMapReduceIndex<Key, Value>
extends MapReduceIndex<Key, Value, FileContent>
implements UpdatableIndex<Key, Value, FileContent> {
    private static final Logger LOG = Logger.getInstance(VfsAwareMapReduceIndex.class);
    @ApiStatus.Internal
    public static final int VERSION = 0;
    private final AtomicBoolean myInMemoryMode;
    private final ConcurrentIntObjectMap<Map<Key, Value>> myInMemoryKeysAndValues;
    private final PersistentSubIndexerRetriever mySubIndexerRetriever;
    private final SnapshotInputMappingIndex<Key, Value, FileContent> mySnapshotInputMappings;
    private final boolean myUpdateMappings;
    private final boolean mySingleEntryIndex;

    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, FileContent> extension, @NotNull IndexStorage<Key, Value> storage) throws IOException {
        if (extension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(1);
        }
        this(extension, storage, VfsAwareMapReduceIndex.hasSnapshotMapping(extension) ? new SnapshotInputMappings<Key, Value>(extension, VfsAwareMapReduceIndex.getForwardIndexAccessor(extension)) : null);
        if (!(this.myIndexId instanceof ID)) {
            throw new IllegalArgumentException("myIndexId should be instance of com.intellij.util.indexing.ID");
        }
    }

    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, FileContent> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable SnapshotInputMappings<Key, Value> snapshotInputMappings) throws IOException {
        if (extension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(2);
        }
        if (storage == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(3);
        }
        this(extension, storage, (ForwardIndex)(snapshotInputMappings != null ? new IntMapForwardIndex(snapshotInputMappings.getInputIndexStorageFile(), true) : VfsAwareMapReduceIndex.getForwardIndexMap(extension)), (ForwardIndexAccessor<Key, Value>)(snapshotInputMappings != null ? snapshotInputMappings.getForwardIndexAccessor() : VfsAwareMapReduceIndex.getForwardIndexAccessor(extension)), snapshotInputMappings, null);
    }

    /*
     * Unable to fully structure code
     */
    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, FileContent> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable ForwardIndex forwardIndexMap, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor, @Nullable SnapshotInputMappings<Key, Value> snapshotInputMappings, @Nullable ReadWriteLock lock) {
        if (extension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(4);
        }
        if (storage == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(5);
        }
        super(extension, storage, forwardIndexMap, forwardIndexAccessor, lock);
        this.myInMemoryMode = new AtomicBoolean();
        this.myInMemoryKeysAndValues = ContainerUtil.createConcurrentIntObjectMap();
        if (storage instanceof TransientChangesIndexStorage && snapshotInputMappings != null && (backendStorage = ((TransientChangesIndexStorage)storage).getBackendStorage()) instanceof SnapshotSingleValueIndexStorage) {
            VfsAwareMapReduceIndex.LOG.assertTrue(forwardIndexMap instanceof IntForwardIndex);
            ((SnapshotSingleValueIndexStorage)backendStorage).init(snapshotInputMappings, (IntForwardIndex)forwardIndexMap);
        }
        if (VfsAwareMapReduceIndex.isCompositeIndexer(this.myIndexer)) {
            try {
                this.mySubIndexerRetriever = new PersistentSubIndexerRetriever<SubIndexerType, SubIndexerVersion>((ID)this.myIndexId, extension.getVersion(), (CompositeDataIndexer)this.myIndexer);
                if (snapshotInputMappings == null) ** GOTO lbl21
                snapshotInputMappings.setSubIndexerRetriever(this.mySubIndexerRetriever);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.mySubIndexerRetriever = null;
        }
lbl21:
        // 3 sources

        this.mySnapshotInputMappings = snapshotInputMappings;
        this.myUpdateMappings = this.mySnapshotInputMappings != null;
        this.mySingleEntryIndex = extension instanceof SingleEntryFileBasedIndexExtension;
        this.installMemoryModeListener();
    }

    @Override
    public void dumpStatistics() {
        if (this.mySnapshotInputMappings instanceof SnapshotInputMappings) {
            ((SnapshotInputMappings)this.mySnapshotInputMappings).dumpStatistics();
        }
    }

    public static boolean isCompositeIndexer(@NotNull DataIndexer<?, ?, ?> indexer) {
        if (indexer == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(6);
        }
        return indexer instanceof CompositeDataIndexer && !FileBasedIndex.USE_IN_MEMORY_INDEX;
    }

    public static <Key, Value> boolean hasSnapshotMapping(@NotNull IndexExtension<Key, Value, ?> indexExtension) {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(7);
        }
        return indexExtension instanceof FileBasedIndexExtension && ((FileBasedIndexExtension)indexExtension).hasSnapshotMapping() && FileBasedIndex.ourSnapshotMappingsEnabled && !FileBasedIndex.USE_IN_MEMORY_INDEX;
    }

    @NotNull
    protected final InputData<Key, Value> mapInput(int inputId, @Nullable FileContent content2) {
        InputData<Key, Value> data2;
        boolean isPhysical;
        boolean containsSnapshotData = true;
        boolean bl = isPhysical = content2 instanceof FileContentImpl && ((FileContentImpl)content2).isPhysicalContent();
        if (this.mySnapshotInputMappings != null && isPhysical) {
            block10: {
                InputData<Key, Value> inputData;
                try {
                    data2 = this.mySnapshotInputMappings.readData(content2);
                    if (data2 == null) break block10;
                    inputData = data2;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (inputData == null) {
                    VfsAwareMapReduceIndex.$$$reportNull$$$0(8);
                }
                return inputData;
            }
            containsSnapshotData = !this.myUpdateMappings;
        }
        data2 = super.mapInput(inputId, (Object)content2);
        if (!containsSnapshotData) {
            InputData<Key, Value> inputData;
            try {
                inputData = ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).putData(content2, data2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (inputData == null) {
                VfsAwareMapReduceIndex.$$$reportNull$$$0(9);
            }
            return inputData;
        }
        InputData<Key, Value> inputData = data2;
        if (inputData == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(10);
        }
        return inputData;
    }

    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId) throws IOException {
        Map keysAndValues;
        if (this.mySnapshotInputMappings != null && !this.myInMemoryMode.get()) {
            InputDataDiffBuilder inputDataDiffBuilder = super.getKeysDiffBuilder(inputId);
            if (inputDataDiffBuilder == null) {
                VfsAwareMapReduceIndex.$$$reportNull$$$0(11);
            }
            return inputDataDiffBuilder;
        }
        if (this.myInMemoryMode.get() && (keysAndValues = (Map)this.myInMemoryKeysAndValues.get(inputId)) != null) {
            InputDataDiffBuilder<Key, Value> inputDataDiffBuilder = this.getKeysDiffBuilder(inputId, keysAndValues);
            if (inputDataDiffBuilder == null) {
                VfsAwareMapReduceIndex.$$$reportNull$$$0(12);
            }
            return inputDataDiffBuilder;
        }
        InputDataDiffBuilder inputDataDiffBuilder = super.getKeysDiffBuilder(inputId);
        if (inputDataDiffBuilder == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(13);
        }
        return inputDataDiffBuilder;
    }

    @NotNull
    public InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId, @NotNull Map<Key, Value> keysAndValues) throws IOException {
        if (keysAndValues == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(14);
        }
        InputDataDiffBuilder inputDataDiffBuilder = ((AbstractMapForwardIndexAccessor)this.getForwardIndexAccessor()).createDiffBuilderByMap(inputId, keysAndValues);
        if (inputDataDiffBuilder == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(15);
        }
        return inputDataDiffBuilder;
    }

    protected void updateForwardIndex(int inputId, @NotNull InputData<Key, Value> data2) throws IOException {
        if (data2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(16);
        }
        if (this.myInMemoryMode.get()) {
            this.myInMemoryKeysAndValues.put(inputId, (Object)data2.getKeyValues());
        } else {
            super.updateForwardIndex(inputId, data2);
        }
    }

    @Override
    public void setIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(17);
        }
        IndexingStamp.setFileIndexedStateCurrent(fileId, (ID)this.myIndexId);
        if (this.mySubIndexerRetriever != null) {
            try {
                this.mySubIndexerRetriever.setIndexedState(fileId, file2);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void invalidateIndexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateOutdated(fileId, (ID)this.myIndexId);
    }

    @Override
    public void setUnindexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateUnindexed(fileId, (ID)this.myIndexId);
        if (this.mySubIndexerRetriever != null) {
            try {
                this.mySubIndexerRetriever.setUnindexedState(fileId);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    public FileIndexingState getIndexingStateForFile(int fileId, @NotNull IndexedFile file2) {
        FileIndexingState subIndexerState;
        block17: {
            block16: {
                FileIndexingState fileIndexingState;
                FileIndexingState baseState;
                if (file2 == null) {
                    VfsAwareMapReduceIndex.$$$reportNull$$$0(18);
                }
                if ((baseState = IndexingStamp.isFileIndexedStateCurrent(fileId, (ID)this.myIndexId)) != FileIndexingState.UP_TO_DATE) {
                    FileIndexingState fileIndexingState2 = baseState;
                    if (fileIndexingState2 == null) {
                        VfsAwareMapReduceIndex.$$$reportNull$$$0(19);
                    }
                    return fileIndexingState2;
                }
                if (this.mySubIndexerRetriever == null) {
                    FileIndexingState fileIndexingState3 = FileIndexingState.UP_TO_DATE;
                    if (fileIndexingState3 == null) {
                        VfsAwareMapReduceIndex.$$$reportNull$$$0(20);
                    }
                    return fileIndexingState3;
                }
                if (!(file2 instanceof FileContent) && ((CompositeDataIndexer)this.myIndexer).requiresContentForSubIndexerEvaluation(file2)) {
                    FileIndexingState indexConfigurationState = this.isIndexConfigurationUpToDate(fileId, file2);
                    FileIndexingState fileIndexingState4 = indexConfigurationState == FileIndexingState.OUT_DATED ? FileIndexingState.OUT_DATED : FileIndexingState.UP_TO_DATE;
                    if (fileIndexingState4 == null) {
                        VfsAwareMapReduceIndex.$$$reportNull$$$0(21);
                    }
                    return fileIndexingState4;
                }
                try {
                    subIndexerState = this.mySubIndexerRetriever.getSubIndexerState(fileId, file2);
                    if (subIndexerState != FileIndexingState.UP_TO_DATE) break block16;
                    if (file2 instanceof FileContent && ((CompositeDataIndexer)this.myIndexer).requiresContentForSubIndexerEvaluation(file2)) {
                        this.setIndexConfigurationUpToDate(fileId, file2);
                    }
                    fileIndexingState = FileIndexingState.UP_TO_DATE;
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    FileIndexingState fileIndexingState5 = FileIndexingState.OUT_DATED;
                    if (fileIndexingState5 == null) {
                        VfsAwareMapReduceIndex.$$$reportNull$$$0(25);
                    }
                    return fileIndexingState5;
                }
                if (fileIndexingState == null) {
                    VfsAwareMapReduceIndex.$$$reportNull$$$0(22);
                }
                return fileIndexingState;
            }
            if (subIndexerState != FileIndexingState.NOT_INDEXED) break block17;
            FileIndexingState fileIndexingState = FileIndexingState.UP_TO_DATE;
            if (fileIndexingState == null) {
                VfsAwareMapReduceIndex.$$$reportNull$$$0(23);
            }
            return fileIndexingState;
        }
        FileIndexingState fileIndexingState = subIndexerState;
        if (fileIndexingState == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(24);
        }
        return fileIndexingState;
    }

    protected FileIndexingState isIndexConfigurationUpToDate(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(26);
        }
        return FileIndexingState.OUT_DATED;
    }

    protected void setIndexConfigurationUpToDate(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(27);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransientDataForFile(int inputId) {
        if (IndexDebugProperties.DEBUG) {
            LOG.assertTrue(ProgressManager.getInstance().isInNonCancelableSection());
        }
        this.getLock().writeLock().lock();
        try {
            Map keyValueMap = (Map)this.myInMemoryKeysAndValues.remove(inputId);
            if (keyValueMap == null) {
                return;
            }
            try {
                this.removeTransientDataForInMemoryKeys(inputId, keyValueMap);
                InputDataDiffBuilder<Key, Value> builder2 = this.getKeysDiffBuilder(inputId);
                this.removeTransientDataForKeys(inputId, builder2);
            }
            catch (IOException throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    protected void removeTransientDataForInMemoryKeys(int inputId, @NotNull Map<Key, Value> map2) throws IOException {
        if (map2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(28);
        }
        this.removeTransientDataForKeys(inputId, this.getKeysDiffBuilder(inputId, map2));
    }

    @Override
    public void removeTransientDataForKeys(int inputId, @NotNull InputDataDiffBuilder<Key, Value> diffBuilder) {
        if (diffBuilder == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(29);
        }
        TransientChangesIndexStorage memoryIndexStorage = (TransientChangesIndexStorage)this.getStorage();
        boolean modified = false;
        for (Object key : ((DirectInputDataDiffBuilder)diffBuilder).getKeys()) {
            if (!memoryIndexStorage.clearMemoryMapForId(key, inputId) || modified) continue;
            modified = true;
        }
        if (modified) {
            this.myModificationStamp.incrementAndGet();
        }
    }

    @Override
    public void setBufferingEnabled(boolean enabled) {
        ((TransientChangesIndexStorage)this.getStorage()).setBufferingEnabled(enabled);
    }

    @Override
    public void cleanupMemoryStorage() {
        TransientChangesIndexStorage memStorage = (TransientChangesIndexStorage)this.getStorage();
        ConcurrencyUtil.withLock((Lock)this.getLock().writeLock(), () -> {
            if (memStorage.clearMemoryMap()) {
                this.myModificationStamp.incrementAndGet();
            }
        });
        memStorage.fireMemoryStorageCleared();
    }

    @Override
    @TestOnly
    public void cleanupForNextTest() {
        IndexStorage memStorage = this.getStorage();
        ConcurrencyUtil.withLock((Lock)this.getLock().readLock(), () -> memStorage.clearCaches());
    }

    @Override
    public boolean processAllKeys(@NotNull Processor<? super Key> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(31);
        }
        return (Boolean)ConcurrencyUtil.withLock((Lock)this.getLock().readLock(), () -> ((VfsAwareIndexStorage)this.myStorage).processKeys(processor2, scope, idFilter));
    }

    @Override
    @NotNull
    public Map<Key, Value> getIndexedFileData(int fileId) throws StorageException {
        Map map2 = (Map)ConcurrencyUtil.withLock((Lock)this.getLock().readLock(), () -> {
            try {
                return Collections.unmodifiableMap(ContainerUtil.notNullize(this.getNullableIndexedData(fileId)));
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        });
        if (map2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(32);
        }
        return map2;
    }

    @Nullable
    private Map<Key, Value> getNullableIndexedData(int fileId) throws IOException, StorageException {
        Map map2;
        if (this.myInMemoryMode.get() && (map2 = (Map)this.myInMemoryKeysAndValues.get(fileId)) != null) {
            return map2;
        }
        if (this.mySingleEntryIndex) {
            Integer key = fileId;
            Ref result2 = new Ref(Collections.emptyMap());
            ValueContainer container = this.getData(key);
            container.forEach((id2, value2) -> {
                boolean acceptNullValues = ((SingleEntryIndexer)this.myIndexer).isAcceptNullValues();
                if (value2 != null || acceptNullValues) {
                    result2.set(Collections.singletonMap(key, value2));
                }
                return false;
            });
            return (Map)result2.get();
        }
        if (this.getForwardIndexAccessor() instanceof AbstractMapForwardIndexAccessor) {
            ByteArraySequence serializedInputData = this.getForwardIndex().get(Integer.valueOf(fileId));
            AbstractMapForwardIndexAccessor forwardIndexAccessor = (AbstractMapForwardIndexAccessor)this.getForwardIndexAccessor();
            return forwardIndexAccessor.convertToInputDataMap(fileId, serializedInputData);
        }
        LOG.error("Can't fetch indexed data for index " + this.myIndexId.getName());
        return null;
    }

    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    protected void requestRebuild(@NotNull Throwable ex) {
        if (ex == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(33);
        }
        Runnable action2 = () -> FileBasedIndex.getInstance().requestRebuild((ID)this.myIndexId, ex);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            ApplicationManager.getApplication().invokeLater(action2);
        } else {
            action2.run();
        }
    }

    @Override
    public void updateWithMap(@NotNull AbstractUpdateData<Key, Value> updateData) throws StorageException {
        if (updateData == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(34);
        }
        try {
            super.updateWithMap(updateData);
        }
        catch (ProcessCanceledException e) {
            LOG.error("ProcessCancelledException is not expected here!", (Throwable)e);
            throw e;
        }
    }

    protected void doClear() throws StorageException, IOException {
        super.doClear();
        if (this.mySnapshotInputMappings != null && this.myUpdateMappings) {
            try {
                ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).clear();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.mySubIndexerRetriever != null) {
            try {
                this.mySubIndexerRetriever.clear();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    protected void doFlush() throws IOException, StorageException {
        super.doFlush();
        if (this.mySnapshotInputMappings != null && this.myUpdateMappings) {
            ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).flush();
        }
        if (this.mySubIndexerRetriever != null) {
            this.mySubIndexerRetriever.flush();
        }
    }

    protected void doDispose() throws StorageException {
        try {
            super.doDispose();
        }
        catch (Throwable throwable) {
            IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.mySnapshotInputMappings, this.mySubIndexerRetriever});
            throw throwable;
        }
        IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.mySnapshotInputMappings, this.mySubIndexerRetriever});
    }

    @ApiStatus.Internal
    @NotNull
    public static <Key, Value> AbstractMapForwardIndexAccessor<Key, Value, ?> getForwardIndexAccessor(@NotNull IndexExtension<Key, Value, ?> indexExtension) {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(35);
        }
        if (!(indexExtension instanceof SingleEntryFileBasedIndexExtension) || FileBasedIndex.USE_IN_MEMORY_INDEX) {
            return new MapForwardIndexAccessor(new InputMapExternalizer<Key, Value>(indexExtension));
        }
        return new SingleEntryIndexForwardIndexAccessor<Value>(indexExtension);
    }

    @Nullable
    private static ForwardIndex getForwardIndexMap(@NotNull IndexExtension<?, ?, ?> indexExtension) throws IOException {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(36);
        }
        if (!VfsAwareMapReduceIndex.shouldCreateForwardIndex(indexExtension)) {
            return null;
        }
        if (FileBasedIndex.USE_IN_MEMORY_INDEX) {
            return new InMemoryForwardIndex();
        }
        if (indexExtension instanceof SingleEntryFileBasedIndexExtension) {
            return new EmptyForwardIndex();
        }
        File indexStorageFile = IndexInfrastructure.getInputIndexStorageFile((ID)indexExtension.getName());
        return new PersistentMapBasedForwardIndex(indexStorageFile.toPath(), false, false);
    }

    private static boolean shouldCreateForwardIndex(@NotNull IndexExtension<?, ?, ?> indexExtension) {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(37);
        }
        return !VfsAwareMapReduceIndex.hasSnapshotMapping(indexExtension);
    }

    private void installMemoryModeListener() {
        IndexStorage storage = this.getStorage();
        if (storage instanceof TransientChangesIndexStorage) {
            ((TransientChangesIndexStorage)storage).addBufferingStateListener(new TransientChangesIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState2) {
                    VfsAwareMapReduceIndex.this.myInMemoryMode.set(newState2);
                }

                @Override
                public void memoryStorageCleared() {
                    VfsAwareMapReduceIndex.this.myInMemoryKeysAndValues.clear();
                }
            });
        }
    }

    @NotNull
    private Collection<Key> getKeys(InputDataDiffBuilder<Key, ?> builder2) throws StorageException {
        if (builder2 instanceof DirectInputDataDiffBuilder) {
            Collection collection = ((DirectInputDataDiffBuilder)builder2).getKeys();
            if (collection == null) {
                VfsAwareMapReduceIndex.$$$reportNull$$$0(38);
            }
            return collection;
        }
        LOG.error("Input data diff builder must be an instance of DirectInputDataDiffBuilder for index " + this.myIndexId.getName());
        THashSet keys2 = new THashSet();
        builder2.differentiate(Collections.emptyMap(), (key, value2, inputId) -> {}, (key, value2, inputId) -> {}, (arg_0, arg_1) -> VfsAwareMapReduceIndex.lambda$getKeys$8((Set)keys2, arg_0, arg_1));
        THashSet tHashSet = keys2;
        if (tHashSet == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(39);
        }
        return tHashSet;
    }

    private static /* synthetic */ void lambda$getKeys$8(Set keys2, Object key, int inputId) throws StorageException {
        keys2.add(key);
    }

    static {
        Application app = ApplicationManager.getApplication();
        if (!IndexDebugProperties.DEBUG) {
            boolean bl = IndexDebugProperties.DEBUG = (app.isEAP() || app.isInternal()) && !ApplicationInfoImpl.isInStressTest();
        }
        if (!IndexDebugProperties.IS_UNIT_TEST_MODE) {
            IndexDebugProperties.IS_UNIT_TEST_MODE = app.isUnitTestMode();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexer";
                break;
            }
            case 7: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexExtension";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/storage/VfsAwareMapReduceIndex";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keysAndValues";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 17: 
            case 18: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffBuilder";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/storage/VfsAwareMapReduceIndex";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInput";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysDiffBuilder";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingStateForFile";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedFileData";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCompositeIndexer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasSnapshotMapping";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 38: 
            case 39: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getKeysDiffBuilder";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateForwardIndex";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedStateForFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStateForFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isIndexConfigurationUpToDate";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setIndexConfigurationUpToDate";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForInMemoryKeys";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForKeys";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "requestRebuild";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "updateWithMap";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getForwardIndexAccessor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getForwardIndexMap";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateForwardIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

