/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePaths;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fJ\u0006\u0010\u001a\u001a\u00020\u001bR!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\r\u001a*\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000ej\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnosticBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "allIndexedFilePaths", "Ljava/util/ArrayList;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "Lkotlin/collections/ArrayList;", "getAllIndexedFilePaths", "()Ljava/util/ArrayList;", "filesFromUnsupportedFileSystems", "getFilesFromUnsupportedFileSystems", "projectIndexedFileProviderDebugNameToFileIds", "Ljava/util/HashMap;", "", "", "", "Lkotlin/collections/HashMap;", "getProjectIndexedFileProviderDebugNameToFileIds", "()Ljava/util/HashMap;", "addFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "providerName", "build", "Lcom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnostic;", "intellij.platform.lang.impl"})
public final class IndexContentDiagnosticBuilder {
    @NotNull
    private final ArrayList<IndexedFilePath> allIndexedFilePaths;
    @NotNull
    private final ArrayList<IndexedFilePath> filesFromUnsupportedFileSystems;
    @NotNull
    private final HashMap<String, Set<Integer>> projectIndexedFileProviderDebugNameToFileIds;
    private final Project project;

    @NotNull
    public final ArrayList<IndexedFilePath> getAllIndexedFilePaths() {
        return this.allIndexedFilePaths;
    }

    @NotNull
    public final ArrayList<IndexedFilePath> getFilesFromUnsupportedFileSystems() {
        return this.filesFromUnsupportedFileSystems;
    }

    @NotNull
    public final HashMap<String, Set<Integer>> getProjectIndexedFileProviderDebugNameToFileIds() {
        return this.projectIndexedFileProviderDebugNameToFileIds;
    }

    public final void addFile(@NotNull VirtualFile file2, @NotNull String providerName) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        if (file2.isDirectory()) {
            return;
        }
        IndexedFilePath indexedFilePath = IndexedFilePaths.INSTANCE.createIndexedFilePath(file2, this.project);
        if (PortableFilePaths.INSTANCE.isSupportedFileSystem(file2)) {
            Object object;
            Collection collection = this.allIndexedFilePaths;
            boolean bl = false;
            collection.add(indexedFilePath);
            Map $this$getOrPut$iv = this.projectIndexedFileProviderDebugNameToFileIds;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(providerName);
            if (value$iv == null) {
                boolean bl2 = false;
                Set answer$iv = new TreeSet();
                $this$getOrPut$iv.put(providerName, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            collection = (Set)object;
            Integer n = indexedFilePath.getOriginalFileSystemId();
            boolean bl3 = false;
            collection.add(n);
        } else {
            Collection collection = this.filesFromUnsupportedFileSystems;
            boolean bl = false;
            collection.add(indexedFilePath);
        }
    }

    @NotNull
    public final IndexContentDiagnostic build() {
        return new IndexContentDiagnostic((List<IndexedFilePath>)this.allIndexedFilePaths, (List<IndexedFilePath>)this.filesFromUnsupportedFileSystems, (Map<String, ? extends Set<Integer>>)this.projectIndexedFileProviderDebugNameToFileIds);
    }

    public IndexContentDiagnosticBuilder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean bl = false;
        this.allIndexedFilePaths = new ArrayList();
        bl = false;
        this.filesFromUnsupportedFileSystems = new ArrayList();
        bl = false;
        this.projectIndexedFileProviderDebugNameToFileIds = new HashMap();
    }
}

