/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootType;
import com.intellij.util.LogicalRootsManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.VirtualFileLogicalRoot;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogicalRootsManagerImpl
extends LogicalRootsManager {
    private Map<Module, MultiValuesMap<LogicalRootType, LogicalRoot>> myRoots = null;
    private final MultiValuesMap<LogicalRootType, NotNullFunction<? super Module, ? extends List<? extends LogicalRoot>>> myProviders = new MultiValuesMap();
    private final ModuleManager myModuleManager;
    private final Project myProject;

    public LogicalRootsManagerImpl(Project project) {
        this.myModuleManager = ModuleManager.getInstance((Project)project);
        this.myProject = project;
        this.registerLogicalRootProvider(LogicalRootType.SOURCE_ROOT, module -> ContainerUtil.map2List((Object[])ModuleRootManager.getInstance((Module)module).getSourceRoots(), s -> new VirtualFileLogicalRoot(s)));
    }

    private synchronized void clear() {
        this.myRoots = null;
    }

    private synchronized Map<Module, MultiValuesMap<LogicalRootType, LogicalRoot>> getRoots(ModuleManager moduleManager) {
        if (this.myRoots == null) {
            Module[] modules2;
            this.myRoots = new THashMap();
            for (Module module : modules2 = moduleManager.getModules()) {
                MultiValuesMap map2 = new MultiValuesMap();
                for (Map.Entry entry : this.myProviders.entrySet()) {
                    Collection functions = (Collection)entry.getValue();
                    for (NotNullFunction function : functions) {
                        map2.putAll((Object)((LogicalRootType)entry.getKey()), (Collection)function.fun((Object)module));
                    }
                }
                this.myRoots.put(module, (MultiValuesMap<LogicalRootType, LogicalRoot>)map2);
            }
        }
        return this.myRoots;
    }

    @Nullable
    public LogicalRoot findLogicalRoot(@NotNull VirtualFile file2) {
        Module module;
        if (file2 == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtil.findModuleForFile((VirtualFile)file2, (Project)this.myProject)) == null) {
            return null;
        }
        LogicalRoot result2 = null;
        List<LogicalRoot> list2 = this.getLogicalRoots(module);
        for (LogicalRoot root : list2) {
            VirtualFile rootFile = root.getVirtualFile();
            if (rootFile == null || !VfsUtil.isAncestor((VirtualFile)rootFile, (VirtualFile)file2, (boolean)false)) continue;
            result2 = root;
            break;
        }
        return result2;
    }

    public List<LogicalRoot> getLogicalRoots() {
        return ContainerUtil.concat((Object[])this.myModuleManager.getModules(), module -> this.getLogicalRoots((Module)module));
    }

    private List<LogicalRoot> getLogicalRoots(@NotNull Module module) {
        Map<Module, MultiValuesMap<LogicalRootType, LogicalRoot>> roots;
        MultiValuesMap<LogicalRootType, LogicalRoot> valuesMap;
        if (module == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(1);
        }
        if ((valuesMap = (roots = this.getRoots(this.myModuleManager)).get(module)) == null) {
            return Collections.emptyList();
        }
        return new ArrayList<LogicalRoot>(valuesMap.values());
    }

    public <T extends LogicalRoot> void registerLogicalRootProvider(@NotNull LogicalRootType<T> rootType, @NotNull NotNullFunction<? super Module, ? extends List<T>> provider2) {
        if (rootType == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(2);
        }
        if (provider2 == null) {
            LogicalRootsManagerImpl.$$$reportNull$$$0(3);
        }
        this.myProviders.put(rootType, provider2);
        this.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/LogicalRootsManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findLogicalRoot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLogicalRoots";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerLogicalRootProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

