/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.util.ListWithSelection;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.EnumSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public final class ComboBoxTableCellRenderer
extends JPanel
implements TableCellRenderer {
    public static final TableCellRenderer INSTANCE = new ComboBoxTableCellRenderer();
    public static final TableCellRenderer COMBO_WHEN_SELECTED_RENDERER = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                value2 = new ListWithSelection(Collections.singletonList(value2));
                return INSTANCE.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
        }
    };
    private static final Logger LOG = Logger.getInstance(ComboBoxTableCellRenderer.class);
    private final JComboBox myCombo = new ComboBox();

    private ComboBoxTableCellRenderer() {
        super(new GridBagLayout());
        this.add((Component)this.myCombo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
    }

    @Override
    public JComponent getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value2 instanceof ListWithSelection) {
            ListWithSelection tags = (ListWithSelection)value2;
            if (tags.getSelection() == null) {
                tags.selectFirst();
            }
            this.updateCombobox((Iterable<?>)tags, tags.getSelection());
        } else if (value2 instanceof Enum) {
            Enum selectedValue = (Enum)value2;
            this.updateCombobox(EnumSet.allOf(selectedValue.getDeclaringClass()), selectedValue);
        } else {
            if (value2 != null) {
                LOG.error("value " + LogUtil.objectAndClass((Object)value2) + ", at " + row + ":" + column + ", in " + table.getModel());
            }
            this.myCombo.removeAllItems();
            this.myCombo.setSelectedIndex(-1);
        }
        this.myCombo.setEnabled(table.isCellEditable(row, column));
        return this;
    }

    private void updateCombobox(@NotNull Iterable<?> options2, @NotNull Object selectedOption) {
        if (options2 == null) {
            ComboBoxTableCellRenderer.$$$reportNull$$$0(0);
        }
        if (selectedOption == null) {
            ComboBoxTableCellRenderer.$$$reportNull$$$0(1);
        }
        this.myCombo.removeAllItems();
        for (Object option2 : options2) {
            this.myCombo.addItem(option2);
        }
        this.myCombo.setSelectedItem(selectedOption);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "options";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "selectedOption";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/ComboBoxTableCellRenderer";
        objectArray[2] = "updateCombobox";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

