/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkPropertiesHolder;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.util.PathMappingSettings;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkCredentialsHolder
extends RemoteCredentialsHolder
implements RemoteSdkCredentials {
    @NotNull
    private final RemoteSdkPropertiesHolder myRemoteSdkProperties;

    public RemoteSdkCredentialsHolder(@NotNull String defaultHelpersDirName) {
        if (defaultHelpersDirName == null) {
            RemoteSdkCredentialsHolder.$$$reportNull$$$0(0);
        }
        this.myRemoteSdkProperties = new RemoteSdkPropertiesHolder(defaultHelpersDirName);
    }

    public static String constructSshCredentialsSdkFullPath(@NotNull RemoteSdkCredentials cred) {
        if (cred == null) {
            RemoteSdkCredentialsHolder.$$$reportNull$$$0(1);
        }
        @NlsSafe StringBuilder builder2 = new StringBuilder();
        if (cred.isRunAsRootViaSudo()) {
            builder2.append("sudo+");
        }
        return builder2.append(RemoteSdkCredentialsHolder.getCredentialsString(cred)).append(cred.getInterpreterPath()).toString();
    }

    public static String getInterpreterPathFromFullPath(String fullPath) {
        int index;
        if (fullPath.startsWith("ssh://") && (index = (fullPath = fullPath.substring("ssh://".length())).indexOf(":")) != -1 && index < fullPath.length()) {
            fullPath = fullPath.substring(index + 1);
            for (index = 0; index < fullPath.length() && Character.isDigit(fullPath.charAt(index)); ++index) {
            }
            if (index < fullPath.length()) {
                return fullPath.substring(index);
            }
        }
        return fullPath;
    }

    @NotNull
    public RemoteSdkPropertiesHolder getRemoteSdkProperties() {
        RemoteSdkPropertiesHolder remoteSdkPropertiesHolder = this.myRemoteSdkProperties;
        if (remoteSdkPropertiesHolder == null) {
            RemoteSdkCredentialsHolder.$$$reportNull$$$0(2);
        }
        return remoteSdkPropertiesHolder;
    }

    @Override
    public String getInterpreterPath() {
        return this.myRemoteSdkProperties.getInterpreterPath();
    }

    @Override
    public void setInterpreterPath(String interpreterPath) {
        this.myRemoteSdkProperties.setInterpreterPath(interpreterPath);
    }

    @Override
    public String getHelpersPath() {
        return this.myRemoteSdkProperties.getHelpersPath();
    }

    @Override
    public void setHelpersPath(String helpersPath) {
        this.myRemoteSdkProperties.setHelpersPath(helpersPath);
    }

    @Override
    public String getDefaultHelpersName() {
        return this.myRemoteSdkProperties.getDefaultHelpersName();
    }

    @Override
    @NotNull
    public PathMappingSettings getPathMappings() {
        PathMappingSettings pathMappingSettings = this.myRemoteSdkProperties.getPathMappings();
        if (pathMappingSettings == null) {
            RemoteSdkCredentialsHolder.$$$reportNull$$$0(3);
        }
        return pathMappingSettings;
    }

    @Override
    public void setPathMappings(@Nullable PathMappingSettings pathMappings) {
        this.myRemoteSdkProperties.setPathMappings(pathMappings);
    }

    @Override
    public boolean isHelpersVersionChecked() {
        return this.myRemoteSdkProperties.isHelpersVersionChecked();
    }

    @Override
    public void setHelpersVersionChecked(boolean helpersVersionChecked) {
        this.myRemoteSdkProperties.setHelpersVersionChecked(helpersVersionChecked);
    }

    @Override
    public String getFullInterpreterPath() {
        return RemoteSdkCredentialsHolder.constructSshCredentialsSdkFullPath(this);
    }

    @Override
    public void setSdkId(String sdkId) {
        this.myRemoteSdkProperties.setSdkId(sdkId);
    }

    @Override
    public String getSdkId() {
        return this.myRemoteSdkProperties.getSdkId();
    }

    @Override
    public boolean isInitialized() {
        return this.myRemoteSdkProperties.isInitialized();
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.myRemoteSdkProperties.setInitialized(initialized);
    }

    @Override
    public boolean isValid() {
        return this.myRemoteSdkProperties.isValid();
    }

    @Override
    public void setValid(boolean valid) {
        this.myRemoteSdkProperties.setValid(valid);
    }

    @Override
    public boolean isRunAsRootViaSudo() {
        return this.myRemoteSdkProperties.isRunAsRootViaSudo();
    }

    @Override
    public void setRunAsRootViaSudo(boolean runAsRootViaSudo) {
        this.myRemoteSdkProperties.setRunAsRootViaSudo(runAsRootViaSudo);
    }

    public static boolean isRemoteSdk(@Nullable String path) {
        if (path != null) {
            for (CredentialsType<?> type : CredentialsManager.getInstance().getAllTypes()) {
                if (!type.hasPrefix(path)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void load(Element element2) {
        super.load(element2);
        this.myRemoteSdkProperties.load(element2);
    }

    @Override
    public void save(Element rootElement) {
        super.save(rootElement);
        this.myRemoteSdkProperties.save(rootElement);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteSdkCredentialsHolder holder = (RemoteSdkCredentialsHolder)o;
        if (!this.getLiteralPort().equals(holder.getLiteralPort())) {
            return false;
        }
        if (this.isStorePassphrase() != holder.isStorePassphrase()) {
            return false;
        }
        if (this.isStorePassword() != holder.isStorePassword()) {
            return false;
        }
        if (this.getAuthType() != holder.getAuthType()) {
            return false;
        }
        if (!this.getHost().equals(holder.getHost())) {
            return false;
        }
        if (this.getPassphrase() != null ? !this.getPassphrase().equals(holder.getPassphrase()) : holder.getPassphrase() != null) {
            return false;
        }
        if (this.getPassword() != null ? !this.getPassword().equals(holder.getPassword()) : holder.getPassword() != null) {
            return false;
        }
        if (!this.getPrivateKeyFile().equals(holder.getPrivateKeyFile())) {
            return false;
        }
        if (this.getUserName() != null ? !this.getUserName().equals(holder.getUserName()) : holder.getUserName() != null) {
            return false;
        }
        return this.myRemoteSdkProperties.equals(holder.myRemoteSdkProperties);
    }

    @Override
    public int hashCode() {
        int result2 = this.getHost().hashCode();
        result2 = 31 * result2 + this.getLiteralPort().hashCode();
        result2 = 31 * result2 + (this.getUserName() != null ? this.getUserName().hashCode() : 0);
        result2 = 31 * result2 + (this.getPassword() != null ? this.getPassword().hashCode() : 0);
        result2 = 31 * result2 + this.getAuthType().hashCode();
        result2 = 31 * result2 + this.getPrivateKeyFile().hashCode();
        result2 = 31 * result2 + (this.getPassphrase() != null ? this.getPassphrase().hashCode() : 0);
        result2 = 31 * result2 + (this.isStorePassword() ? 1 : 0);
        result2 = 31 * result2 + (this.isStorePassphrase() ? 1 : 0);
        result2 = 31 * result2 + this.myRemoteSdkProperties.hashCode();
        return result2;
    }

    @NonNls
    public String toString() {
        return "RemoteSdkDataHolder{getHost()='" + this.getHost() + "', getLiteralPort()=" + this.getLiteralPort() + ", getUserName()='" + this.getUserName() + "', myInterpreterPath='" + this.getInterpreterPath() + "', isRunAsRootViaSudo=" + this.isRunAsRootViaSudo() + ", myHelpersPath='" + this.getHelpersPath() + "'}";
    }

    public void copyRemoteSdkCredentialsTo(RemoteSdkCredentialsHolder to) {
        super.copyRemoteCredentialsTo(to);
        this.myRemoteSdkProperties.copyTo(to.getRemoteSdkProperties());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHelpersDirName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cred";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/RemoteSdkCredentialsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/RemoteSdkCredentialsHolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkProperties";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "constructSshCredentialsSdkFullPath";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

