/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.CachedValueWithTTL;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListParser;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.util.io.HttpRequests;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.XZInputStream;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\"\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\f\u001a\u0004\u0018\u00010\rR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkListDownloaderBase;", "", "()V", "feedUrl", "", "getFeedUrl", "()Ljava/lang/String;", "jdksListCache", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/CachedValueWithTTL;", "", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "downloadForUI", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "downloadJdkList", "", "kotlin.jvm.PlatformType", "downloadJdksListNoCache", "downloadJdksListWithCache", "downloadModelForJdkInstaller", "intellij.platform.lang.impl"})
public abstract class JdkListDownloaderBase {
    private final CachedValueWithTTL<List<JdkItem>> jdksListCache = new CachedValueWithTTL((Pair<Integer, ? extends TimeUnit>)TuplesKt.to((Object)15, (Object)((Object)TimeUnit.MINUTES)));

    @NotNull
    protected abstract String getFeedUrl();

    private final byte[] downloadJdkList(String feedUrl, ProgressIndicator progress2) {
        return HttpRequests.request((String)feedUrl).productNameAsUserAgent().readBytes(progress2);
    }

    @NotNull
    public final List<JdkItem> downloadModelForJdkInstaller(@Nullable ProgressIndicator progress2) {
        return this.downloadJdksListWithCache(this.getFeedUrl(), progress2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JdkItem> downloadForUI(@Nullable ProgressIndicator progress2, @Nullable String feedUrl) {
        void $this$filterTo$iv$iv;
        String string = feedUrl;
        if (string == null) {
            string = this.getFeedUrl();
        }
        String url = string;
        List<JdkItem> list2 = this.downloadJdksListNoCache(url, progress2);
        this.jdksListCache.setValue(url, list2);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isInternal()) {
            return list2;
        }
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JdkItem it = (JdkItem)element$iv$iv;
            boolean bl = false;
            if (!it.isVisibleOnUI()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List downloadForUI$default(JdkListDownloaderBase jdkListDownloaderBase, ProgressIndicator progressIndicator, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: downloadForUI");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return jdkListDownloaderBase.downloadForUI(progressIndicator, string);
    }

    private final List<JdkItem> downloadJdksListWithCache(String feedUrl, ProgressIndicator progress2) {
        String string = feedUrl;
        if (string == null) {
            string = this.getFeedUrl();
        }
        String feedUrl2 = string;
        boolean bl = false;
        return this.jdksListCache.getOrCompute(feedUrl2, CollectionsKt.emptyList(), (Function0<List<JdkItem>>)((Function0)new Function0<List<? extends JdkItem>>(this, feedUrl2, progress2){
            final /* synthetic */ JdkListDownloaderBase this$0;
            final /* synthetic */ String $feedUrl;
            final /* synthetic */ ProgressIndicator $progress;

            @NotNull
            public final List<JdkItem> invoke() {
                return JdkListDownloaderBase.access$downloadJdksListNoCache(this.this$0, this.$feedUrl, this.$progress);
            }
            {
                this.this$0 = jdkListDownloaderBase;
                this.$feedUrl = string;
                this.$progress = progressIndicator;
                super(0);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<JdkItem> downloadJdksListNoCache(String feedUrl, ProgressIndicator progress2) {
        ObjectNode t3;
        Object t22;
        byte[] byArray;
        try {
            byArray = this.downloadJdkList(feedUrl, progress2);
        }
        catch (IOException t22) {
            Logger.getInstance(this.getClass()).warn("Failed to download the list of available JDKs from " + feedUrl + ". " + t22.getMessage());
            return CollectionsKt.emptyList();
        }
        byte[] rawDataXZ = byArray;
        try {
            byte[] byArray2;
            t22 = new ByteArrayInputStream(rawDataXZ);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                byte[] byArray3;
                ByteArrayInputStream input = (ByteArrayInputStream)t22;
                boolean bl3 = false;
                Closeable closeable = (Closeable)new XZInputStream((InputStream)input);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    XZInputStream it = (XZInputStream)closeable;
                    boolean bl6 = false;
                    byArray3 = ByteStreamsKt.readBytes((InputStream)((InputStream)it));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                byArray2 = byArray3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)t22, (Throwable)throwable);
            }
            t22 = byArray2;
        }
        catch (Throwable t3) {
            throw (Throwable)new RuntimeException("Failed to unpack the list of available JDKs from " + feedUrl + ". " + t3.getMessage(), t3);
        }
        Object rawData = t22;
        try {
            t3 = JdkListParser.INSTANCE.readTree((byte[])rawData);
        }
        catch (Throwable t4) {
            throw (Throwable)new RuntimeException("Failed to parse the downloaded list of available JDKs. " + t4.getMessage(), t4);
        }
        ObjectNode json = t3;
        try {
            ImmutableList immutableList = ImmutableList.copyOf((Collection)JdkListParser.INSTANCE.parseJdkList(json, JdkPredicate.Companion.createInstance()));
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"ImmutableList.copyOf(Jdk\u2026dicate.createInstance()))");
            return (List)immutableList;
        }
        catch (Throwable t23) {
            throw (Throwable)new RuntimeException("Failed to process the downloaded list of available JDKs from " + feedUrl + ". " + t23.getMessage(), t23);
        }
    }

    public static final /* synthetic */ List access$downloadJdksListNoCache(JdkListDownloaderBase $this, String feedUrl, ProgressIndicator progress2) {
        return $this.downloadJdksListNoCache(feedUrl, progress2);
    }
}

