/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.impl.UnknownSdkEditorPanel;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFix;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnknownSdkEditorNotification {
    public static final Key<List<EditorNotificationPanel>> NOTIFICATIONS = Key.create((String)"notifications added to the editor");
    private final Project myProject;
    private final FileEditorManager myFileEditorManager;
    private final AtomicReference<Set<UnknownSdkFix>> myNotifications;

    @NotNull
    public static UnknownSdkEditorNotification getInstance(@NotNull Project project) {
        if (project == null) {
            UnknownSdkEditorNotification.$$$reportNull$$$0(0);
        }
        UnknownSdkEditorNotification unknownSdkEditorNotification = (UnknownSdkEditorNotification)project.getService(UnknownSdkEditorNotification.class);
        if (unknownSdkEditorNotification == null) {
            UnknownSdkEditorNotification.$$$reportNull$$$0(1);
        }
        return unknownSdkEditorNotification;
    }

    UnknownSdkEditorNotification(@NotNull Project project) {
        if (project == null) {
            UnknownSdkEditorNotification.$$$reportNull$$$0(2);
        }
        this.myNotifications = new AtomicReference(new LinkedHashSet());
        this.myProject = project;
        this.myFileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (FileEditor editor : UnknownSdkEditorNotification.this.myFileEditorManager.getEditors(file2)) {
                    UnknownSdkEditorNotification.this.updateEditorNotifications(editor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorNotification$1";
                objectArray[2] = "fileOpened";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public boolean allowProjectSdkNotifications() {
        return this.myNotifications.get().isEmpty();
    }

    @NotNull
    public List<UnknownSdkFix> getNotifications() {
        ImmutableList immutableList = ImmutableList.copyOf((Collection)this.myNotifications.get());
        if (immutableList == null) {
            UnknownSdkEditorNotification.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    public void showNotifications(@NotNull List<UnknownSdkFix> notifications) {
        if (notifications == null) {
            UnknownSdkEditorNotification.$$$reportNull$$$0(4);
        }
        if (!Registry.is((String)"unknown.sdk.show.editor.actions")) {
            notifications = Collections.emptyList();
        }
        this.myNotifications.set((Set<UnknownSdkFix>)ImmutableSet.copyOf(notifications));
        EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
        ApplicationManager.getApplication().invokeLater(() -> {
            for (FileEditor editor : this.myFileEditorManager.getAllEditors()) {
                this.updateEditorNotifications(editor);
            }
        });
    }

    private void updateEditorNotifications(@NotNull FileEditor editor) {
        if (editor == null) {
            UnknownSdkEditorNotification.$$$reportNull$$$0(5);
        }
        if (!editor.isValid()) {
            return;
        }
        List notifications = (List)editor.getUserData(NOTIFICATIONS);
        if (notifications != null) {
            for (JComponent component2 : notifications) {
                this.myFileEditorManager.removeTopComponent(editor, component2);
            }
            notifications.clear();
        } else {
            notifications = new SmartList();
            editor.putUserData(NOTIFICATIONS, (Object)notifications);
        }
        for (UnknownSdkFix info : this.myNotifications.get()) {
            VirtualFile file2 = editor.getFile();
            if (file2 == null || !info.isRelevantFor(this.myProject, file2)) continue;
            UnknownSdkEditorPanel notification2 = new UnknownSdkEditorPanel(this.myProject, info);
            notifications.add(notification2);
            this.myFileEditorManager.addTopComponent(editor, (JComponent)((Object)notification2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorNotification";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notifications";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkEditorNotification";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showNotifications";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateEditorNotifications";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

