/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.hint.DocumentFragmentTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentFragment;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class FoldingPopupManager
implements EditorMouseListener,
EditorMouseMotionListener {
    private static final Key<Boolean> DISABLED = Key.create((String)"FoldingPopupManager.disabled");
    private static final TooltipGroup FOLDING_TOOLTIP_GROUP = new TooltipGroup("FOLDING_TOOLTIP_GROUP", 10);
    private static final int TOOLTIP_DELAY_MS = 300;
    private final Alarm myAlarm;

    public static void disableForEditor(@NotNull Editor editor) {
        if (editor == null) {
            FoldingPopupManager.$$$reportNull$$$0(0);
        }
        editor.putUserData(DISABLED, (Object)Boolean.TRUE);
        TooltipController.getInstance().cancelTooltip(FOLDING_TOOLTIP_GROUP, null, true);
    }

    public static void enableForEditor(@NotNull Editor editor) {
        if (editor == null) {
            FoldingPopupManager.$$$reportNull$$$0(1);
        }
        editor.putUserData(DISABLED, null);
    }

    FoldingPopupManager(EditorImpl editor) {
        this.myAlarm = new Alarm(editor.getDisposable());
        editor.addEditorMouseListener(this);
        editor.addEditorMouseMotionListener(this);
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(2);
        }
        this.myAlarm.cancelAllRequests();
        Editor editor = e.getEditor();
        if (editor.getUserData(DISABLED) != null) {
            return;
        }
        if (e.getArea() == EditorMouseEventArea.EDITING_AREA) {
            MouseEvent mouseEvent = e.getMouseEvent();
            Point point = mouseEvent.getPoint();
            FoldRegion fold2 = e.getCollapsedFoldRegion();
            TooltipController controller = TooltipController.getInstance();
            if (fold2 != null && !fold2.shouldNeverExpand()) {
                this.myAlarm.addRequest(() -> {
                    if (editor.getUserData(DISABLED) != null || !editor.getComponent().isShowing() || !fold2.isValid() || fold2.isExpanded()) {
                        return;
                    }
                    DocumentFragment range2 = FoldingPopupManager.createDocumentFragment(fold2);
                    Point p = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, editor.getComponent().getRootPane().getLayeredPane());
                    controller.showTooltip(editor, p, new DocumentFragmentTooltipRenderer(range2), false, FOLDING_TOOLTIP_GROUP);
                }, 300);
            } else {
                controller.cancelTooltip(FOLDING_TOOLTIP_GROUP, mouseEvent, true);
            }
        }
    }

    @NotNull
    private static DocumentFragment createDocumentFragment(@NotNull FoldRegion fold2) {
        int groupEndOffset;
        if (fold2 == null) {
            FoldingPopupManager.$$$reportNull$$$0(3);
        }
        EditorImpl editor = (EditorImpl)fold2.getEditor();
        DocumentEx document = editor.getDocument();
        FoldingGroup group2 = fold2.getGroup();
        int startOffset = fold2.getStartOffset();
        int endOffset = fold2.getEndOffset();
        if (group2 != null && editor.offsetToVisualLine(groupEndOffset = editor.getFoldingModel().getEndOffset(group2)) == editor.offsetToVisualLine(startOffset)) {
            endOffset = groupEndOffset;
        }
        return new DocumentFragment((Document)document, startOffset, endOffset);
    }

    public void mouseExited(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(4);
        }
        this.myAlarm.cancelAllRequests();
        if (e.getEditor().getUserData(DISABLED) != null) {
            return;
        }
        TooltipController.getInstance().cancelTooltip(FOLDING_TOOLTIP_GROUP, e.getMouseEvent(), true);
    }

    public void mouseDragged(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(5);
        }
    }

    public void mousePressed(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(6);
        }
    }

    public void mouseClicked(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(7);
        }
    }

    public void mouseReleased(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(8);
        }
    }

    public void mouseEntered(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(9);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fold";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/FoldingPopupManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "disableForEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "enableForEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createDocumentFragment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseExited";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDragged";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "mousePressed";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseClicked";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseReleased";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseEntered";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

