/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddCaretPerSelectedLineAction
extends EditorAction {
    public AddCaretPerSelectedLineAction() {
        super((EditorActionHandler)new Handler());
    }

    private static final class Handler
    extends EditorActionHandler {
        private Handler() {
            super(true);
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            assert (caret != null);
            CaretModel caretModel = editor.getCaretModel();
            Document document = editor.getDocument();
            int selectionStart = caret.getSelectionStart();
            int startLine = document.getLineNumber(selectionStart);
            int selectionEnd = caret.getSelectionEnd();
            int endLine = document.getLineNumber(selectionEnd);
            if (endLine > startLine && selectionEnd == document.getLineStartOffset(endLine)) {
                --endLine;
            }
            if (caretModel.getCaretCount() + endLine - startLine > caretModel.getMaxCaretCount()) {
                EditorUtil.notifyMaxCarets(editor);
                return;
            }
            caret.removeSelection();
            boolean primary = caret.getOffset() != selectionStart;
            for (int i2 = startLine; i2 <= endLine; ++i2) {
                int targetOffset = document.getLineEndOffset(i2);
                if (targetOffset == caret.getOffset()) {
                    caret.moveToOffset(targetOffset == 0 ? document.getTextLength() : 0);
                }
                caretModel.addCaret(editor.offsetToLogicalPosition(targetOffset), primary);
            }
            caretModel.removeCaret(caret);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/AddCaretPerSelectedLineAction$Handler", "doExecute"));
        }
    }
}

