/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.intellij.openapi.progress.ProgressIndicator;
import com.jetbrains.plugin.blockmap.core.BlockMap;
import com.jetbrains.plugin.blockmap.core.Chunk;
import com.jetbrains.plugin.blockmap.core.ChunkMerger;
import java.io.File;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/plugins/marketplace/PluginChunkMerger;", "Lcom/jetbrains/plugin/blockmap/core/ChunkMerger;", "oldFile", "Ljava/io/File;", "oldBlockMap", "Lcom/jetbrains/plugin/blockmap/core/BlockMap;", "newBlockMap", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Ljava/io/File;Lcom/jetbrains/plugin/blockmap/core/BlockMap;Lcom/jetbrains/plugin/blockmap/core/BlockMap;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "newFileSize", "", "progress", "downloadChunkFromNewData", "", "newChunk", "Lcom/jetbrains/plugin/blockmap/core/Chunk;", "newChunkDataSource", "", "", "output", "Ljava/io/OutputStream;", "downloadChunkFromOldData", "oldChunk", "oldFileRAF", "Ljava/io/RandomAccessFile;", "merge", "setIndicatorFraction", "intellij.platform.ide.impl"})
public final class PluginChunkMerger
extends ChunkMerger {
    private final int newFileSize;
    private int progress;
    private final ProgressIndicator indicator;

    public void merge(@NotNull OutputStream output, @NotNull Iterator<byte[]> newChunkDataSource) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter(newChunkDataSource, (String)"newChunkDataSource");
        this.indicator.checkCanceled();
        this.indicator.setIndeterminate(this.newFileSize <= 0);
        super.merge(output, newChunkDataSource);
    }

    public void downloadChunkFromNewData(@NotNull Chunk newChunk, @NotNull Iterator<byte[]> newChunkDataSource, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)newChunk, (String)"newChunk");
        Intrinsics.checkNotNullParameter(newChunkDataSource, (String)"newChunkDataSource");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.downloadChunkFromNewData(newChunk, newChunkDataSource, output);
        this.progress += newChunk.getLength();
        this.setIndicatorFraction();
    }

    public void downloadChunkFromOldData(@NotNull Chunk oldChunk, @NotNull RandomAccessFile oldFileRAF, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)oldChunk, (String)"oldChunk");
        Intrinsics.checkNotNullParameter((Object)oldFileRAF, (String)"oldFileRAF");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.downloadChunkFromOldData(oldChunk, oldFileRAF, output);
        this.progress += oldChunk.getLength();
        this.setIndicatorFraction();
    }

    private final void setIndicatorFraction() {
        this.indicator.checkCanceled();
        this.indicator.setFraction((double)this.progress / (double)this.newFileSize);
    }

    /*
     * WARNING - void declaration
     */
    public PluginChunkMerger(@NotNull File oldFile, @NotNull BlockMap oldBlockMap, @NotNull BlockMap newBlockMap2, @NotNull ProgressIndicator indicator) {
        int n;
        void $this$sumBy$iv;
        Intrinsics.checkNotNullParameter((Object)oldFile, (String)"oldFile");
        Intrinsics.checkNotNullParameter((Object)oldBlockMap, (String)"oldBlockMap");
        Intrinsics.checkNotNullParameter((Object)newBlockMap2, (String)"newBlockMap");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        super(oldFile, oldBlockMap, newBlockMap2, 0, 8, null);
        this.indicator = indicator;
        Iterable iterable = newBlockMap2.getChunks();
        PluginChunkMerger pluginChunkMerger = this;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void chunk;
            Chunk chunk2 = (Chunk)element$iv;
            n = sum$iv;
            boolean bl = false;
            int n2 = chunk.getLength();
            sum$iv = n + n2;
        }
        pluginChunkMerger.newFileSize = n = sum$iv;
    }
}

