/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClassPathXmlPathResolver
implements PathBasedJdomXIncluder.PathResolver<String> {
    private final ClassLoader classLoader;

    ClassPathXmlPathResolver(@NotNull ClassLoader classLoader) {
        if (classLoader == null) {
            ClassPathXmlPathResolver.$$$reportNull$$$0(0);
        }
        this.classLoader = classLoader;
    }

    @Override
    @NotNull
    public List<String> createNewStack(@Nullable Path base) {
        ArrayList<@NonNls String> stack = new ArrayList<String>(2);
        stack.add("META-INF");
        ArrayList<String> arrayList = stack;
        if (arrayList == null) {
            ClassPathXmlPathResolver.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Element resolvePath(@NotNull List<String> bases, @NotNull String relativePath, @Nullable String base, @NotNull SafeJdomFactory jdomFactory) throws IOException, JDOMException {
        InputStream stream;
        String path;
        if (bases == null) {
            ClassPathXmlPathResolver.$$$reportNull$$$0(2);
        }
        if (relativePath == null) {
            ClassPathXmlPathResolver.$$$reportNull$$$0(3);
        }
        if (jdomFactory == null) {
            ClassPathXmlPathResolver.$$$reportNull$$$0(4);
        }
        if (relativePath.charAt(0) != '/') {
            if (base == null) {
                base = bases.get(bases.size() - 1);
            }
            if (relativePath.startsWith("./")) {
                PluginManagerCore.getLogger().error("Do not use prefix ./: " + relativePath);
                relativePath = relativePath.substring(2);
            }
            path = base + "/" + relativePath;
            if (relativePath.indexOf(47, 1) > 0) {
                bases.add(PathUtil.getParentPath((String)path));
            }
        } else {
            path = relativePath.substring(1);
        }
        if ((stream = this.classLoader.getResourceAsStream(path)) == null) {
            throw new NoSuchFileException(relativePath);
        }
        Element element2 = JDOMUtil.load((InputStream)stream, (SafeJdomFactory)jdomFactory);
        if (element2 == null) {
            ClassPathXmlPathResolver.$$$reportNull$$$0(5);
        }
        return element2;
    }

    @Override
    @NotNull
    public Element resolvePath(@NotNull Path basePath, @NotNull String relativePath, @NotNull SafeJdomFactory jdomFactory) throws IOException, JDOMException {
        String path;
        if (basePath == null) {
            ClassPathXmlPathResolver.$$$reportNull$$$0(6);
        }
        if (relativePath == null) {
            ClassPathXmlPathResolver.$$$reportNull$$$0(7);
        }
        if (jdomFactory == null) {
            ClassPathXmlPathResolver.$$$reportNull$$$0(8);
        }
        if (relativePath.charAt(0) == '/') {
            path = relativePath.substring(1);
        } else {
            if (relativePath.startsWith("./")) {
                PluginManagerCore.getLogger().error("Do not use prefix ./: " + relativePath);
                relativePath = relativePath.substring(2);
            }
            path = "META-INF/" + relativePath;
        }
        InputStream stream = this.classLoader.getResourceAsStream(path);
        if (stream == null) {
            throw new NoSuchFileException(relativePath);
        }
        Element element2 = JDOMUtil.load((InputStream)stream, (SafeJdomFactory)jdomFactory);
        if (element2 == null) {
            ClassPathXmlPathResolver.$$$reportNull$$$0(9);
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/ClassPathXmlPathResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bases";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdomFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/ClassPathXmlPathResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewStack";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

