/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.LocalHistoryRecordsTable;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Pair;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.AbstractStorage;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class LocalHistoryStorage
extends AbstractStorage {
    public LocalHistoryStorage(@NotNull Path storageFilePath) throws IOException {
        if (storageFilePath == null) {
            LocalHistoryStorage.$$$reportNull$$$0(0);
        }
        super(storageFilePath, true);
    }

    protected AbstractRecordsTable createRecordsTable(PagePool pool, @NotNull Path recordsFile) throws IOException {
        if (recordsFile == null) {
            LocalHistoryStorage.$$$reportNull$$$0(1);
        }
        return new LocalHistoryRecordsTable(recordsFile, pool);
    }

    public long getFSTimestamp() {
        return (Long)this.withReadLock(() -> ((LocalHistoryRecordsTable)this.myRecordsTable).getFSTimestamp());
    }

    public void setFSTimestamp(long timestamp) {
        this.withWriteLock(() -> ((LocalHistoryRecordsTable)this.myRecordsTable).setFSTimestamp(timestamp));
    }

    public long getLastId() {
        return (Long)this.withReadLock(() -> ((LocalHistoryRecordsTable)this.myRecordsTable).getLastId());
    }

    public void setLastId(long lastId) {
        this.withWriteLock(() -> ((LocalHistoryRecordsTable)this.myRecordsTable).setLastId(lastId));
    }

    public int getFirstRecord() {
        return (Integer)this.withReadLock(() -> ((LocalHistoryRecordsTable)this.myRecordsTable).getFirstRecord());
    }

    public int getLastRecord() {
        return (Integer)this.withReadLock(() -> ((LocalHistoryRecordsTable)this.myRecordsTable).getLastRecord());
    }

    public int getPrevRecord(int record) {
        return (Integer)this.withReadLock(() -> ((LocalHistoryRecordsTable)this.myRecordsTable).getPrevRecord(record));
    }

    public int getNextRecord(int record) {
        return (Integer)this.withReadLock(() -> ((LocalHistoryRecordsTable)this.myRecordsTable).getNextRecord(record));
    }

    public long getTimestamp(int record) {
        return (Long)this.withReadLock(() -> ((LocalHistoryRecordsTable)this.myRecordsTable).getTimestamp(record));
    }

    public Pair<Long, Integer> getOffsetAndSize(int id2) {
        return (Pair)this.withReadLock(() -> Pair.create((Object)this.myRecordsTable.getAddress(id2), (Object)this.myRecordsTable.getSize(id2)));
    }

    public int createNextRecord() throws IOException {
        return (Integer)this.withWriteLock(() -> {
            LocalHistoryRecordsTable table = (LocalHistoryRecordsTable)this.myRecordsTable;
            int id2 = table.createNewRecord();
            int prev = table.getLastRecord();
            if (prev > 0) {
                table.setPrevRecord(id2, prev);
                table.setNextRecord(prev, id2);
            } else {
                table.setFirstRecord(id2);
            }
            table.setLastRecord(id2);
            table.setTimestamp(id2, Clock.getTime());
            return id2;
        });
    }

    public void deleteRecordsUpTo(int idInclusively) throws IOException {
        this.withWriteLock(() -> {
            LocalHistoryRecordsTable table = (LocalHistoryRecordsTable)this.myRecordsTable;
            int each = table.getFirstRecord();
            if (each == 0) {
                return;
            }
            while (each != 0) {
                boolean stop2 = each == idInclusively;
                int next = table.getNextRecord(each);
                this.doDeleteRecord(each);
                each = next;
                if (!stop2) continue;
                break;
            }
            if (each == 0) {
                table.setFirstRecord(0);
                table.setLastRecord(0);
            } else {
                table.setFirstRecord(each);
                table.setPrevRecord(each, 0);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageFilePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordsFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/history/core/LocalHistoryStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createRecordsTable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

