/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Descriptor {
    private static final Logger LOG = Logger.getInstance(Descriptor.class);
    @NotNull
    private final @InspectionMessage String myText;
    private final String[] myGroup;
    private final String myShortName;
    private final InspectionToolWrapper<?, ?> myToolWrapper;
    private final HighlightDisplayLevel myLevel;
    @Nullable
    private final NamedScope myScope;
    private final ScopeToolState myState;
    @NotNull
    private final InspectionProfileModifiableModel myInspectionProfile;
    private Element myConfig;
    private boolean myEnabled;

    public Descriptor(@NotNull ScopeToolState state, @NotNull InspectionProfileModifiableModel inspectionProfile, @NotNull Project project) {
        String[] stringArray;
        if (state == null) {
            Descriptor.$$$reportNull$$$0(0);
        }
        if (inspectionProfile == null) {
            Descriptor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            Descriptor.$$$reportNull$$$0(2);
        }
        this.myState = state;
        this.myInspectionProfile = inspectionProfile;
        InspectionToolWrapper tool = state.getTool();
        this.myText = tool.getDisplayName();
        String[] groupPath = tool.getGroupPath();
        if (groupPath.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = InspectionProfileEntry.getGeneralGroupName();
        } else {
            stringArray = groupPath;
        }
        this.myGroup = stringArray;
        this.myShortName = tool.getShortName();
        this.myScope = state.getScope(project);
        HighlightDisplayKey key = HighlightDisplayKey.findOrRegister((String)this.myShortName, (String)this.myText);
        this.myLevel = inspectionProfile.getErrorLevel(key, this.myScope, project);
        this.myEnabled = inspectionProfile.isToolEnabled(key, this.myScope, project);
        this.myToolWrapper = tool;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Descriptor)) {
            return false;
        }
        Descriptor descriptor2 = (Descriptor)obj;
        return this.myShortName.equals(descriptor2.myShortName) && this.myLevel.equals(descriptor2.getLevel()) && this.myEnabled == descriptor2.isEnabled() && this.myState.equalTo(descriptor2.getState());
    }

    public int hashCode() {
        int hash = this.myShortName.hashCode() + 29 * this.myLevel.hashCode();
        return this.myScope != null ? this.myScope.hashCode() + 29 * hash : hash;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @NotNull
    @InspectionMessage
    public String getText() {
        String string = this.myText;
        if (string == null) {
            Descriptor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayKey getKey() {
        HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.findOrRegister((String)this.myShortName, (String)this.myText);
        if (highlightDisplayKey == null) {
            Descriptor.$$$reportNull$$$0(4);
        }
        return highlightDisplayKey;
    }

    public HighlightDisplayLevel getLevel() {
        return this.myLevel;
    }

    @Nullable
    public Element getConfig() {
        return this.myConfig;
    }

    public void loadConfig() {
        if (this.myConfig == null) {
            InspectionToolWrapper<?, ?> toolWrapper = this.getToolWrapper();
            this.myConfig = Descriptor.createConfigElement(toolWrapper);
        }
    }

    @NotNull
    public InspectionToolWrapper<?, ?> getToolWrapper() {
        InspectionToolWrapper<?, ?> inspectionToolWrapper = this.myToolWrapper;
        if (inspectionToolWrapper == null) {
            Descriptor.$$$reportNull$$$0(5);
        }
        return inspectionToolWrapper;
    }

    @Nullable
    public String loadDescription() {
        this.loadConfig();
        return this.myToolWrapper.loadDescription();
    }

    @NotNull
    public InspectionProfileModifiableModel getInspectionProfile() {
        InspectionProfileModifiableModel inspectionProfileModifiableModel = this.myInspectionProfile;
        if (inspectionProfileModifiableModel == null) {
            Descriptor.$$$reportNull$$$0(6);
        }
        return inspectionProfileModifiableModel;
    }

    @NotNull
    public static Element createConfigElement(InspectionToolWrapper<?, ?> toolWrapper) {
        Element element2 = new Element("options");
        try {
            toolWrapper.getTool().writeSettings(element2);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        Element element3 = element2;
        if (element3 == null) {
            Descriptor.$$$reportNull$$$0(7);
        }
        return element3;
    }

    public String @NotNull [] getGroup() {
        if (this.myGroup == null) {
            Descriptor.$$$reportNull$$$0(8);
        }
        return this.myGroup;
    }

    @NotNull
    public String getScopeName() {
        String string = this.myState.getScopeName();
        if (string == null) {
            Descriptor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public NamedScope getScope() {
        return this.myScope;
    }

    @NotNull
    public ScopeToolState getState() {
        ScopeToolState scopeToolState = this.myState;
        if (scopeToolState == null) {
            Descriptor.$$$reportNull$$$0(10);
        }
        return scopeToolState;
    }

    public String getShortName() {
        return this.myShortName;
    }

    public String toString() {
        return this.myShortName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionProfile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/Descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/Descriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWrapper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionProfile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

