/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProblemDescriptorWithReporterName;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.DaemonTooltipsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.RedundantSuppressInspection;
import com.intellij.codeInspection.RedundantSuppressionDetector;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.PluginException;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionsPass
extends ProgressableTextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(LocalInspectionsPass.class);
    public static final TextRange EMPTY_PRIORITY_RANGE = TextRange.EMPTY_RANGE;
    private static final Predicate<PsiFile> SHOULD_INSPECT_FILTER = file2 -> HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)file2);
    private final TextRange myPriorityRange;
    private final boolean myIgnoreSuppressed;
    private final ConcurrentMap<PsiFile, List<InspectionResult>> result;
    private volatile List<HighlightInfo> myInfos;
    private final String myShortcutText;
    private final SeverityRegistrar mySeverityRegistrar;
    private final InspectionProfileWrapper myProfileWrapper;
    private final Map<String, Set<PsiElement>> mySuppressedElements;
    private final boolean myInspectInjectedPsi;
    private static final Set<String> ourToolsWithInformationProblems = new HashSet<String>();
    private static final TextAttributes NONEMPTY_TEXT_ATTRIBUTES = new TextAttributes(){

        public boolean isEmpty() {
            return false;
        }
    };
    private final Map<TextRange, RangeMarker> ranges2markersCache;
    private final InjectedLanguageManager ilManager;
    private final List<HighlightInfo> infos;
    private final PsiDocumentManager documentManager;
    private final Set<Pair<TextRange, String>> emptyActionRegistered;
    private static final Interner<String> tooltips = Interner.createWeakInterner();

    public LocalInspectionsPass(@NotNull PsiFile file2, @NotNull Document document, int startOffset, int endOffset, @NotNull TextRange priorityRange, boolean ignoreSuppressed, @NotNull HighlightInfoProcessor highlightInfoProcessor, boolean inspectInjectedPsi) {
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            LocalInspectionsPass.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(2);
        }
        if (highlightInfoProcessor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(3);
        }
        super(file2.getProject(), document, LocalInspectionsPass.getPresentableNameText(), file2, null, new TextRange(startOffset, endOffset), true, highlightInfoProcessor);
        this.result = new ConcurrentHashMap<PsiFile, List<InspectionResult>>();
        this.myInfos = Collections.emptyList();
        this.mySuppressedElements = new ConcurrentHashMap<String, Set<PsiElement>>();
        this.ranges2markersCache = new THashMap();
        this.ilManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        this.infos = new ArrayList<HighlightInfo>(2);
        this.documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        this.emptyActionRegistered = Collections.synchronizedSet(new THashSet());
        assert (file2.isPhysical()) : "can't inspect non-physical file: " + file2 + "; " + file2.getVirtualFile();
        this.myPriorityRange = priorityRange;
        this.myIgnoreSuppressed = ignoreSuppressed;
        this.setId(7);
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 != null) {
            Keymap keymap2 = keymapManager2.getActiveKeymap();
            this.myShortcutText = "(" + KeymapUtil.getShortcutsText((Shortcut[])keymap2.getShortcuts("ShowErrorDescription")) + ")";
        } else {
            this.myShortcutText = "";
        }
        InspectionProfileImpl profileToUse = ProjectInspectionProfileManager.getInstance(this.myProject).getCurrentProfile();
        Function custom = (Function)file2.getUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY);
        InspectionProfileWrapper inspectionProfileWrapper = this.myProfileWrapper = custom == null ? new InspectionProfileWrapper(profileToUse) : (InspectionProfileWrapper)custom.apply(profileToUse);
        assert (this.myProfileWrapper != null);
        this.mySeverityRegistrar = this.myProfileWrapper.getProfileManager().getSeverityRegistrar();
        this.myInspectInjectedPsi = inspectInjectedPsi;
        this.setProgressLimit(600L);
    }

    @NotNull
    private PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            LocalInspectionsPass.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress2) {
        if (progress2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(5);
        }
        try {
            if (!HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)this.getFile())) {
                return;
            }
            this.inspect(this.getInspectionTools(this.myProfileWrapper), InspectionManager.getInstance((Project)this.myProject), true, progress2);
        }
        finally {
            this.disposeDescriptors();
        }
    }

    private void disposeDescriptors() {
        this.result.clear();
    }

    public void doInspectInBatch(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionManager iManager, @NotNull List<? extends LocalInspectionToolWrapper> toolWrappers) {
        if (context == null) {
            LocalInspectionsPass.$$$reportNull$$$0(6);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(7);
        }
        if (toolWrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(8);
        }
        ProgressIndicator progress2 = ProgressManager.getInstance().getProgressIndicator();
        this.inspect(new ArrayList<LocalInspectionToolWrapper>(toolWrappers), iManager, false, progress2);
        this.addDescriptorsFromInjectedResults(context);
        List resultList = (List)this.result.get(this.getFile());
        if (resultList == null) {
            return;
        }
        for (InspectionResult inspectionResult : resultList) {
            LocalInspectionToolWrapper toolWrapper = inspectionResult.tool;
            String shortName = toolWrapper.getShortName();
            for (ProblemDescriptor problemDescriptor : inspectionResult.foundProblems) {
                if (problemDescriptor.getHighlightType() == ProblemHighlightType.INFORMATION) {
                    if (!ourToolsWithInformationProblems.add(shortName)) continue;
                    LOG.error("Tool #" + shortName + " registers INFORMATION level problem in batch mode on " + this.getFile() + ". INFORMATION level 'warnings' are invisible in the editor and should not become visible in batch mode. Moreover, cause INFORMATION level fixes act more like intention actions, they could e.g. change semantics and thus should not be suggested for batch transformations");
                    continue;
                }
                this.addDescriptors(toolWrapper, problemDescriptor, context);
            }
        }
    }

    private void addDescriptors(@NotNull LocalInspectionToolWrapper toolWrapper, @NotNull ProblemDescriptor descriptor2, @NotNull GlobalInspectionContextImpl context) {
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(10);
        }
        if (context == null) {
            LocalInspectionsPass.$$$reportNull$$$0(11);
        }
        InspectionToolPresentation toolPresentation = context.getPresentation(toolWrapper);
        BatchModeDescriptorsUtil.addProblemDescriptors(Collections.singletonList(descriptor2), toolPresentation, this.myIgnoreSuppressed, context, (LocalInspectionTool)toolWrapper.getTool());
    }

    private void addDescriptorsFromInjectedResults(@NotNull GlobalInspectionContextImpl context) {
        if (context == null) {
            LocalInspectionsPass.$$$reportNull$$$0(12);
        }
        for (Map.Entry entry : this.result.entrySet()) {
            PsiFile file2 = (PsiFile)entry.getKey();
            if (file2 == this.getFile()) continue;
            List resultList = (List)entry.getValue();
            for (InspectionResult inspectionResult : resultList) {
                LocalInspectionToolWrapper toolWrapper = inspectionResult.tool;
                for (ProblemDescriptor problemDescriptor : inspectionResult.foundProblems) {
                    PsiElement psiElement = problemDescriptor.getPsiElement();
                    if (psiElement == null || ((LocalInspectionTool)toolWrapper.getTool()).isSuppressedFor(psiElement)) continue;
                    this.addDescriptors(toolWrapper, problemDescriptor, context);
                }
            }
        }
    }

    private void inspect(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator progress2) {
        if (toolWrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(13);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(14);
        }
        if (progress2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(15);
        }
        if (toolWrappers.isEmpty()) {
            return;
        }
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(this.myFile, this.myRestrictRange, this.myPriorityRange, SHOULD_INSPECT_FILTER, (Processor<? super Divider.DividedElements>)new CommonProcessors.CollectProcessor(allDivided));
        List inside = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> d.inside));
        List outside = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> ContainerUtil.concat(d.outside, d.parents)));
        this.setProgressLimit((long)toolWrappers.size() * 2L);
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(this.getFile(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset());
        List<InspectionContext> init2 = this.visitPriorityElementsAndInit(InspectionEngine.filterToolsApplicableByLanguage(toolWrappers, InspectionEngine.calcElementDialectIds(inside, outside)), iManager, isOnTheFly, progress2, inside, session2);
        Set<PsiFile> alreadyVisitedInjected = this.inspectInjectedPsi(inside, isOnTheFly, progress2, iManager, true, toolWrappers, Collections.emptySet());
        this.visitRestElementsAndCleanup(progress2, outside, session2, init2);
        this.inspectInjectedPsi(outside, isOnTheFly, progress2, iManager, false, toolWrappers, alreadyVisitedInjected);
        ProgressManager.checkCanceled();
        this.myInfos = new ArrayList<HighlightInfo>();
        this.addHighlightsFromResults(this.myInfos);
        if (isOnTheFly) {
            this.highlightRedundantSuppressions(toolWrappers, iManager, inside, outside);
        }
    }

    private void highlightRedundantSuppressions(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull InspectionManager iManager, @NotNull List<? extends PsiElement> inside, @NotNull List<? extends PsiElement> outside) {
        if (toolWrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(16);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(17);
        }
        if (inside == null) {
            LocalInspectionsPass.$$$reportNull$$$0(18);
        }
        if (outside == null) {
            LocalInspectionsPass.$$$reportNull$$$0(19);
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)"RedundantSuppression");
        InspectionProfile inspectionProfile = this.myProfileWrapper.getInspectionProfile();
        if (key != null && inspectionProfile.isToolEnabled(key, (PsiElement)this.getFile())) {
            InspectionToolWrapper toolWrapper = inspectionProfile.getInspectionTool("RedundantSuppression", (PsiElement)this.getFile());
            Language fileLanguage = this.getFile().getLanguage();
            InspectionSuppressor suppressor = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(fileLanguage);
            if (suppressor instanceof RedundantSuppressionDetector) {
                if (toolWrappers.stream().anyMatch(LocalInspectionToolWrapper::runForWholeFile)) {
                    return;
                }
                HashSet<String> activeTools = new HashSet<String>();
                for (LocalInspectionToolWrapper localInspectionToolWrapper : toolWrappers) {
                    if (localInspectionToolWrapper.isUnfair() || !localInspectionToolWrapper.isApplicable(fileLanguage)) continue;
                    activeTools.add(localInspectionToolWrapper.getID());
                    ContainerUtil.addIfNotNull(activeTools, (Object)localInspectionToolWrapper.getAlternativeID());
                    InspectionElementsMerger elementsMerger = InspectionElementsMerger.getMerger((String)localInspectionToolWrapper.getShortName());
                    if (elementsMerger == null) continue;
                    activeTools.addAll(Arrays.asList(elementsMerger.getSuppressIds()));
                }
                LocalInspectionTool localTool = ((RedundantSuppressInspection)toolWrapper.getTool()).createLocalTool((RedundantSuppressionDetector)suppressor, this.mySuppressedElements, activeTools);
                ProblemsHolder problemsHolder = new ProblemsHolder(iManager, this.getFile(), true);
                PsiElementVisitor visitor = localTool.buildVisitor(problemsHolder, true);
                InspectionEngine.acceptElements(inside, visitor);
                InspectionEngine.acceptElements(outside, visitor);
                HighlightSeverity severity = this.myProfileWrapper.getErrorLevel(key, (PsiElement)this.getFile()).getSeverity();
                for (ProblemDescriptor descriptor2 : problemsHolder.getResults()) {
                    ProgressManager.checkCanceled();
                    PsiElement element2 = descriptor2.getPsiElement();
                    if (element2 == null) continue;
                    Document thisDocument = this.documentManager.getDocument(this.getFile());
                    this.createHighlightsForDescriptor(this.myInfos, this.emptyActionRegistered, this.ilManager, this.getFile(), thisDocument, new LocalInspectionToolWrapper(localTool), severity, descriptor2, element2, false);
                }
            }
        }
    }

    @NotNull
    private List<InspectionContext> visitPriorityElementsAndInit(@NotNull List<? extends LocalInspectionToolWrapper> wrappers, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator, @NotNull List<? extends PsiElement> elements2, @NotNull LocalInspectionToolSession session2) {
        if (wrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(20);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(21);
        }
        if (indicator == null) {
            LocalInspectionsPass.$$$reportNull$$$0(22);
        }
        if (elements2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(23);
        }
        if (session2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(24);
        }
        ArrayList<InspectionContext> init2 = new ArrayList<InspectionContext>();
        PsiFile file2 = session2.getFile();
        Processor processor2 = toolWrapper -> (Boolean)AstLoadingFilter.disallowTreeLoading(() -> (Boolean)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file2, () -> {
            this.runToolOnElements((LocalInspectionToolWrapper)((Object)toolWrapper), iManager, isOnTheFly, indicator, elements2, session2, (List<? super InspectionContext>)init2);
            return true;
        }));
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(wrappers, indicator, processor2)) {
            throw new ProcessCanceledException();
        }
        ArrayList<InspectionContext> arrayList = init2;
        if (arrayList == null) {
            LocalInspectionsPass.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runToolOnElements(final @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull InspectionManager iManager, boolean isOnTheFly, final @NotNull ProgressIndicator indicator, @NotNull List<? extends PsiElement> elements2, @NotNull LocalInspectionToolSession session2, @NotNull List<? super InspectionContext> init2) {
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(26);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(27);
        }
        if (indicator == null) {
            LocalInspectionsPass.$$$reportNull$$$0(28);
        }
        if (elements2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(29);
        }
        if (session2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(30);
        }
        if (init2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(31);
        }
        ProgressManager.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LocalInspectionTool tool = (LocalInspectionTool)toolWrapper.getTool();
        final boolean[] applyIncrementally = new boolean[]{isOnTheFly};
        ProblemsHolder holder = new ProblemsHolder(iManager, this.getFile(), isOnTheFly){

            public void registerProblem(@NotNull ProblemDescriptor descriptor2) {
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.registerProblem(descriptor2);
                if (applyIncrementally[0]) {
                    LocalInspectionsPass.this.addDescriptorIncrementally(descriptor2, toolWrapper, indicator);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$1", "registerProblem"));
            }
        };
        PsiElementVisitor visitor = InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, session2, elements2);
        if (visitor != PsiElementVisitor.EMPTY_VISITOR) {
            List<? super InspectionContext> list2 = init2;
            synchronized (list2) {
                init2.add(new InspectionContext(toolWrapper, holder, holder.getResultCount(), visitor));
            }
        }
        this.advanceProgress(1L);
        if (holder.hasResults()) {
            this.appendDescriptors(this.getFile(), holder.getResults(), toolWrapper);
        }
        applyIncrementally[0] = false;
    }

    private void visitRestElementsAndCleanup(@NotNull ProgressIndicator indicator, @NotNull List<? extends PsiElement> elements2, @NotNull LocalInspectionToolSession session2, @NotNull List<? extends InspectionContext> init2) {
        if (indicator == null) {
            LocalInspectionsPass.$$$reportNull$$$0(32);
        }
        if (elements2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(33);
        }
        if (session2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(34);
        }
        if (init2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(35);
        }
        Processor processor2 = context -> {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().assertReadAccessAllowed();
            AstLoadingFilter.disallowTreeLoading(() -> InspectionEngine.acceptElements(elements2, context.visitor));
            this.advanceProgress(1L);
            ((LocalInspectionTool)context.tool.getTool()).inspectionFinished(session2, context.holder);
            if (context.holder.hasResults()) {
                List allProblems = context.holder.getResults();
                List restProblems = allProblems.subList(context.problemsSize, allProblems.size());
                this.appendDescriptors(this.getFile(), restProblems, context.tool);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(init2, indicator, processor2)) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private Set<PsiFile> inspectInjectedPsi(@NotNull List<? extends PsiElement> elements2, boolean onTheFly, @NotNull ProgressIndicator indicator, @NotNull InspectionManager iManager, boolean inVisibleRange, @NotNull List<? extends LocalInspectionToolWrapper> wrappers, @NotNull Set<? extends PsiFile> alreadyVisitedInjected) {
        if (elements2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(36);
        }
        if (indicator == null) {
            LocalInspectionsPass.$$$reportNull$$$0(37);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(38);
        }
        if (wrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(39);
        }
        if (alreadyVisitedInjected == null) {
            LocalInspectionsPass.$$$reportNull$$$0(40);
        }
        if (!this.myInspectInjectedPsi) {
            Set<PsiFile> set2 = Collections.emptySet();
            if (set2 == null) {
                LocalInspectionsPass.$$$reportNull$$$0(41);
            }
            return set2;
        }
        THashSet injected = new THashSet();
        for (PsiElement psiElement : elements2) {
            PsiFile containingFile = this.getFile();
            InjectedLanguageManager.getInstance((Project)containingFile.getProject()).enumerateEx(psiElement, containingFile, false, (arg_0, arg_1) -> LocalInspectionsPass.lambda$inspectInjectedPsi$8((Set)injected, arg_0, arg_1));
        }
        injected.removeAll(alreadyVisitedInjected);
        if (!injected.isEmpty()) {
            Processor processor2 = injectedPsi -> {
                this.doInspectInjectedPsi((PsiFile)injectedPsi, onTheFly, indicator, iManager, inVisibleRange, wrappers);
                return true;
            };
            if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(injected), indicator, processor2)) {
                throw new ProcessCanceledException();
            }
        }
        THashSet tHashSet = injected;
        if (tHashSet == null) {
            LocalInspectionsPass.$$$reportNull$$$0(42);
        }
        return tHashSet;
    }

    @Nullable
    private HighlightInfo highlightInfoFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightInfoType highlightInfoType, @NotNull @NlsContexts.DetailedDescription String message, @Nullable @NlsContexts.Tooltip String toolTip, @NotNull PsiElement psiElement, @NotNull List<IntentionAction> quickFixes, @NotNull String toolID) {
        TextRange textRange;
        if (problemDescriptor == null) {
            LocalInspectionsPass.$$$reportNull$$$0(43);
        }
        if (highlightInfoType == null) {
            LocalInspectionsPass.$$$reportNull$$$0(44);
        }
        if (message == null) {
            LocalInspectionsPass.$$$reportNull$$$0(45);
        }
        if (psiElement == null) {
            LocalInspectionsPass.$$$reportNull$$$0(46);
        }
        if (quickFixes == null) {
            LocalInspectionsPass.$$$reportNull$$$0(47);
        }
        if (toolID == null) {
            LocalInspectionsPass.$$$reportNull$$$0(48);
        }
        if ((textRange = ((ProblemDescriptorBase)problemDescriptor).getTextRange()) == null) {
            return null;
        }
        boolean isFileLevel = psiElement instanceof PsiFile && textRange.equals((Object)psiElement.getTextRange());
        HighlightSeverity severity = highlightInfoType.getSeverity(psiElement);
        TextAttributesKey attributesKey = ((ProblemDescriptorBase)problemDescriptor).getEnforcedTextAttributes();
        TextAttributes attributes = attributesKey == null || this.getColorsScheme() == null ? this.mySeverityRegistrar.getTextAttributesBySeverity(severity) : this.getColorsScheme().getAttributes(attributesKey);
        HighlightInfo.Builder b = HighlightInfo.newHighlightInfo(highlightInfoType).range(psiElement, textRange.getStartOffset(), textRange.getEndOffset()).description(message).severity(severity).inspectionToolId(toolID);
        if (toolTip != null) {
            b.escapedToolTip(toolTip);
        }
        if (HighlightSeverity.INFORMATION.equals((Object)severity) && attributes == null && toolTip == null && !quickFixes.isEmpty()) {
            attributes = NONEMPTY_TEXT_ATTRIBUTES;
        }
        if (attributes != null) {
            b.textAttributes(attributes);
        }
        if (problemDescriptor.isAfterEndOfLine()) {
            b.endOfLine();
        }
        if (isFileLevel) {
            b.fileLevelAnnotation();
        }
        if (problemDescriptor.getProblemGroup() != null) {
            b.problemGroup(problemDescriptor.getProblemGroup());
        }
        return b.create();
    }

    private void addDescriptorIncrementally(@NotNull ProblemDescriptor descriptor2, @NotNull LocalInspectionToolWrapper tool, @NotNull ProgressIndicator indicator) {
        if (descriptor2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(49);
        }
        if (tool == null) {
            LocalInspectionsPass.$$$reportNull$$$0(50);
        }
        if (indicator == null) {
            LocalInspectionsPass.$$$reportNull$$$0(51);
        }
        if (this.myIgnoreSuppressed) {
            LocalInspectionToolWrapper toolWrapper = tool;
            PsiElement psiElement = descriptor2.getPsiElement();
            if (descriptor2 instanceof ProblemDescriptorWithReporterName) {
                String reportingToolName = ((ProblemDescriptorWithReporterName)descriptor2).getReportingToolName();
                toolWrapper = (LocalInspectionToolWrapper)this.myProfileWrapper.getInspectionTool(reportingToolName, psiElement);
            }
            if (((LocalInspectionTool)toolWrapper.getTool()).isSuppressedFor(psiElement)) {
                this.registerSuppressedElements(psiElement, toolWrapper.getID(), toolWrapper.getAlternativeID());
                return;
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            PsiElement psiElement = descriptor2.getPsiElement();
            if (psiElement == null) {
                return;
            }
            PsiFile file2 = psiElement.getContainingFile();
            Document thisDocument = this.documentManager.getDocument(file2);
            HighlightSeverity severity = this.myProfileWrapper.getErrorLevel(tool.getDisplayKey(), (PsiElement)file2).getSeverity();
            this.infos.clear();
            this.createHighlightsForDescriptor(this.infos, this.emptyActionRegistered, this.ilManager, file2, thisDocument, tool, severity, descriptor2, psiElement);
            for (HighlightInfo info : this.infos) {
                EditorColorsScheme colorsScheme = this.getColorsScheme();
                UpdateHighlightersUtil.addHighlighterToEditorIncrementally(this.myProject, this.myDocument, this.getFile(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), info, colorsScheme, this.getId(), this.ranges2markersCache);
            }
        }, __ -> this.myProject.isDisposed() || indicator.isCanceled());
    }

    private void appendDescriptors(@NotNull PsiFile file2, @NotNull List<? extends ProblemDescriptor> descriptors2, @NotNull LocalInspectionToolWrapper tool) {
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(52);
        }
        if (descriptors2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(53);
        }
        if (tool == null) {
            LocalInspectionsPass.$$$reportNull$$$0(54);
        }
        for (ProblemDescriptor problemDescriptor : descriptors2) {
            if (problemDescriptor != null) continue;
            LOG.error("null descriptor. all descriptors(" + descriptors2.size() + "): " + descriptors2 + "; file: " + file2 + " (" + file2.getVirtualFile() + "); tool: " + tool);
        }
        InspectionResult result2 = new InspectionResult(tool, descriptors2);
        this.appendResult(file2, result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendResult(@NotNull PsiFile file2, @NotNull InspectionResult result2) {
        List resultList;
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(55);
        }
        if (result2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(56);
        }
        if ((resultList = (List)this.result.get(file2)) == null) {
            resultList = (List)ConcurrencyUtil.cacheOrGet(this.result, (Object)file2, new ArrayList());
        }
        List list2 = resultList;
        synchronized (list2) {
            resultList.add(result2);
        }
    }

    @Override
    protected void applyInformationWithProgress() {
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), this.myInfos, this.getColorsScheme(), this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHighlightsFromResults(@NotNull List<? super HighlightInfo> outInfos) {
        if (outInfos == null) {
            LocalInspectionsPass.$$$reportNull$$$0(57);
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        InjectedLanguageManager ilManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        THashSet emptyActionRegistered = new THashSet();
        for (Map.Entry entry : this.result.entrySet()) {
            List resultList;
            ProgressManager.checkCanceled();
            PsiFile file2 = (PsiFile)entry.getKey();
            Document documentRange = documentManager.getDocument(file2);
            if (documentRange == null) continue;
            List list2 = resultList = (List)entry.getValue();
            synchronized (list2) {
                for (InspectionResult inspectionResult : resultList) {
                    ProgressManager.checkCanceled();
                    LocalInspectionToolWrapper tool = inspectionResult.tool;
                    HighlightSeverity severity = this.myProfileWrapper.getErrorLevel(tool.getDisplayKey(), (PsiElement)file2).getSeverity();
                    for (ProblemDescriptor problemDescriptor : inspectionResult.foundProblems) {
                        ProgressManager.checkCanceled();
                        PsiElement element2 = problemDescriptor.getPsiElement();
                        if (element2 == null) continue;
                        this.createHighlightsForDescriptor(outInfos, (Set<? super Pair<TextRange, String>>)emptyActionRegistered, ilManager, file2, documentRange, tool, severity, problemDescriptor, element2, this.myIgnoreSuppressed);
                    }
                }
            }
        }
    }

    private void createHighlightsForDescriptor(@NotNull List<? super HighlightInfo> outInfos, @NotNull Set<? super Pair<TextRange, String>> emptyActionRegistered, @NotNull InjectedLanguageManager ilManager, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull HighlightSeverity severity, @NotNull ProblemDescriptor descriptor2, @NotNull PsiElement element2, boolean ignoreSuppressed) {
        if (outInfos == null) {
            LocalInspectionsPass.$$$reportNull$$$0(58);
        }
        if (emptyActionRegistered == null) {
            LocalInspectionsPass.$$$reportNull$$$0(59);
        }
        if (ilManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(60);
        }
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(61);
        }
        if (documentRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(62);
        }
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(63);
        }
        if (severity == null) {
            LocalInspectionsPass.$$$reportNull$$$0(64);
        }
        if (descriptor2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(65);
        }
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(66);
        }
        if (descriptor2 instanceof ProblemDescriptorWithReporterName) {
            String reportingToolName = ((ProblemDescriptorWithReporterName)descriptor2).getReportingToolName();
            InspectionToolWrapper<?, ?> reportingTool = this.myProfileWrapper.getInspectionTool(reportingToolName, element2);
            LOG.assertTrue(reportingTool instanceof LocalInspectionToolWrapper, (Object)reportingToolName);
            toolWrapper = (LocalInspectionToolWrapper)reportingTool;
            severity = this.myProfileWrapper.getErrorLevel(HighlightDisplayKey.find((String)reportingToolName), (PsiElement)file2).getSeverity();
        }
        LocalInspectionTool tool = (LocalInspectionTool)toolWrapper.getTool();
        if (ignoreSuppressed && tool.isSuppressedFor(element2)) {
            this.registerSuppressedElements(element2, toolWrapper.getID(), toolWrapper.getAlternativeID());
            return;
        }
        this.createHighlightsForDescriptor(outInfos, emptyActionRegistered, ilManager, file2, documentRange, toolWrapper, severity, descriptor2, element2);
    }

    private void createHighlightsForDescriptor(@NotNull List<? super HighlightInfo> outInfos, @NotNull Set<? super Pair<TextRange, String>> emptyActionRegistered, @NotNull InjectedLanguageManager ilManager, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull HighlightSeverity severity, @NotNull ProblemDescriptor descriptor2, @NotNull PsiElement element2) {
        boolean isOutsideInjected;
        List<IntentionAction> fixes;
        HighlightInfo info;
        if (outInfos == null) {
            LocalInspectionsPass.$$$reportNull$$$0(67);
        }
        if (emptyActionRegistered == null) {
            LocalInspectionsPass.$$$reportNull$$$0(68);
        }
        if (ilManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(69);
        }
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(70);
        }
        if (documentRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(71);
        }
        if (toolWrapper == null) {
            LocalInspectionsPass.$$$reportNull$$$0(72);
        }
        if (severity == null) {
            LocalInspectionsPass.$$$reportNull$$$0(73);
        }
        if (descriptor2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(74);
        }
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(75);
        }
        HighlightInfoType level = ProblemDescriptorUtil.highlightTypeFromDescriptor(descriptor2, severity, this.mySeverityRegistrar);
        @NlsSafe String message = ProblemDescriptorUtil.renderDescriptionMessage((CommonProblemDescriptor)descriptor2, element2);
        ProblemGroup problemGroup = descriptor2.getProblemGroup();
        String problemName = problemGroup != null ? problemGroup.getProblemName() : null;
        String shortName = problemName != null ? problemName : toolWrapper.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        InspectionProfile inspectionProfile = this.myProfileWrapper.getInspectionProfile();
        if (!inspectionProfile.isToolEnabled(key, (PsiElement)this.getFile())) {
            return;
        }
        InspectionHighlightInfoType type = new InspectionHighlightInfoType(level, element2);
        String plainMessage = message.startsWith("<html>") ? StringUtil.unescapeXmlEntities((String)XmlStringUtil.stripHtml((String)message).replaceAll("<[^>]*>", "")) : message;
        String tooltip = null;
        if (descriptor2.showTooltip()) {
            tooltip = (String)tooltips.intern((Object)DaemonTooltipsUtil.getWrappedTooltip((String)message, (String)shortName, (String)this.myShortcutText, (boolean)LocalInspectionsPass.showToolDescription(toolWrapper)));
        }
        if ((info = this.highlightInfoFromDescriptor(descriptor2, type, plainMessage, tooltip, element2, fixes = LocalInspectionsPass.getQuickFixes(key, descriptor2, emptyActionRegistered), key.getID())) == null) {
            return;
        }
        LocalInspectionsPass.registerQuickFixes(info, fixes, shortName);
        PsiFile context = this.getTopLevelFileInBaseLanguage(element2);
        PsiFile myContext = this.getTopLevelFileInBaseLanguage((PsiElement)this.getFile());
        if (context != this.getFile()) {
            String errorMessage = "Reported element " + element2 + " is not from the file '" + file2.getVirtualFile().getPath() + "' the inspection '" + shortName + "' (" + ((LocalInspectionTool)toolWrapper.getTool()).getClass() + ") was invoked for. Message: '" + descriptor2 + "'.\nElement containing file: " + context + "\nInspection invoked for file: " + myContext + "\n";
            PluginException.logPluginError((Logger)LOG, (String)errorMessage, null, ((LocalInspectionTool)toolWrapper.getTool()).getClass());
        }
        boolean bl = isOutsideInjected = !this.myInspectInjectedPsi || file2 == this.getFile();
        if (isOutsideInjected) {
            outInfos.add(info);
            return;
        }
        LocalInspectionsPass.injectToHost(outInfos, ilManager, file2, documentRange, element2, fixes, info, shortName);
    }

    private void registerSuppressedElements(@NotNull PsiElement element2, String id2, String alternativeID) {
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(76);
        }
        this.mySuppressedElements.computeIfAbsent(id2, shortName -> new HashSet()).add(element2);
        if (alternativeID != null) {
            this.mySuppressedElements.computeIfAbsent(alternativeID, shortName -> new HashSet()).add(element2);
        }
    }

    private static void injectToHost(@NotNull List<? super HighlightInfo> outInfos, @NotNull InjectedLanguageManager ilManager, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull PsiElement element2, @NotNull List<? extends IntentionAction> fixes, @NotNull HighlightInfo info, String shortName) {
        if (outInfos == null) {
            LocalInspectionsPass.$$$reportNull$$$0(77);
        }
        if (ilManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(78);
        }
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(79);
        }
        if (documentRange == null) {
            LocalInspectionsPass.$$$reportNull$$$0(80);
        }
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(81);
        }
        if (fixes == null) {
            LocalInspectionsPass.$$$reportNull$$$0(82);
        }
        if (info == null) {
            LocalInspectionsPass.$$$reportNull$$$0(83);
        }
        List editables = ilManager.intersectWithAllEditableFragments(file2, new TextRange(info.startOffset, info.endOffset));
        for (TextRange editable : editables) {
            String toolTip;
            TextRange hostRange = ((DocumentWindow)documentRange).injectedToHost(editable);
            int start2 = hostRange.getStartOffset();
            int end = hostRange.getEndOffset();
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(info.type).range(element2, start2, end);
            String description = info.getDescription();
            if (description != null) {
                builder2.description(description);
            }
            if ((toolTip = info.getToolTip()) != null) {
                builder2.escapedToolTip(toolTip);
            }
            HighlightInfo patched = builder2.createUnconditionally();
            if (patched.startOffset == patched.endOffset && info.startOffset != info.endOffset) continue;
            patched.setFromInjection(true);
            LocalInspectionsPass.registerQuickFixes(patched, fixes, shortName);
            outInfos.add(patched);
        }
    }

    private PsiFile getTopLevelFileInBaseLanguage(@NotNull PsiElement element2) {
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(84);
        }
        PsiFile file2 = InjectedLanguageManager.getInstance((Project)this.myProject).getTopLevelFile(element2);
        FileViewProvider viewProvider = file2.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    private static boolean showToolDescription(@NotNull LocalInspectionToolWrapper tool) {
        String staticDescription;
        if (tool == null) {
            LocalInspectionsPass.$$$reportNull$$$0(85);
        }
        return (staticDescription = tool.getStaticDescription()) == null || !staticDescription.isEmpty();
    }

    private static void registerQuickFixes(@NotNull HighlightInfo highlightInfo, @NotNull List<? extends IntentionAction> quickFixes, String shortName) {
        if (highlightInfo == null) {
            LocalInspectionsPass.$$$reportNull$$$0(86);
        }
        if (quickFixes == null) {
            LocalInspectionsPass.$$$reportNull$$$0(87);
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        for (IntentionAction intentionAction : quickFixes) {
            QuickFixAction.registerQuickFixAction(highlightInfo, intentionAction, key);
        }
    }

    @NotNull
    private static List<IntentionAction> getQuickFixes(@NotNull HighlightDisplayKey key, @NotNull ProblemDescriptor descriptor2, @NotNull Set<? super Pair<TextRange, String>> emptyActionRegistered) {
        HintAction hintAction;
        if (key == null) {
            LocalInspectionsPass.$$$reportNull$$$0(88);
        }
        if (descriptor2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(89);
        }
        if (emptyActionRegistered == null) {
            LocalInspectionsPass.$$$reportNull$$$0(90);
        }
        SmartList result2 = new SmartList();
        boolean needEmptyAction = true;
        Object[] fixes = descriptor2.getFixes();
        if (fixes != null && fixes.length != 0) {
            for (int k = 0; k < fixes.length; ++k) {
                QuickFix fix = fixes[k];
                if (fix == null) {
                    throw new IllegalStateException("Inspection " + key + " returns null quick fix in its descriptor: " + descriptor2 + "; array: " + Arrays.toString(fixes));
                }
                result2.add(QuickFixWrapper.wrap(descriptor2, k));
                needEmptyAction = false;
            }
        }
        HintAction hintAction2 = hintAction = descriptor2 instanceof ProblemDescriptorImpl ? ((ProblemDescriptorImpl)descriptor2).getHintAction() : null;
        if (hintAction != null) {
            result2.add(hintAction);
            needEmptyAction = false;
        }
        if (((ProblemDescriptorBase)descriptor2).getEnforcedTextAttributes() != null) {
            needEmptyAction = false;
        }
        if (needEmptyAction && emptyActionRegistered.add((Pair<TextRange, String>)Pair.create((Object)((ProblemDescriptorBase)descriptor2).getTextRange(), (Object)key.toString()))) {
            String displayNameByKey = HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)key);
            LOG.assertTrue(displayNameByKey != null, (Object)key.toString());
            EmptyIntentionAction emptyIntentionAction = new EmptyIntentionAction(displayNameByKey);
            result2.add(emptyIntentionAction);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            LocalInspectionsPass.$$$reportNull$$$0(91);
        }
        return smartList;
    }

    private static void getElementsAndDialectsFrom(@NotNull PsiFile file2, final @NotNull List<? super PsiElement> outElements, @NotNull Set<? super String> outDialects) {
        if (file2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(92);
        }
        if (outElements == null) {
            LocalInspectionsPass.$$$reportNull$$$0(93);
        }
        if (outDialects == null) {
            LocalInspectionsPass.$$$reportNull$$$0(94);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        SmartHashSet processedLanguages = new SmartHashSet();
        PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor((Set)processedLanguages, outDialects){
            final /* synthetic */ Set val$processedLanguages;
            final /* synthetic */ Set val$outDialects;
            {
                this.val$processedLanguages = set2;
                this.val$outDialects = set3;
            }

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                for (PsiElement child2 = element2.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
                    outElements.add(child2);
                    child2.accept((PsiElementVisitor)this);
                    LocalInspectionsPass.appendDialects(child2, this.val$processedLanguages, this.val$outDialects);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$3", "visitElement"));
            }
        };
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (psiRoot == null || !HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)psiRoot)) continue;
            outElements.add((PsiElement)psiRoot);
            psiRoot.accept((PsiElementVisitor)visitor);
            LocalInspectionsPass.appendDialects((PsiElement)psiRoot, (Set<? super Language>)processedLanguages, outDialects);
        }
    }

    private static void appendDialects(@NotNull PsiElement element2, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        if (element2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(95);
        }
        if (outProcessedLanguages == null) {
            LocalInspectionsPass.$$$reportNull$$$0(96);
        }
        if (outDialectIds == null) {
            LocalInspectionsPass.$$$reportNull$$$0(97);
        }
        Language language = element2.getLanguage();
        outDialectIds.add(language.getID());
        if (outProcessedLanguages.add((Language)language)) {
            for (Language dialect : language.getDialects()) {
                outDialectIds.add(dialect.getID());
            }
        }
    }

    @NotNull
    List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile) {
        if (profile == null) {
            LocalInspectionsPass.$$$reportNull$$$0(98);
        }
        List toolWrappers = profile.getInspectionProfile().getInspectionTools((PsiElement)this.getFile());
        InspectionProfileWrapper.checkInspectionsDuplicates(toolWrappers);
        ArrayList<LocalInspectionToolWrapper> enabled = new ArrayList<LocalInspectionToolWrapper>();
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            LocalInspectionToolWrapper wrapper2;
            HighlightDisplayKey key;
            ProgressManager.checkCanceled();
            if (toolWrapper instanceof LocalInspectionToolWrapper && !this.isAcceptableLocalTool((LocalInspectionToolWrapper)toolWrapper) || !profile.isToolEnabled(key = toolWrapper.getDisplayKey(), (PsiElement)this.getFile()) || HighlightDisplayLevel.DO_NOT_SHOW.equals(profile.getErrorLevel(key, (PsiElement)this.getFile()))) continue;
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                wrapper2 = (LocalInspectionToolWrapper)toolWrapper;
            } else {
                wrapper2 = ((GlobalInspectionToolWrapper)toolWrapper).getSharedLocalInspectionToolWrapper();
                if (wrapper2 == null || !this.isAcceptableLocalTool(wrapper2)) continue;
            }
            String language = wrapper2.getLanguage();
            if (language != null && Language.findLanguageByID((String)language) == null || this.myIgnoreSuppressed && ((LocalInspectionTool)wrapper2.getTool()).isSuppressedFor((PsiElement)this.getFile())) continue;
            enabled.add(wrapper2);
        }
        ArrayList<LocalInspectionToolWrapper> arrayList = enabled;
        if (arrayList == null) {
            LocalInspectionsPass.$$$reportNull$$$0(99);
        }
        return arrayList;
    }

    protected boolean isAcceptableLocalTool(@NotNull LocalInspectionToolWrapper wrapper2) {
        if (wrapper2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(100);
        }
        return true;
    }

    private void doInspectInjectedPsi(@NotNull PsiFile injectedPsi, boolean isOnTheFly, @NotNull ProgressIndicator indicator, @NotNull InspectionManager iManager, boolean inVisibleRange, @NotNull List<? extends LocalInspectionToolWrapper> wrappers) {
        if (injectedPsi == null) {
            LocalInspectionsPass.$$$reportNull$$$0(101);
        }
        if (indicator == null) {
            LocalInspectionsPass.$$$reportNull$$$0(102);
        }
        if (iManager == null) {
            LocalInspectionsPass.$$$reportNull$$$0(103);
        }
        if (wrappers == null) {
            LocalInspectionsPass.$$$reportNull$$$0(104);
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)injectedPsi.getProject()).getInjectionHost((PsiElement)injectedPsi);
        ArrayList elements2 = new ArrayList();
        SmartHashSet elementDialectIds = new SmartHashSet();
        LocalInspectionsPass.getElementsAndDialectsFrom(injectedPsi, elements2, (Set<? super String>)elementDialectIds);
        if (elements2.isEmpty()) {
            return;
        }
        List<LocalInspectionToolWrapper> applicableTools = InspectionEngine.filterToolsApplicableByLanguage(wrappers, (Set<String>)elementDialectIds);
        for (LocalInspectionToolWrapper wrapper2 : applicableTools) {
            ProgressManager.checkCanceled();
            LocalInspectionTool tool = (LocalInspectionTool)wrapper2.getTool();
            ProblemsHolder holder = new ProblemsHolder(iManager, injectedPsi, isOnTheFly, (PsiElement)host, tool, wrapper2, isOnTheFly, inVisibleRange, indicator){
                final /* synthetic */ PsiElement val$host;
                final /* synthetic */ LocalInspectionTool val$tool;
                final /* synthetic */ LocalInspectionToolWrapper val$wrapper;
                final /* synthetic */ boolean val$isOnTheFly;
                final /* synthetic */ boolean val$inVisibleRange;
                final /* synthetic */ ProgressIndicator val$indicator;
                {
                    this.val$host = psiElement;
                    this.val$tool = localInspectionTool;
                    this.val$wrapper = localInspectionToolWrapper;
                    this.val$isOnTheFly = bl;
                    this.val$inVisibleRange = bl2;
                    this.val$indicator = progressIndicator;
                    super(arg0, arg1, arg2);
                }

                public void registerProblem(@NotNull ProblemDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (this.val$host != null && LocalInspectionsPass.this.myIgnoreSuppressed && this.val$tool.isSuppressedFor(this.val$host)) {
                        LocalInspectionsPass.this.registerSuppressedElements(this.val$host, this.val$wrapper.getID(), this.val$wrapper.getAlternativeID());
                        return;
                    }
                    super.registerProblem(descriptor2);
                    if (this.val$isOnTheFly && this.val$inVisibleRange) {
                        LocalInspectionsPass.this.addDescriptorIncrementally(descriptor2, this.val$wrapper, this.val$indicator);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$4", "registerProblem"));
                }
            };
            LocalInspectionToolSession injSession = new LocalInspectionToolSession(injectedPsi, 0, injectedPsi.getTextLength());
            InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, injSession, elements2);
            tool.inspectionFinished(injSession, holder);
            List problems = holder.getResults();
            if (problems.isEmpty()) continue;
            this.appendDescriptors(injectedPsi, problems, wrapper2);
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        List<HighlightInfo> list2 = this.myInfos;
        if (list2 == null) {
            LocalInspectionsPass.$$$reportNull$$$0(105);
        }
        return list2;
    }

    @Nls
    private static String getPresentableNameText() {
        return DaemonBundle.message((String)"pass.inspection", (Object[])new Object[0]);
    }

    private static /* synthetic */ void lambda$inspectInjectedPsi$8(Set injected, PsiFile injectedPsi, List places) {
        injected.add(injectedPsi);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 25: 
            case 41: 
            case 42: 
            case 91: 
            case 99: 
            case 105: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 25: 
            case 41: 
            case 42: 
            case 91: 
            case 99: 
            case 105: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
            case 4: 
            case 25: 
            case 41: 
            case 42: 
            case 91: 
            case 99: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 21: 
            case 27: 
            case 38: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iManager";
                break;
            }
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 9: 
            case 26: 
            case 63: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 10: 
            case 49: 
            case 65: 
            case 74: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
            case 20: 
            case 39: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappers";
                break;
            }
            case 22: 
            case 28: 
            case 32: 
            case 37: 
            case 51: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 23: 
            case 29: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 24: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "init";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyVisitedInjected";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoType";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 47: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolID";
                break;
            }
            case 50: 
            case 54: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 57: 
            case 58: 
            case 67: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outInfos";
                break;
            }
            case 59: 
            case 68: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyActionRegistered";
                break;
            }
            case 60: 
            case 69: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ilManager";
                break;
            }
            case 62: 
            case 71: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentRange";
                break;
            }
            case 64: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 66: 
            case 75: 
            case 76: 
            case 81: 
            case 84: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outElements";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDialects";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outProcessedLanguages";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDialectIds";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "visitPriorityElementsAndInit";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectInjectedPsi";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionTools";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 25: 
            case 41: 
            case 42: 
            case 91: 
            case 99: 
            case 105: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doInspectInBatch";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptors";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptorsFromInjectedResults";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "inspect";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "highlightRedundantSuppressions";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitPriorityElementsAndInit";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "runToolOnElements";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitRestElementsAndCleanup";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "inspectInjectedPsi";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "highlightInfoFromDescriptor";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptorIncrementally";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "appendDescriptors";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "appendResult";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "addHighlightsFromResults";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightsForDescriptor";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "registerSuppressedElements";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "injectToHost";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFileInBaseLanguage";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "showToolDescription";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "registerQuickFixes";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getElementsAndDialectsFrom";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "appendDialects";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionTools";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableLocalTool";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "doInspectInjectedPsi";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 25: 
            case 41: 
            case 42: 
            case 91: 
            case 99: 
            case 105: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InspectionHighlightInfoType
    extends HighlightInfoType.HighlightInfoTypeImpl {
        InspectionHighlightInfoType(@NotNull HighlightInfoType level, @NotNull PsiElement element2) {
            if (level == null) {
                InspectionHighlightInfoType.$$$reportNull$$$0(0);
            }
            if (element2 == null) {
                InspectionHighlightInfoType.$$$reportNull$$$0(1);
            }
            super(level.getSeverity(element2), level.getAttributesKey());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "level";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionHighlightInfoType";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class InspectionContext {
        @NotNull
        private final LocalInspectionToolWrapper tool;
        @NotNull
        private final ProblemsHolder holder;
        private final int problemsSize;
        @NotNull
        private final PsiElementVisitor visitor;

        private InspectionContext(@NotNull LocalInspectionToolWrapper tool, @NotNull ProblemsHolder holder, int problemsSize, @NotNull PsiElementVisitor visitor) {
            if (tool == null) {
                InspectionContext.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                InspectionContext.$$$reportNull$$$0(1);
            }
            if (visitor == null) {
                InspectionContext.$$$reportNull$$$0(2);
            }
            this.tool = tool;
            this.holder = holder;
            this.problemsSize = problemsSize;
            this.visitor = visitor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tool";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "visitor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class InspectionResult {
        @NotNull
        private final LocalInspectionToolWrapper tool;
        @NotNull
        private final List<? extends ProblemDescriptor> foundProblems;

        private InspectionResult(@NotNull LocalInspectionToolWrapper tool, @NotNull List<? extends ProblemDescriptor> foundProblems) {
            if (tool == null) {
                InspectionResult.$$$reportNull$$$0(0);
            }
            if (foundProblems == null) {
                InspectionResult.$$$reportNull$$$0(1);
            }
            this.tool = tool;
            this.foundProblems = new ArrayList<ProblemDescriptor>(foundProblems);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tool";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "foundProblems";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$InspectionResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

