/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.issue.quickfix;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0007\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/build/issue/quickfix/OpenFileQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "path", "Ljava/nio/file/Path;", "search", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Companion", "intellij.platform.lang.impl"})
@ApiStatus.Experimental
public final class OpenFileQuickFix
implements BuildIssueQuickFix {
    private final Path path;
    private final String search;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getId() {
        return ((Object)this.path).toString();
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataProvider dataProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        CompletableFuture future2 = new CompletableFuture();
        ApplicationManager.getApplication().invokeLater(new Runnable(this, project, future2){
            final /* synthetic */ OpenFileQuickFix this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ CompletableFuture $future;

            public final void run() {
                try {
                    OpenFileQuickFix.Companion.showFile(this.$project, OpenFileQuickFix.access$getPath$p(this.this$0), OpenFileQuickFix.access$getSearch$p(this.this$0));
                    this.$future.complete(null);
                }
                catch (Exception e) {
                    this.$future.completeExceptionally(e);
                }
            }
            {
                this.this$0 = openFileQuickFix;
                this.$project = project;
                this.$future = completableFuture;
            }
        });
        return future2;
    }

    public OpenFileQuickFix(@NotNull Path path, @Nullable String search2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.search = search2;
    }

    public static final /* synthetic */ Path access$getPath$p(OpenFileQuickFix $this) {
        return $this.path;
    }

    public static final /* synthetic */ String access$getSearch$p(OpenFileQuickFix $this) {
        return $this.search;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/build/issue/quickfix/OpenFileQuickFix$Companion;", "", "()V", "showFile", "", "project", "Lcom/intellij/openapi/project/Project;", "path", "Ljava/nio/file/Path;", "search", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        public final void showFile(@NotNull Project project, @NotNull Path path, @Nullable String search2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            ApplicationManager.getApplication().invokeLater(new Runnable(path, project, search2){
                final /* synthetic */ Path $path;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $search;

                public final void run() {
                    VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)this.$path.toFile(), (boolean)false);
                    if (virtualFile == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"VfsUtil.findFileByIoFile\u2026se) ?: return@invokeLater");
                    VirtualFile file2 = virtualFile;
                    Editor editor = FileEditorManager.getInstance((Project)this.$project).openTextEditor(new OpenFileDescriptor(this.$project, file2), false);
                    if (this.$search == null || editor == null) {
                        return;
                    }
                    FindModel findModel = new FindModel();
                    boolean bl = false;
                    boolean bl2 = false;
                    FindModel $this$apply = findModel;
                    boolean bl3 = false;
                    FindModel.initStringToFind((FindModel)$this$apply, (String)this.$search);
                    FindModel findModel2 = findModel;
                    FindManager findManager = FindManager.getInstance((Project)this.$project);
                    Document document = editor.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                    FindResult findResult = findManager.findString(document.getCharsSequence(), 0, findModel2, file2);
                    Intrinsics.checkNotNullExpressionValue((Object)findResult, (String)"FindManager.getInstance(\u2026ence, 0, findModel, file)");
                    FindResult findResult2 = findResult;
                    HighlightManager highlightManager = HighlightManager.getInstance((Project)this.$project);
                    HighlightUsagesHandler.highlightRanges(highlightManager, editor, EditorColors.SEARCH_RESULT_ATTRIBUTES, false, (List<? extends TextRange>)CollectionsKt.listOf((Object)findResult2));
                }
                {
                    this.$path = path;
                    this.$project = project;
                    this.$search = string;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

