/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.netbeans.lib.ddl.CreateTriggerCommand;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.TriggerEvent;
import org.openide.util.NbBundle;

public class CreateTrigger
extends AbstractCommand
implements CreateTriggerCommand {
    public static final int BEFORE = 1;
    public static final int AFTER = 2;
    private Vector events = new Vector();
    boolean eachrow;
    private String cond;
    private String table;
    int timing;
    private String body;
    static final long serialVersionUID = -2217362040968396712L;

    public static String getTimingName(int code) {
        switch (code) {
            case 1: {
                return "BEFORE";
            }
            case 2: {
                return "AFTER";
            }
        }
        return null;
    }

    @Override
    public String getTableName() {
        return this.table;
    }

    @Override
    public void setTableName(String tab) {
        this.table = tab;
    }

    public boolean getForEachRow() {
        return this.eachrow;
    }

    public void setForEachRow(boolean flag) {
        this.eachrow = flag;
    }

    public String getText() {
        return this.body;
    }

    public void setText(String text) {
        this.body = text;
    }

    public String getCondition() {
        return this.cond;
    }

    public void setCondition(String con) {
        this.cond = con;
    }

    public int getTiming() {
        return this.timing;
    }

    public void setTiming(int time) {
        this.timing = time;
    }

    public Vector getEvents() {
        return this.events;
    }

    public TriggerEvent getEvent(int index) {
        return (TriggerEvent)this.events.get(index);
    }

    public void setEvents(Vector argarr) {
        this.events = argarr;
    }

    public void setEvent(int index, TriggerEvent arg) {
        this.events.set(index, arg);
    }

    public TriggerEvent createTriggerEvent(int when, String columnname) throws DDLException {
        try {
            Map gprops = this.getSpecification().getProperties();
            Map props = this.getSpecification().getCommandProperties("CreateTriggerCommand");
            Map bindmap = (Map)props.get("Binding");
            String tname = (String)bindmap.get("EVENT");
            if (tname != null) {
                Map typemap = (Map)gprops.get(tname);
                if (typemap == null) {
                    throw new InstantiationException(MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_UnableLocateObject"), tname));
                }
                Class<?> typeclass = Class.forName((String)typemap.get("Class"));
                String format = (String)typemap.get("Format");
                TriggerEvent evt = (TriggerEvent)typeclass.newInstance();
                Map temap = (Map)props.get("TriggerEventMap");
                evt.setName(TriggerEvent.getName(when));
                evt.setColumn(columnname);
                evt.setFormat(format);
                return evt;
            }
            throw new InstantiationException(MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_UnableLocateType"), "EVENT", bindmap.toString()));
        }
        catch (Exception e) {
            throw new DDLException(e.getMessage());
        }
    }

    public void addTriggerEvent(int when) throws DDLException {
        this.addTriggerEvent(when, null);
    }

    public void addTriggerEvent(int when, String columnname) throws DDLException {
        TriggerEvent te = this.createTriggerEvent(when, columnname);
        if (te != null) {
            this.events.add(te);
        }
    }

    @Override
    public Map getCommandProperties() throws DDLException {
        Map props = this.getSpecification().getProperties();
        String evs = "";
        String argdelim = (String)props.get("TriggerEventListDelimiter");
        Map cmdprops = super.getCommandProperties();
        Enumeration col_e = this.events.elements();
        while (col_e.hasMoreElements()) {
            TriggerEvent evt = (TriggerEvent)col_e.nextElement();
            boolean inscomma = col_e.hasMoreElements();
            evs = evs + evt.getCommand(this) + (inscomma ? argdelim : "");
        }
        cmdprops.put("trigger.events", evs);
        cmdprops.put("trigger.condition", this.cond);
        cmdprops.put("trigger.timing", CreateTrigger.getTimingName(this.timing));
        cmdprops.put("table.name", this.quote(this.table));
        cmdprops.put("trigger.body", this.body);
        if (this.eachrow) {
            cmdprops.put("each.row", "");
        }
        return cmdprops;
    }
}

