/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.typinghooks;

import java.util.Arrays;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.spi.editor.typinghooks.CamelCaseInterceptor;

public class HtmlCamelCaseInterceptor
implements CamelCaseInterceptor {
    public boolean beforeChange(CamelCaseInterceptor.MutableContext context) throws BadLocationException {
        return false;
    }

    public void change(CamelCaseInterceptor.MutableContext context) throws BadLocationException {
        context.setNextWordOffset(context.isBackward() ? HtmlCamelCaseInterceptor.getPreviousWordOffset(context.getComponent(), context.getOffset()) : HtmlCamelCaseInterceptor.getNextWordOffset(context.getComponent(), context.getOffset()));
    }

    public void afterChange(CamelCaseInterceptor.MutableContext context) throws BadLocationException {
    }

    public void cancelled(CamelCaseInterceptor.MutableContext context) {
    }

    private static int getNextWordOffset(JTextComponent target, int dotPos) throws BadLocationException {
        TokenHierarchy hi = TokenHierarchy.get((Document)target.getDocument());
        TokenSequence ts = hi.tokenSequence(HTMLTokenId.language());
        if (ts == null) {
            return -1;
        }
        int diff = ts.move(dotPos);
        if (!ts.moveNext()) {
            return -1;
        }
        Token token = ts.token();
        int offset = -1;
        switch ((HTMLTokenId)token.id()) {
            case ARGUMENT: {
                Token next = LexerUtils.followsToken((TokenSequence)ts, Arrays.asList(HTMLTokenId.VALUE, HTMLTokenId.VALUE_CSS, HTMLTokenId.VALUE_JAVASCRIPT), (boolean)false, (boolean)false, (TokenId[])new TokenId[]{HTMLTokenId.WS, HTMLTokenId.OPERATOR});
                if (next == null) break;
                offset = ts.offset();
                if (!WebUtils.isValueQuoted((CharSequence)ts.token().text())) break;
                ++offset;
                break;
            }
            case TAG_OPEN_SYMBOL: {
                Token next = LexerUtils.followsToken((TokenSequence)ts, Arrays.asList(HTMLTokenId.TAG_OPEN, HTMLTokenId.TAG_CLOSE), (boolean)false, (boolean)false, (TokenId[])new TokenId[0]);
                if (next == null) break;
                offset = ts.offset() + next.length();
                break;
            }
            case TAG_CLOSE_SYMBOL: {
                offset = ts.offset() + ts.token().length();
                break;
            }
            case VALUE: 
            case VALUE_CSS: 
            case VALUE_JAVASCRIPT: {
                char c = token.text().charAt(diff);
                if ((token.length() - 1 != diff || c != '\"') && c != '\'') break;
                offset = ts.offset() + token.length();
            }
        }
        return offset;
    }

    private static int getPreviousWordOffset(JTextComponent target, int dotPos) throws BadLocationException {
        TokenHierarchy hi = TokenHierarchy.get((Document)target.getDocument());
        TokenSequence ts = hi.tokenSequence(HTMLTokenId.language());
        if (ts == null) {
            return -1;
        }
        int diff = ts.move(dotPos);
        if (diff == 0 ? !ts.movePrevious() : !ts.moveNext()) {
            return -1;
        }
        Token token = ts.token();
        int offset = -1;
        switch ((HTMLTokenId)token.id()) {
            case VALUE: 
            case VALUE_CSS: 
            case VALUE_JAVASCRIPT: {
                Token prev;
                if (diff == 0) {
                    if (!WebUtils.isValueQuoted((CharSequence)ts.token().text())) break;
                    offset = ts.offset() + token.length() - 1;
                    break;
                }
                if (diff != 1 || !WebUtils.isValueQuoted((CharSequence)token.text()) || (prev = LexerUtils.followsToken((TokenSequence)ts, (TokenId)HTMLTokenId.ARGUMENT, (boolean)true, (boolean)false, (TokenId[])new TokenId[]{HTMLTokenId.WS, HTMLTokenId.OPERATOR})) == null) break;
                offset = ts.offset();
                break;
            }
            case TAG_OPEN: 
            case TAG_CLOSE: {
                Token prev = LexerUtils.followsToken((TokenSequence)ts, (TokenId)HTMLTokenId.TAG_OPEN_SYMBOL, (boolean)true, (boolean)false, (TokenId[])new TokenId[0]);
                if (prev == null) break;
                offset = ts.offset();
                break;
            }
            case TAG_CLOSE_SYMBOL: {
                offset = ts.offset();
            }
        }
        return offset;
    }

    public static final class Factory
    implements CamelCaseInterceptor.Factory {
        public CamelCaseInterceptor createCamelCaseInterceptor(MimePath mimePath) {
            return new HtmlCamelCaseInterceptor();
        }
    }
}

