/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.typed.SimpleValueEncoder;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.Base64Variants;
import org.codehaus.stax2.util.StreamWriterDelegate;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;

public class Stax2WriterAdapter
extends StreamWriterDelegate
implements XMLStreamWriter2,
XMLStreamConstants {
    protected String mEncoding;
    protected SimpleValueEncoder mValueEncoder;
    protected final boolean mNsRepairing;

    protected Stax2WriterAdapter(XMLStreamWriter xMLStreamWriter) {
        super(xMLStreamWriter);
        this.mDelegate = xMLStreamWriter;
        Object object = xMLStreamWriter.getProperty("javax.xml.stream.isRepairingNamespaces");
        this.mNsRepairing = object instanceof Boolean && (Boolean)object != false;
    }

    public static XMLStreamWriter2 wrapIfNecessary(XMLStreamWriter xMLStreamWriter) {
        if (xMLStreamWriter instanceof XMLStreamWriter2) {
            return (XMLStreamWriter2)xMLStreamWriter;
        }
        return new Stax2WriterAdapter(xMLStreamWriter);
    }

    @Override
    public void writeBoolean(boolean bl) throws XMLStreamException {
        this.mDelegate.writeCharacters(bl ? "true" : "false");
    }

    @Override
    public void writeInt(int n) throws XMLStreamException {
        this.mDelegate.writeCharacters(String.valueOf(n));
    }

    @Override
    public void writeLong(long l) throws XMLStreamException {
        this.mDelegate.writeCharacters(String.valueOf(l));
    }

    @Override
    public void writeFloat(float f) throws XMLStreamException {
        this.mDelegate.writeCharacters(String.valueOf(f));
    }

    @Override
    public void writeDouble(double d) throws XMLStreamException {
        this.mDelegate.writeCharacters(String.valueOf(d));
    }

    @Override
    public void writeInteger(BigInteger bigInteger) throws XMLStreamException {
        this.mDelegate.writeCharacters(bigInteger.toString());
    }

    @Override
    public void writeDecimal(BigDecimal bigDecimal) throws XMLStreamException {
        this.mDelegate.writeCharacters(bigDecimal.toString());
    }

    @Override
    public void writeQName(QName qName) throws XMLStreamException {
        this.mDelegate.writeCharacters(this.serializeQNameValue(qName));
    }

    @Override
    public void writeIntArray(int[] nArray, int n, int n2) throws XMLStreamException {
        this.mDelegate.writeCharacters(this.getValueEncoder().encodeAsString(nArray, n, n2));
    }

    @Override
    public void writeLongArray(long[] lArray, int n, int n2) throws XMLStreamException {
        this.mDelegate.writeCharacters(this.getValueEncoder().encodeAsString(lArray, n, n2));
    }

    @Override
    public void writeFloatArray(float[] fArray, int n, int n2) throws XMLStreamException {
        this.mDelegate.writeCharacters(this.getValueEncoder().encodeAsString(fArray, n, n2));
    }

    @Override
    public void writeDoubleArray(double[] dArray, int n, int n2) throws XMLStreamException {
        this.mDelegate.writeCharacters(this.getValueEncoder().encodeAsString(dArray, n, n2));
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws XMLStreamException {
        this.mDelegate.writeCharacters(this.getValueEncoder().encodeAsString(base64Variant, byArray, n, n2));
    }

    @Override
    public void writeBinary(byte[] byArray, int n, int n2) throws XMLStreamException {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, n, n2);
    }

    @Override
    public void writeBooleanAttribute(String string2, String string3, String string4, boolean bl) throws XMLStreamException {
        this.mDelegate.writeAttribute(string2, string3, string4, bl ? "true" : "false");
    }

    @Override
    public void writeIntAttribute(String string2, String string3, String string4, int n) throws XMLStreamException {
        this.mDelegate.writeAttribute(string2, string3, string4, String.valueOf(n));
    }

    @Override
    public void writeLongAttribute(String string2, String string3, String string4, long l) throws XMLStreamException {
        this.mDelegate.writeAttribute(string2, string3, string4, String.valueOf(l));
    }

    @Override
    public void writeFloatAttribute(String string2, String string3, String string4, float f) throws XMLStreamException {
        this.mDelegate.writeAttribute(string2, string3, string4, String.valueOf(f));
    }

    @Override
    public void writeDoubleAttribute(String string2, String string3, String string4, double d) throws XMLStreamException {
        this.mDelegate.writeAttribute(string2, string3, string4, String.valueOf(d));
    }

    @Override
    public void writeIntegerAttribute(String string2, String string3, String string4, BigInteger bigInteger) throws XMLStreamException {
        this.mDelegate.writeAttribute(string2, string3, string4, bigInteger.toString());
    }

    @Override
    public void writeDecimalAttribute(String string2, String string3, String string4, BigDecimal bigDecimal) throws XMLStreamException {
        this.mDelegate.writeAttribute(string2, string3, string4, bigDecimal.toString());
    }

    @Override
    public void writeQNameAttribute(String string2, String string3, String string4, QName qName) throws XMLStreamException {
        this.mDelegate.writeAttribute(string2, string3, string4, this.serializeQNameValue(qName));
    }

    @Override
    public void writeIntArrayAttribute(String string2, String string3, String string4, int[] nArray) throws XMLStreamException {
        this.mDelegate.writeAttribute(string2, string3, string4, this.getValueEncoder().encodeAsString(nArray, 0, nArray.length));
    }

    @Override
    public void writeLongArrayAttribute(String string2, String string3, String string4, long[] lArray) throws XMLStreamException {
        this.mDelegate.writeAttribute(string2, string3, string4, this.getValueEncoder().encodeAsString(lArray, 0, lArray.length));
    }

    @Override
    public void writeFloatArrayAttribute(String string2, String string3, String string4, float[] fArray) throws XMLStreamException {
        this.mDelegate.writeAttribute(string2, string3, string4, this.getValueEncoder().encodeAsString(fArray, 0, fArray.length));
    }

    @Override
    public void writeDoubleArrayAttribute(String string2, String string3, String string4, double[] dArray) throws XMLStreamException {
        this.mDelegate.writeAttribute(string2, string3, string4, this.getValueEncoder().encodeAsString(dArray, 0, dArray.length));
    }

    @Override
    public void writeBinaryAttribute(String string2, String string3, String string4, byte[] byArray) throws XMLStreamException {
        this.writeBinaryAttribute(Base64Variants.getDefaultVariant(), string2, string3, string4, byArray);
    }

    @Override
    public void writeBinaryAttribute(Base64Variant base64Variant, String string2, String string3, String string4, byte[] byArray) throws XMLStreamException {
        this.mDelegate.writeAttribute(string2, string3, string4, this.getValueEncoder().encodeAsString(base64Variant, byArray, 0, byArray.length));
    }

    @Override
    public boolean isPropertySupported(String string2) {
        return false;
    }

    @Override
    public boolean setProperty(String string2, Object object) {
        throw new IllegalArgumentException("No settable property '" + string2 + "'");
    }

    @Override
    public XMLStreamLocation2 getLocation() {
        return null;
    }

    @Override
    public String getEncoding() {
        return this.mEncoding;
    }

    @Override
    public void writeCData(char[] cArray, int n, int n2) throws XMLStreamException {
        this.writeCData(new String(cArray, n, n2));
    }

    @Override
    public void writeDTD(String string2, String string3, String string4, String string5) throws XMLStreamException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<!DOCTYPE");
        stringBuffer.append(string2);
        if (string3 != null) {
            if (string4 != null) {
                stringBuffer.append(" PUBLIC \"");
                stringBuffer.append(string4);
                stringBuffer.append("\" \"");
            } else {
                stringBuffer.append(" SYSTEM \"");
            }
            stringBuffer.append(string3);
            stringBuffer.append('\"');
        }
        if (string5 != null && string5.length() > 0) {
            stringBuffer.append(" [");
            stringBuffer.append(string5);
            stringBuffer.append(']');
        }
        stringBuffer.append('>');
        this.writeDTD(stringBuffer.toString());
    }

    @Override
    public void writeFullEndElement() throws XMLStreamException {
        this.mDelegate.writeCharacters("");
        this.mDelegate.writeEndElement();
    }

    @Override
    public void writeSpace(String string2) throws XMLStreamException {
        this.writeRaw(string2);
    }

    @Override
    public void writeSpace(char[] cArray, int n, int n2) throws XMLStreamException {
        this.writeRaw(cArray, n, n2);
    }

    @Override
    public void writeStartDocument(String string2, String string3, boolean bl) throws XMLStreamException {
        this.writeStartDocument(string3, string2);
    }

    @Override
    public void writeRaw(String string2) throws XMLStreamException {
        this.writeRaw(string2, 0, string2.length());
    }

    @Override
    public void writeRaw(String string2, int n, int n2) throws XMLStreamException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) throws XMLStreamException {
        this.writeRaw(new String(cArray, n, n2));
    }

    @Override
    public void copyEventFromReader(XMLStreamReader2 xMLStreamReader2, boolean bl) throws XMLStreamException {
        switch (xMLStreamReader2.getEventType()) {
            case 7: {
                String string2 = xMLStreamReader2.getVersion();
                if (string2 != null && string2.length() != 0) {
                    if (xMLStreamReader2.standaloneSet()) {
                        this.writeStartDocument(xMLStreamReader2.getVersion(), xMLStreamReader2.getCharacterEncodingScheme(), xMLStreamReader2.isStandalone());
                    } else {
                        this.writeStartDocument(xMLStreamReader2.getCharacterEncodingScheme(), xMLStreamReader2.getVersion());
                    }
                }
                return;
            }
            case 8: {
                this.writeEndDocument();
                return;
            }
            case 1: {
                this.copyStartElement(xMLStreamReader2);
                return;
            }
            case 2: {
                this.writeEndElement();
                return;
            }
            case 6: {
                this.writeSpace(xMLStreamReader2.getTextCharacters(), xMLStreamReader2.getTextStart(), xMLStreamReader2.getTextLength());
                return;
            }
            case 12: {
                this.writeCData(xMLStreamReader2.getTextCharacters(), xMLStreamReader2.getTextStart(), xMLStreamReader2.getTextLength());
                return;
            }
            case 4: {
                this.writeCharacters(xMLStreamReader2.getTextCharacters(), xMLStreamReader2.getTextStart(), xMLStreamReader2.getTextLength());
                return;
            }
            case 5: {
                this.writeComment(xMLStreamReader2.getText());
                return;
            }
            case 3: {
                this.writeProcessingInstruction(xMLStreamReader2.getPITarget(), xMLStreamReader2.getPIData());
                return;
            }
            case 11: {
                DTDInfo dTDInfo = xMLStreamReader2.getDTDInfo();
                if (dTDInfo == null) {
                    throw new XMLStreamException("Current state DOCTYPE, but not DTDInfo Object returned -- reader doesn't support DTDs?");
                }
                this.writeDTD(dTDInfo.getDTDRootName(), dTDInfo.getDTDSystemId(), dTDInfo.getDTDPublicId(), dTDInfo.getDTDInternalSubset());
                return;
            }
            case 9: {
                this.writeEntityRef(xMLStreamReader2.getLocalName());
                return;
            }
        }
        throw new XMLStreamException("Unrecognized event type (" + xMLStreamReader2.getEventType() + "); not sure how to copy");
    }

    @Override
    public void closeCompletely() throws XMLStreamException {
        this.close();
    }

    @Override
    public XMLValidator validateAgainst(XMLValidationSchema xMLValidationSchema) throws XMLStreamException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public XMLValidator stopValidatingAgainst(XMLValidationSchema xMLValidationSchema) throws XMLStreamException {
        return null;
    }

    @Override
    public XMLValidator stopValidatingAgainst(XMLValidator xMLValidator) throws XMLStreamException {
        return null;
    }

    @Override
    public ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler validationProblemHandler) {
        return null;
    }

    protected void copyStartElement(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        String string2;
        String string3;
        int n;
        int n2 = xMLStreamReader.getNamespaceCount();
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                string3 = xMLStreamReader.getNamespacePrefix(n);
                string2 = xMLStreamReader.getNamespaceURI(n);
                if (string3 == null || string3.length() == 0) {
                    this.setDefaultNamespace(string2);
                    continue;
                }
                this.setPrefix(string3, string2);
            }
        }
        this.writeStartElement(xMLStreamReader.getPrefix(), xMLStreamReader.getLocalName(), xMLStreamReader.getNamespaceURI());
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                string3 = xMLStreamReader.getNamespacePrefix(n);
                string2 = xMLStreamReader.getNamespaceURI(n);
                if (string3 == null || string3.length() == 0) {
                    this.writeDefaultNamespace(string2);
                    continue;
                }
                this.writeNamespace(string3, string2);
            }
        }
        if ((n = xMLStreamReader.getAttributeCount()) > 0) {
            for (int i = 0; i < n; ++i) {
                this.writeAttribute(xMLStreamReader.getAttributePrefix(i), xMLStreamReader.getAttributeNamespace(i), xMLStreamReader.getAttributeLocalName(i), xMLStreamReader.getAttributeValue(i));
            }
        }
    }

    protected String serializeQNameValue(QName qName) throws XMLStreamException {
        String string2;
        String string3;
        if (this.mNsRepairing) {
            string3 = qName.getNamespaceURI();
            NamespaceContext namespaceContext = this.getNamespaceContext();
            String string4 = string2 = namespaceContext == null ? null : namespaceContext.getPrefix(string3);
            if (string2 == null) {
                String string5 = qName.getPrefix();
                if (string5 == null || string5.length() == 0) {
                    string2 = "";
                    this.writeDefaultNamespace(string3);
                } else {
                    string2 = string5;
                    this.writeNamespace(string2, string3);
                }
            }
        } else {
            string2 = qName.getPrefix();
        }
        string3 = qName.getLocalPart();
        if (string2 == null || string2.length() == 0) {
            return string3;
        }
        return string2 + ":" + string3;
    }

    protected SimpleValueEncoder getValueEncoder() {
        if (this.mValueEncoder == null) {
            this.mValueEncoder = new SimpleValueEncoder();
        }
        return this.mValueEncoder;
    }
}

