/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.CompletorFactory;
import org.netbeans.modules.spring.beans.completion.completors.AttributeValueCompletorFactory;
import org.netbeans.modules.spring.beans.completion.completors.BeanDependsOnCompletor;
import org.netbeans.modules.spring.beans.completion.completors.BeanIdCompletor;
import org.netbeans.modules.spring.beans.completion.completors.BeansRefCompletor;
import org.netbeans.modules.spring.beans.completion.completors.BeansRefCompletorFactory;
import org.netbeans.modules.spring.beans.completion.completors.FactoryMethodCompletor;
import org.netbeans.modules.spring.beans.completion.completors.GenericCompletorFactory;
import org.netbeans.modules.spring.beans.completion.completors.InitDestroyMethodCompletor;
import org.netbeans.modules.spring.beans.completion.completors.JavaClassCompletor;
import org.netbeans.modules.spring.beans.completion.completors.JavaPackageCompletor;
import org.netbeans.modules.spring.beans.completion.completors.PNamespaceBeanRefCompletor;
import org.netbeans.modules.spring.beans.completion.completors.PNamespaceCompletor;
import org.netbeans.modules.spring.beans.completion.completors.PropertyCompletor;
import org.netbeans.modules.spring.beans.completion.completors.ResourceCompletor;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.utils.StringUtils;

public final class CompletorRegistry {
    private static Map<String, CompletorFactory> completorFactories = new HashMap<String, CompletorFactory>();
    private static CompletorRegistry INSTANCE = new CompletorRegistry();

    private CompletorRegistry() {
        this.setupCompletors();
    }

    private void setupCompletors() {
        String[] primaryItems = new String[]{"true", null, "false", null};
        AttributeValueCompletorFactory completorFactory = new AttributeValueCompletorFactory(primaryItems);
        this.registerCompletorFactory("bean", "primary", completorFactory);
        String[] defaultLazyInitItems = new String[]{"true", null, "false", null};
        completorFactory = new AttributeValueCompletorFactory(defaultLazyInitItems);
        this.registerCompletorFactory("beans", "default-lazy-init", completorFactory);
        String[] defaultMergeItems = new String[]{"true", null, "false", null};
        completorFactory = new AttributeValueCompletorFactory(defaultMergeItems);
        this.registerCompletorFactory("beans", "default-merge", completorFactory);
        String[] abstractItems = new String[]{"true", null, "false", null};
        completorFactory = new AttributeValueCompletorFactory(abstractItems);
        this.registerCompletorFactory("bean", "abstract", completorFactory);
        this.registerCompletorFactory("import", "resource", new GenericCompletorFactory(ResourceCompletor.class));
        GenericCompletorFactory javaClassCompletorFactory = new GenericCompletorFactory(JavaClassCompletor.class);
        this.registerCompletorFactory("bean", "class", javaClassCompletorFactory);
        this.registerCompletorFactory("list", "value-type", javaClassCompletorFactory);
        this.registerCompletorFactory("map", "value-type", javaClassCompletorFactory);
        this.registerCompletorFactory("map", "key-type", javaClassCompletorFactory);
        this.registerCompletorFactory("set", "value-type", javaClassCompletorFactory);
        this.registerCompletorFactory("value", "type", javaClassCompletorFactory);
        this.registerCompletorFactory("constructor-arg", "type", javaClassCompletorFactory);
        GenericCompletorFactory javaPackageCompletorFactory = new GenericCompletorFactory(JavaPackageCompletor.class);
        this.registerCompletorFactory("component-scan", "base-package", javaPackageCompletorFactory);
        BeansRefCompletorFactory beansRefCompletorFactory = new BeansRefCompletorFactory(true, BeansRefCompletor.class);
        this.registerCompletorFactory("alias", "name", beansRefCompletorFactory);
        this.registerCompletorFactory("bean", "parent", beansRefCompletorFactory);
        this.registerCompletorFactory("bean", "factory-bean", beansRefCompletorFactory);
        this.registerCompletorFactory("constructor-arg", "ref", beansRefCompletorFactory);
        this.registerCompletorFactory("ref", "bean", beansRefCompletorFactory);
        this.registerCompletorFactory("idref", "bean", beansRefCompletorFactory);
        this.registerCompletorFactory("entry", "key-ref", beansRefCompletorFactory);
        this.registerCompletorFactory("entry", "value-ref", beansRefCompletorFactory);
        this.registerCompletorFactory("property", "ref", beansRefCompletorFactory);
        this.registerCompletorFactory("lookup-method", "bean", beansRefCompletorFactory);
        this.registerCompletorFactory("replaced-method", "replacer", beansRefCompletorFactory);
        beansRefCompletorFactory = new BeansRefCompletorFactory(false, BeansRefCompletor.class);
        this.registerCompletorFactory("ref", "local", beansRefCompletorFactory);
        this.registerCompletorFactory("idref", "local", beansRefCompletorFactory);
        GenericCompletorFactory javaMethodCompletorFactory = new GenericCompletorFactory(InitDestroyMethodCompletor.class);
        this.registerCompletorFactory("bean", "init-method", javaMethodCompletorFactory);
        this.registerCompletorFactory("bean", "destroy-method", javaMethodCompletorFactory);
        this.registerCompletorFactory("lookup-method", "name", javaMethodCompletorFactory);
        this.registerCompletorFactory("replaced-method", "name", javaMethodCompletorFactory);
        javaMethodCompletorFactory = new GenericCompletorFactory(FactoryMethodCompletor.class);
        this.registerCompletorFactory("bean", "factory-method", javaMethodCompletorFactory);
        GenericCompletorFactory propertyCompletorFactory = new GenericCompletorFactory(PropertyCompletor.class);
        this.registerCompletorFactory("property", "name", propertyCompletorFactory);
        GenericCompletorFactory pNamespaceBeanRefCompletorFactory = new GenericCompletorFactory(PNamespaceBeanRefCompletor.class);
        this.registerCompletorFactory("bean", null, pNamespaceBeanRefCompletorFactory);
        GenericCompletorFactory beanIdCompletorFactory = new GenericCompletorFactory(BeanIdCompletor.class);
        this.registerCompletorFactory("bean", "id", beanIdCompletorFactory);
        BeansRefCompletorFactory dependsOnFactory = new BeansRefCompletorFactory(true, BeanDependsOnCompletor.class);
        this.registerCompletorFactory("bean", "depends-on", dependsOnFactory);
    }

    public static CompletorRegistry getDefault() {
        return INSTANCE;
    }

    public Completor getCompletor(CompletionContext context) {
        switch (context.getCompletionType()) {
            case ATTRIBUTE_VALUE: {
                return this.getAttributeValueCompletor(context);
            }
            case ATTRIBUTE: {
                return this.getAttributeCompletor(context);
            }
            case TAG: {
                return this.getElementCompletor(context);
            }
        }
        return null;
    }

    private Completor getAttributeValueCompletor(CompletionContext context) {
        Token<XMLTokenId> attrib;
        String attribName;
        String tagName = CompletorRegistry.extractVanilaTagName(context.getTag().getNodeName());
        CompletorFactory completorFactory = this.locateCompletorFactory(tagName, attribName = (attrib = ContextUtilities.getAttributeToken(context.getDocumentContext())) != null ? attrib.text().toString() : null);
        if (completorFactory != null) {
            Completor completor = completorFactory.createCompletor(context.getCaretOffset());
            return completor;
        }
        return null;
    }

    private Completor getAttributeCompletor(CompletionContext context) {
        String tagName = CompletorRegistry.extractVanilaTagName(context.getTag().getNodeName());
        if (tagName.equals("bean") && ContextUtilities.isPNamespaceAdded(context.getDocumentContext())) {
            return new PNamespaceCompletor(context.getCaretOffset());
        }
        return null;
    }

    private static String extractVanilaTagName(String tagNameWithNs) {
        int offset = tagNameWithNs.indexOf(":");
        return offset == -1 ? tagNameWithNs : tagNameWithNs.substring(offset + 1, tagNameWithNs.length());
    }

    private Completor getElementCompletor(CompletionContext context) {
        return null;
    }

    private void registerCompletorFactory(String tagName, String attribName, CompletorFactory completorFactory) {
        completorFactories.put(CompletorRegistry.createRegisteredName(tagName, attribName), completorFactory);
    }

    private static String createRegisteredName(String nodeName, String attributeName) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.hasText(nodeName)) {
            builder.append("/nodeName=");
            builder.append(nodeName);
        } else {
            builder.append("/nodeName=");
            builder.append("*");
        }
        if (StringUtils.hasText(attributeName)) {
            builder.append("/attribute=");
            builder.append(attributeName);
        }
        return builder.toString();
    }

    private CompletorFactory locateCompletorFactory(String nodeName, String attributeName) {
        String key = CompletorRegistry.createRegisteredName(nodeName, attributeName);
        if (completorFactories.containsKey(key)) {
            return completorFactories.get(key);
        }
        key = CompletorRegistry.createRegisteredName(nodeName, null);
        if (completorFactories.containsKey(key)) {
            return completorFactories.get(key);
        }
        key = CompletorRegistry.createRegisteredName("*", attributeName);
        if (completorFactories.containsKey(key)) {
            return completorFactories.get(key);
        }
        return null;
    }
}

