/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.grammar.IToken;
import org.eclipse.tm4e.core.grammar.ITokenizeLineResult;
import org.eclipse.tm4e.core.model.DecodeMap;
import org.eclipse.tm4e.core.model.ITokenizationSupport;
import org.eclipse.tm4e.core.model.LineTokens;
import org.eclipse.tm4e.core.model.TMState;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.core.model.TMTokenDecodeData;

public class Tokenizer
implements ITokenizationSupport {
    private final IGrammar grammar;
    private final DecodeMap decodeMap;

    public Tokenizer(IGrammar grammar) {
        this.grammar = grammar;
        this.decodeMap = new DecodeMap();
    }

    @Override
    public TMState getInitialState() {
        return new TMState(null, null);
    }

    @Override
    public LineTokens tokenize(String line, TMState state) {
        return this.tokenize(line, state, null, null);
    }

    @Override
    public LineTokens tokenize(String line, TMState state, Integer offsetDelta, Integer stopAtOffset) {
        if (offsetDelta == null) {
            offsetDelta = 0;
        }
        TMState freshState = state != null ? state.clone() : this.getInitialState();
        ITokenizeLineResult textMateResult = this.grammar.tokenizeLine(line, freshState.getRuleStack());
        freshState.setRuleStack(textMateResult.getRuleStack());
        ArrayList<TMToken> tokens = new ArrayList<TMToken>();
        String lastTokenType = null;
        int len = textMateResult.getTokens().length;
        for (int tokenIndex = 0; tokenIndex < len; ++tokenIndex) {
            IToken token = textMateResult.getTokens()[tokenIndex];
            int tokenStartIndex = token.getStartIndex();
            String tokenType = this.decodeTextMateToken(this.decodeMap, token.getScopes().toArray(new String[0]));
            if (tokenType.equals(lastTokenType)) continue;
            tokens.add(new TMToken(tokenStartIndex + offsetDelta, tokenType));
            lastTokenType = tokenType;
        }
        return new LineTokens(tokens, offsetDelta + line.length(), freshState);
    }

    private String decodeTextMateToken(DecodeMap decodeMap, String[] scopes) {
        String[] prevTokenScopes = decodeMap.prevToken.scopes;
        int prevTokenScopesLength = prevTokenScopes.length;
        Map<Integer, Map<Integer, Boolean>> prevTokenScopeTokensMaps = decodeMap.prevToken.scopeTokensMaps;
        LinkedHashMap<Integer, Map<Integer, Boolean>> scopeTokensMaps = new LinkedHashMap<Integer, Map<Integer, Boolean>>();
        Map<Integer, Boolean> prevScopeTokensMaps = new LinkedHashMap<Integer, Boolean>();
        boolean sameAsPrev = true;
        for (int level = 1; level < scopes.length; ++level) {
            String scope = scopes[level];
            if (sameAsPrev) {
                if (level < prevTokenScopesLength && prevTokenScopes[level].equals(scope)) {
                    prevScopeTokensMaps = prevTokenScopeTokensMaps.get(level);
                    scopeTokensMaps.put(level, prevScopeTokensMaps);
                    continue;
                }
                sameAsPrev = false;
            }
            int[] tokens = decodeMap.getTokenIds(scope);
            prevScopeTokensMaps = new LinkedHashMap<Integer, Boolean>(prevScopeTokensMaps);
            for (int token : tokens) {
                prevScopeTokensMaps.put(token, true);
            }
            scopeTokensMaps.put(level, prevScopeTokensMaps);
        }
        decodeMap.prevToken = new TMTokenDecodeData(scopes, scopeTokensMaps);
        return decodeMap.getToken(prevScopeTokensMaps);
    }
}

