/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSURLEncoder;
import com.oracle.truffle.js.runtime.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class JSURLDecoder {
    private final boolean isSpecial;

    public JSURLDecoder(boolean isSpecial) {
        this.isSpecial = isSpecial;
    }

    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    public String decode(String string) {
        int strLen = string.length();
        StringBuilder buffer = null;
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        for (int k = 0; k < strLen; ++k) {
            char c = string.charAt(k);
            if (c != '%') {
                if (buffer == null) continue;
                buffer.append(c);
                continue;
            }
            if (buffer == null) {
                buffer = JSURLEncoder.allocBuffer(string, k, strLen);
            }
            k = this.decodeConvert(string, strLen, k, buffer, decoder);
        }
        return buffer != null ? buffer.toString() : string;
    }

    private int decodeConvert(String string, int strLen, int start, StringBuilder buffer, CharsetDecoder decoder) {
        int k = start;
        if (k + 2 >= strLen) {
            throw Errors.createURIError("illegal escape sequence");
        }
        int hex1 = JSURLDecoder.getHexValue(string.charAt(k + 1));
        int hex2 = JSURLDecoder.getHexValue(string.charAt(k + 2));
        byte b = (byte)((hex1 << 4) + hex2);
        k += 2;
        if ((b & 0x80) == 0) {
            char c = (char)b;
            if (!this.isReserved(c)) {
                buffer.append(c);
            } else {
                buffer.append(string, start, k + 1);
            }
        } else {
            k = this.decodeConvertIntl(string, strLen, k, b, buffer, decoder);
        }
        return k;
    }

    private int decodeConvertIntl(String string, int strLen, int kParam, byte b, StringBuilder buffer, CharsetDecoder decoder) {
        int k = kParam;
        int n = JSURLDecoder.findN(b);
        if (n == 1 || n > 4) {
            throw JSURLDecoder.invalidEncodingError();
        }
        byte[] octetsB = new byte[n];
        octetsB[0] = b;
        if (k + 3 * (n - 1) >= strLen) {
            throw JSURLDecoder.invalidEncodingError();
        }
        for (int j = 1; j < n; ++j) {
            int hex4;
            if (string.charAt(++k) != '%') {
                throw JSURLDecoder.invalidEncodingError();
            }
            int hex3 = JSURLDecoder.getHexValue(string.charAt(k + 1));
            byte b2 = (byte)((hex3 << 4) + (hex4 = JSURLDecoder.getHexValue(string.charAt(k + 2))));
            if ((b2 & 0xC0) != 128) {
                throw JSURLDecoder.invalidEncodingError();
            }
            k += 2;
            octetsB[j] = b2;
        }
        ByteBuffer bb = ByteBuffer.wrap(octetsB);
        CharBuffer cb = CharBuffer.wrap(new char[2]);
        decoder.reset();
        BufferUtil.asBaseBuffer(cb).rewind();
        CoderResult coderResult = decoder.decode(bb, cb, true);
        if (coderResult.isError()) {
            throw JSURLDecoder.invalidEncodingError();
        }
        if (cb.position() == 1) {
            assert (!this.isReserved(cb.get(0)));
            buffer.append(cb.get(0));
        } else {
            buffer.append(cb.get(0));
            buffer.append(cb.get(1));
        }
        return k;
    }

    private static JSException invalidEncodingError() {
        throw Errors.createURIError("invalid encoding");
    }

    private static int getHexValue(char digit) {
        int value = JSRuntime.valueInHex(digit);
        if (value < 0) {
            throw Errors.createURIError("decode: Illegal hex characters in escape (%) pattern");
        }
        return value;
    }

    private boolean isReserved(char c) {
        if (this.isSpecial) {
            return JSURLEncoder.reservedURISet.get(c);
        }
        return false;
    }

    private static int findN(byte b) {
        if ((b & 0x40) == 0) {
            return 1;
        }
        if ((b & 0x20) == 0) {
            return 2;
        }
        if ((b & 0x10) == 0) {
            return 3;
        }
        if ((b & 8) == 0) {
            return 4;
        }
        if ((b & 4) == 0) {
            return 5;
        }
        if ((b & 2) == 0) {
            return 6;
        }
        if ((b & 1) == 0) {
            return 7;
        }
        return 8;
    }
}

