/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.unary.FlattenNode;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.PropertyReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=FlattenNode.class)
public final class FlattenNodeGen
extends FlattenNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile lazyString0_flatten_;

    private FlattenNodeGen() {
    }

    @Override
    public Object execute(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof JSLazyString) {
            JSLazyString arg0Value_ = (JSLazyString)arg0Value;
            return FlattenNode.doLazyString(arg0Value_, this.lazyString0_flatten_);
        }
        if ((state & 2) != 0 && arg0Value instanceof PropertyReference) {
            PropertyReference arg0Value_ = (PropertyReference)arg0Value;
            return FlattenNode.doLazyString(arg0Value_);
        }
        if ((state & 4) != 0 && arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_ = (SafeInteger)arg0Value;
            return FlattenNode.doSafeInteger(arg0Value_);
        }
        if ((state & 8) != 0 && FlattenNodeGen.fallbackGuard_(state, arg0Value)) {
            return FlattenNode.doOther(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (arg0Value instanceof JSLazyString) {
                JSLazyString arg0Value_ = (JSLazyString)arg0Value;
                this.lazyString0_flatten_ = ConditionProfile.createBinaryProfile();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                String string = FlattenNode.doLazyString(arg0Value_, this.lazyString0_flatten_);
                return string;
            }
            if (arg0Value instanceof PropertyReference) {
                PropertyReference arg0Value_ = (PropertyReference)arg0Value;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                String string = FlattenNode.doLazyString(arg0Value_);
                return string;
            }
            if (arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger)arg0Value;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Double d = FlattenNode.doSafeInteger(arg0Value_);
                return d;
            }
            this.state_ = state |= 8;
            lock.unlock();
            hasLock = false;
            Object object = FlattenNode.doOther(arg0Value);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[5];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doLazyString";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<ConditionProfile>> cached = new ArrayList<List<ConditionProfile>>();
            cached.add(Arrays.asList(this.lazyString0_flatten_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doLazyString";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doOther";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        return Introspection.Provider.create((Object[])data);
    }

    private static boolean fallbackGuard_(int state, Object arg0Value) {
        if ((state & 1) == 0 && arg0Value instanceof JSLazyString) {
            return false;
        }
        if ((state & 2) == 0 && arg0Value instanceof PropertyReference) {
            return false;
        }
        return (state & 4) != 0 || !(arg0Value instanceof SafeInteger);
    }

    public static FlattenNode create() {
        return new FlattenNodeGen();
    }
}

