/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.ContextThreadLocal;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.FinalIntMap;
import com.oracle.truffle.polyglot.HostLanguage;
import com.oracle.truffle.polyglot.HostWrapper;
import com.oracle.truffle.polyglot.ImageBuildTimeOptions;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.PolyglotBindings;
import com.oracle.truffle.polyglot.PolyglotBindingsValue;
import com.oracle.truffle.polyglot.PolyglotContextConfig;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotEngineOptions;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotLimits;
import com.oracle.truffle.polyglot.PolyglotLoggers;
import com.oracle.truffle.polyglot.PolyglotParsedEval;
import com.oracle.truffle.polyglot.PolyglotThreadInfo;
import com.oracle.truffle.polyglot.PolyglotValue;
import com.oracle.truffle.polyglot.ProcessHandlers;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.graalvm.collections.EconomicSet;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotContextImpl
extends AbstractPolyglotImpl.AbstractContextImpl
implements PolyglotImpl.VMObject {
    private static final TruffleLogger LOG = TruffleLogger.getLogger("engine", PolyglotContextImpl.class);
    private static final InteropLibrary UNCACHED = InteropLibrary.getFactory().getUncached();
    @CompilerDirectives.CompilationFinal
    static SingleContextState singleContextState = new SingleContextState(null);
    final Assumption singleThreaded = Truffle.getRuntime().createAssumption("Single threaded");
    private final Map<Thread, PolyglotThreadInfo> threads = new WeakHashMap<Thread, PolyglotThreadInfo>();
    private volatile PolyglotThreadInfo currentThreadInfo = PolyglotThreadInfo.NULL;
    @CompilerDirectives.CompilationFinal
    private volatile PolyglotThreadInfo constantCurrentThreadInfo = PolyglotThreadInfo.NULL;
    volatile boolean cancelling;
    volatile String invalidMessage;
    volatile Thread closingThread;
    private final ReentrantLock closingLock = new ReentrantLock();
    volatile boolean closed;
    volatile boolean invalid;
    volatile boolean disposing;
    final PolyglotEngineImpl engine;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final PolyglotLanguageContext[] contexts;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final Object[] contextImpls;
    Context creatorApi;
    Context currentApi;
    final TruffleContext truffleContext;
    final PolyglotContextImpl parent;
    volatile Map<String, Value> polyglotBindings;
    volatile Value polyglotHostBindings;
    private final PolyglotBindings polyglotBindingsObject = new PolyglotBindings(this);
    final PolyglotLanguage creator;
    final Map<String, Object> creatorArguments;
    final ContextWeakReference weakReference;
    final Set<ProcessHandlers.ProcessDecorator> subProcesses;
    @CompilerDirectives.CompilationFinal
    PolyglotContextConfig config;
    @CompilerDirectives.CompilationFinal
    private volatile FinalIntMap languageIndexMap;
    private final List<PolyglotContextImpl> childContexts = new ArrayList<PolyglotContextImpl>();
    boolean inContextPreInitialization;
    List<Source> sourcesToInvalidate;
    final AtomicLong volatileStatementCounter = new AtomicLong();
    long statementCounter;
    long elapsedTime;
    final long statementLimit;

    static Object resetSingleContextState(boolean reuse) {
        SingleContextState prev = singleContextState;
        singleContextState = new SingleContextState(reuse ? prev.singleContext : null);
        return prev;
    }

    static SingleContextState getSingleContextState() {
        return singleContextState;
    }

    static void restoreSingleContextState(Object state) {
        singleContextState = (SingleContextState)state;
    }

    static boolean isSingleContextAssumptionValid() {
        return singleContextState.singleContextAssumption.isValid();
    }

    private PolyglotContextImpl() {
        super(null);
        this.engine = null;
        this.contexts = null;
        this.contextImpls = null;
        this.truffleContext = null;
        this.parent = null;
        this.polyglotHostBindings = null;
        this.polyglotBindings = null;
        this.creator = null;
        this.creatorArguments = null;
        this.weakReference = null;
        this.statementLimit = 0L;
        this.subProcesses = new HashSet<ProcessHandlers.ProcessDecorator>();
    }

    PolyglotContextImpl(PolyglotEngineImpl engine, PolyglotContextConfig config) {
        super((AbstractPolyglotImpl)engine.impl);
        this.parent = null;
        this.engine = engine;
        this.config = config;
        this.creator = null;
        this.creatorArguments = Collections.emptyMap();
        this.truffleContext = EngineAccessor.LANGUAGE.createTruffleContext(this);
        this.weakReference = new ContextWeakReference(this);
        this.contextImpls = new Object[engine.contextLength];
        this.contexts = this.createContextArray();
        if (!config.logLevels.isEmpty()) {
            EngineAccessor.LANGUAGE.configureLoggers(this, config.logLevels, PolyglotContextImpl.getAllLoggers(engine));
        }
        this.subProcesses = new HashSet<ProcessHandlers.ProcessDecorator>();
        this.statementCounter = this.statementLimit = config.limits != null ? config.limits.statementLimit : 0x7FFFFFFFFFFFFFFEL;
        this.volatileStatementCounter.set(this.statementLimit);
        this.notifyContextCreated();
        PolyglotContextImpl.initializeStaticContext(this);
    }

    PolyglotContextImpl(PolyglotLanguageContext creator, Map<String, Object> langConfig, TruffleContext spiContext) {
        super((AbstractPolyglotImpl)creator.getEngine().impl);
        PolyglotContextImpl parent;
        this.parent = parent = creator.context;
        this.config = parent.config;
        this.engine = parent.engine;
        this.creator = creator.language;
        this.creatorArguments = langConfig;
        this.statementLimit = 0L;
        this.weakReference = new ContextWeakReference(this);
        this.parent.addChildContext(this);
        this.truffleContext = spiContext;
        if (!parent.config.logLevels.isEmpty()) {
            EngineAccessor.LANGUAGE.configureLoggers(this, parent.config.logLevels, PolyglotContextImpl.getAllLoggers(this.engine));
        }
        this.contextImpls = new Object[this.engine.contextLength];
        this.contexts = this.createContextArray();
        this.subProcesses = new HashSet<ProcessHandlers.ProcessDecorator>();
        this.engine.noInnerContexts.invalidate();
        PolyglotContextImpl.initializeStaticContext(this);
    }

    public void resetLimits() {
        PolyglotLimits.reset(this);
    }

    private PolyglotLanguageContext[] createContextArray() {
        PolyglotLanguageContext hostContext;
        Collection<PolyglotLanguage> languages = this.engine.idToLanguage.values();
        PolyglotLanguageContext[] newContexts = new PolyglotLanguageContext[this.engine.contextLength];
        Iterator<PolyglotLanguage> languageIterator = languages.iterator();
        newContexts[0] = hostContext = new PolyglotLanguageContext(this, this.engine.hostLanguage);
        for (int i = 1; i < this.engine.contextLength; ++i) {
            PolyglotLanguage language = languageIterator.next();
            newContexts[i] = new PolyglotLanguageContext(this, language);
        }
        hostContext.ensureInitialized(null);
        ((HostLanguage.HostContext)hostContext.getContextImpl()).internalContext = hostContext;
        return newContexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initializeStaticContext(PolyglotContextImpl context) {
        SingleContextState state = singleContextState;
        if (state.singleContextAssumption.isValid()) {
            SingleContextState singleContextState = state;
            synchronized (singleContextState) {
                if (state.singleContextAssumption.isValid()) {
                    if (state.singleContext != null) {
                        state.singleContextAssumption.invalidate();
                        state.singleContext = null;
                    } else {
                        state.singleContext = context;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeStaticContext(PolyglotContextImpl context) {
        SingleContextState state = singleContextState;
        if (state.singleContextAssumption.isValid()) {
            SingleContextState singleContextState = state;
            synchronized (singleContextState) {
                if (state.singleContextAssumption.isValid()) {
                    assert (state.singleContext == context);
                    state.singleContext = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invalidateStaticContextAssumption() {
        SingleContextState state = singleContextState;
        if (state.singleContextAssumption.isValid()) {
            SingleContextState singleContextState = state;
            synchronized (singleContextState) {
                if (state.singleContextAssumption.isValid()) {
                    state.singleContextAssumption.invalidate();
                    state.singleContext = null;
                }
            }
        }
    }

    PolyglotLanguageContext getContext(PolyglotLanguage language) {
        return this.contexts[language.index];
    }

    Object getContextImpl(PolyglotLanguage language) {
        Object contextImpl;
        assert (this.contextImpls.length == this.engine.contextLength);
        if (CompilerDirectives.inInterpreter()) {
            contextImpl = this.contextImpls[language.index];
        } else {
            CompilerAsserts.partialEvaluationConstant(language);
            contextImpl = EngineAccessor.RUNTIME.castArrayFixedLength(this.contextImpls, language.engine.contextLength)[language.index];
            Class<?> castClass = language.contextClass;
            contextImpl = EngineAccessor.RUNTIME.unsafeCast(contextImpl, castClass, true, castClass != Void.class, true);
        }
        assert (language.contextClass == (contextImpl == null ? Void.class : contextImpl.getClass())) : "Instable context class";
        return contextImpl;
    }

    PolyglotLanguageContext getContextInitialized(PolyglotLanguage language, PolyglotLanguage accessingLanguage) {
        PolyglotLanguageContext context = this.getContext(language);
        context.ensureInitialized(accessingLanguage);
        return context;
    }

    void notifyContextCreated() {
        EngineAccessor.INSTRUMENT.notifyContextCreated(this.engine, this.truffleContext);
    }

    private synchronized void addChildContext(PolyglotContextImpl child) {
        if (this.closingThread != null) {
            throw PolyglotEngineException.illegalState("Adding child context into a closing context.");
        }
        this.childContexts.add(child);
    }

    static PolyglotContextImpl currentNotEntered() {
        SingleContextState singleContext = singleContextState;
        if (singleContext.singleContextAssumption.isValid()) {
            if (singleContext.contextThreadLocal.isSet()) {
                return singleContext.singleContext;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return null;
        }
        return (PolyglotContextImpl)singleContext.contextThreadLocal.get();
    }

    static PolyglotContextImpl currentEntered(PolyglotEngineImpl enteredInEngine) {
        Object context;
        assert (enteredInEngine != null);
        CompilerAsserts.partialEvaluationConstant(enteredInEngine);
        SingleContextState singleContext = singleContextState;
        if (singleContext.singleContextAssumption.isValid()) {
            context = singleContext.singleContext;
        } else {
            ContextThreadLocal local = singleContext.contextThreadLocal;
            context = local.getEntered();
        }
        assert (context != null);
        if (CompilerDirectives.inCompiledCode()) {
            context = EngineAccessor.RUNTIME.unsafeCast(context, PolyglotContextImpl.class, true, true, true);
        }
        return (PolyglotContextImpl)context;
    }

    static PolyglotContextImpl requireContext() {
        PolyglotContextImpl context = PolyglotContextImpl.currentNotEntered();
        if (context == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PolyglotEngineException.illegalState("There is no current context available.");
        }
        return context;
    }

    public synchronized void explicitEnter(Context sourceContext) {
        try {
            this.checkCreatorAccess(sourceContext, "entered");
            Object prev = this.engine.enter(this);
            PolyglotThreadInfo current = this.getCurrentThreadInfo();
            assert (current.getThread() == Thread.currentThread());
            current.explicitContextStack.addLast(prev);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this.engine, t);
        }
    }

    public synchronized void explicitLeave(Context sourceContext) {
        if (this.closed || this.closingThread == Thread.currentThread()) {
            return;
        }
        try {
            this.checkCreatorAccess(sourceContext, "left");
            PolyglotThreadInfo current = this.getCurrentThreadInfo();
            LinkedList<Object> stack = current.explicitContextStack;
            if (stack.isEmpty() || current.getThread() == null) {
                throw PolyglotEngineException.illegalState("The context is not entered explicity. A context can only be left if it was previously entered.");
            }
            this.engine.leave(stack.removeLast(), this);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this.engine, t);
        }
    }

    private void checkCreatorAccess(Context context, String operation) {
        if (context != this.creatorApi) {
            throw PolyglotEngineException.illegalState(String.format("Context instances that were received using Context.get() cannot be %s.", operation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    PolyglotContextImpl enterThreadChanged() {
        PolyglotContextImpl prev;
        Thread current = Thread.currentThread();
        boolean needsInitialization = false;
        PolyglotContextImpl polyglotContextImpl = this;
        synchronized (polyglotContextImpl) {
            boolean transitionToMultiThreading;
            PolyglotThreadInfo threadInfo = this.getCurrentThreadInfo();
            this.checkClosed();
            assert (threadInfo != null);
            threadInfo = this.threads.get(current);
            if (threadInfo == null) {
                threadInfo = this.createThreadInfo(current);
                needsInitialization = !this.inContextPreInitialization;
            }
            boolean bl = transitionToMultiThreading = this.singleThreaded.isValid() && this.hasActiveOtherThread(true);
            if (transitionToMultiThreading) {
                this.checkAllThreadAccesses();
            }
            Thread closing = this.closingThread;
            if (needsInitialization) {
                if (closing != null && closing != current) {
                    throw PolyglotEngineException.illegalState("Can not create new threads in closing context.", true);
                }
                this.threads.put(current, threadInfo);
            }
            prev = (PolyglotContextImpl)singleContextState.contextThreadLocal.setReturnParent(this);
            threadInfo.enter(this.engine);
            if (transitionToMultiThreading) {
                this.transitionToMultiThreaded();
            }
            if (needsInitialization) {
                this.initializeNewThread(current);
            }
            if (!this.closed && closing == null && !this.invalid) {
                this.setCachedThreadInfo(threadInfo);
            }
        }
        if (needsInitialization) {
            EngineAccessor.INSTRUMENT.notifyThreadStarted(this.engine, this.truffleContext, current);
        }
        return prev;
    }

    void setCachedThreadInfo(PolyglotThreadInfo info) {
        assert (Thread.holdsLock(this));
        this.currentThreadInfo = info;
        if (this.engine.singleThreadPerContext.isValid() && this.engine.singleContext.isValid()) {
            this.constantCurrentThreadInfo = info;
        }
    }

    private void checkAllThreadAccesses() {
        assert (Thread.holdsLock(this));
        Thread current = Thread.currentThread();
        ArrayList<PolyglotLanguage> deniedLanguages = null;
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized()) continue;
            boolean accessAllowed = true;
            if (!EngineAccessor.LANGUAGE.isThreadAccessAllowed(context.env, current, false)) {
                accessAllowed = false;
            }
            if (accessAllowed) {
                for (PolyglotThreadInfo seenThread : this.threads.values()) {
                    if (EngineAccessor.LANGUAGE.isThreadAccessAllowed(context.env, seenThread.getThread(), false)) continue;
                    accessAllowed = false;
                    break;
                }
            }
            if (accessAllowed) continue;
            if (deniedLanguages == null) {
                deniedLanguages = new ArrayList<PolyglotLanguage>();
            }
            deniedLanguages.add(context.language);
        }
        if (deniedLanguages != null) {
            throw PolyglotContextImpl.throwDeniedThreadAccess(current, false, deniedLanguages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    PolyglotThreadInfo leaveThreadChanged() {
        PolyglotThreadInfo info;
        PolyglotContextImpl polyglotContextImpl = this;
        synchronized (polyglotContextImpl) {
            Thread current = Thread.currentThread();
            this.setCachedThreadInfo(PolyglotThreadInfo.NULL);
            PolyglotThreadInfo threadInfo = this.threads.get(current);
            assert (threadInfo != null);
            info = threadInfo;
            if (this.cancelling && info.isLastActive()) {
                this.notifyThreadClosed();
            }
            info.leave(this.engine);
            if (!(this.closed || this.cancelling || this.invalid)) {
                this.setCachedThreadInfo(threadInfo);
            }
        }
        return info;
    }

    private void initializeNewThread(Thread thread) {
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized()) continue;
            EngineAccessor.LANGUAGE.initializeThread(context.env, thread);
        }
    }

    long getStatementsExecuted() {
        long count = this.engine.singleThreadPerContext.isValid() ? this.statementCounter : this.volatileStatementCounter.get();
        return this.statementLimit - count;
    }

    private void transitionToMultiThreaded() {
        assert (this.singleThreaded.isValid());
        assert (Thread.holdsLock(this));
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized()) continue;
            EngineAccessor.LANGUAGE.initializeMultiThreading(context.env);
        }
        this.engine.singleThreadPerContext.invalidate();
        this.singleThreaded.invalidate();
        long statementsExecuted = this.statementLimit - this.statementCounter;
        this.volatileStatementCounter.getAndAdd(-statementsExecuted);
    }

    private PolyglotThreadInfo createThreadInfo(Thread current) {
        assert (Thread.holdsLock(this));
        PolyglotThreadInfo threadInfo = new PolyglotThreadInfo(this, current);
        boolean singleThread = this.isSingleThreaded();
        ArrayList<PolyglotLanguage> deniedLanguages = null;
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized() || EngineAccessor.LANGUAGE.isThreadAccessAllowed(context.env, current, singleThread)) continue;
            if (deniedLanguages == null) {
                deniedLanguages = new ArrayList<PolyglotLanguage>();
            }
            deniedLanguages.add(context.language);
        }
        if (deniedLanguages != null) {
            throw PolyglotContextImpl.throwDeniedThreadAccess(current, singleThread, deniedLanguages);
        }
        return threadInfo;
    }

    static RuntimeException throwDeniedThreadAccess(Thread current, boolean accessSingleThreaded, List<PolyglotLanguage> deniedLanguages) {
        StringBuilder languagesString = new StringBuilder("");
        for (PolyglotLanguage language : deniedLanguages) {
            if (languagesString.length() != 0) {
                languagesString.append(", ");
            }
            languagesString.append(language.getId());
        }
        String message = accessSingleThreaded ? String.format("Single threaded access requested by thread %s but is not allowed for language(s) %s.", current, languagesString) : String.format("Multi threaded access requested by thread %s but is not allowed for language(s) %s.", current, languagesString);
        throw PolyglotEngineException.illegalState(message);
    }

    Value findLegacyExportedSymbol(String symbolName) {
        Value legacySymbol = this.findLegacyExportedSymbol(symbolName, true);
        if (legacySymbol != null) {
            return legacySymbol;
        }
        return this.findLegacyExportedSymbol(symbolName, false);
    }

    private Value findLegacyExportedSymbol(String name, boolean onlyExplicit) {
        for (PolyglotLanguageContext languageContext : this.contexts) {
            Object s;
            if (!languageContext.isInitialized() || (s = EngineAccessor.LANGUAGE.findExportedSymbol(languageContext.env, name, onlyExplicit)) == null) continue;
            return languageContext.asValue(s);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getBindings(String languageId) {
        PolyglotLanguage language = this.requirePublicLanguage(languageId);
        PolyglotLanguageContext languageContext = this.getContext(language);
        Object prev = this.engine.enterIfNeeded(this);
        try {
            if (!languageContext.isInitialized()) {
                languageContext.ensureInitialized(null);
            }
            Value value = languageContext.getHostBindings();
            this.engine.leaveIfNeeded(prev, this);
            return value;
        }
        catch (Throwable throwable) {
            try {
                this.engine.leaveIfNeeded(prev, this);
                throw throwable;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(languageContext, e);
            }
        }
    }

    public Value getPolyglotBindings() {
        try {
            this.checkClosed();
            Value bindings = this.polyglotHostBindings;
            if (bindings == null) {
                this.initPolyglotBindings();
                bindings = this.polyglotHostBindings;
            }
            return bindings;
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.engine, e);
        }
    }

    public Map<String, Value> getPolyglotGuestBindings() {
        Map<String, Value> bindings = this.polyglotBindings;
        if (bindings == null) {
            this.initPolyglotBindings();
            bindings = this.polyglotBindings;
        }
        return bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPolyglotBindings() {
        PolyglotContextImpl polyglotContextImpl = this;
        synchronized (polyglotContextImpl) {
            if (this.polyglotBindings == null) {
                this.polyglotBindings = new ConcurrentHashMap<String, Value>();
                PolyglotBindings bindings = new PolyglotBindings(this.getHostContext());
                this.polyglotHostBindings = this.getAPIAccess().newValue((Object)bindings, (AbstractPolyglotImpl.AbstractValueImpl)new PolyglotBindingsValue(this.getHostContext(), bindings));
            }
        }
    }

    public Object getPolyglotBindingsObject() {
        return this.polyglotBindingsObject;
    }

    void checkClosed() {
        if (this.invalid && this.closingThread != Thread.currentThread()) {
            throw new PolyglotEngineImpl.CancelExecution(null, this.invalidMessage);
        }
        if (this.closed) {
            throw PolyglotEngineException.illegalState("The Context is already closed.");
        }
    }

    PolyglotLanguageContext getHostContext() {
        return this.contexts[0];
    }

    HostLanguage.HostContext getHostContextImpl() {
        return (HostLanguage.HostContext)this.getHostContext().getContextImpl();
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.engine;
    }

    PolyglotLanguageContext getLanguageContext(Class<? extends TruffleLanguage<?>> languageClass) {
        if (CompilerDirectives.isPartialEvaluationConstant(this)) {
            return this.getLanguageContextImpl(languageClass);
        }
        return this.getLanguageContextBoundary(languageClass);
    }

    @CompilerDirectives.TruffleBoundary
    private PolyglotLanguageContext getLanguageContextBoundary(Class<? extends TruffleLanguage<?>> languageClass) {
        return this.getLanguageContextImpl(languageClass);
    }

    PolyglotLanguageContext findLanguageContext(Class<? extends TruffleLanguage> languageClazz) {
        PolyglotLanguage directLanguage = this.engine.getLanguage(languageClazz, false);
        if (directLanguage != null) {
            return this.getContext(directLanguage);
        }
        for (PolyglotLanguageContext lang : this.contexts) {
            if (!lang.isInitialized()) continue;
            TruffleLanguage<?> language = EngineAccessor.LANGUAGE.getLanguage(lang.env);
            if (languageClazz == TruffleLanguage.class || !languageClazz.isInstance(language)) continue;
            return lang;
        }
        HashSet<String> languageNames = new HashSet<String>();
        for (PolyglotLanguageContext lang : this.contexts) {
            if (!lang.isInitialized()) continue;
            languageNames.add(lang.language.cache.getClassName());
        }
        throw PolyglotEngineException.illegalState("Cannot find language " + languageClazz + " among " + languageNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolyglotLanguageContext getLanguageContextImpl(Class<? extends TruffleLanguage<?>> languageClass) {
        int indexValue;
        FinalIntMap map = this.languageIndexMap;
        int n = indexValue = map != null ? map.get(languageClass) : -1;
        if (indexValue == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            PolyglotContextImpl polyglotContextImpl = this;
            synchronized (polyglotContextImpl) {
                if (this.languageIndexMap == null) {
                    this.languageIndexMap = new FinalIntMap();
                }
                if ((indexValue = this.languageIndexMap.get(languageClass)) == -1) {
                    PolyglotLanguageContext context = this.findLanguageContext(languageClass);
                    indexValue = context.language.index;
                    this.languageIndexMap.put(languageClass, indexValue);
                }
            }
        }
        PolyglotLanguageContext context = this.contexts[indexValue];
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean initializeLanguage(String languageId) {
        PolyglotLanguage language = this.requirePublicLanguage(languageId);
        PolyglotLanguageContext languageContext = this.getContext(language);
        try {
            Object prev = this.engine.enterIfNeeded(this);
            try {
                languageContext.checkAccess(null);
                if (languageContext.isInitialized()) return false;
                boolean bl = languageContext.ensureInitialized(null);
                return bl;
            }
            finally {
                this.engine.leaveIfNeeded(prev, this);
            }
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(languageContext, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value parse(String languageId, Object sourceImpl) {
        PolyglotLanguage language = this.requirePublicLanguage(languageId);
        PolyglotLanguageContext languageContext = this.getContext(language);
        Object prev = this.engine.enterIfNeeded(this);
        try {
            Source source = (Source)sourceImpl;
            languageContext.checkAccess(null);
            languageContext.ensureInitialized(null);
            CallTarget target = languageContext.parseCached(null, source, null);
            Value value = languageContext.asValue(new PolyglotParsedEval(languageContext, source, target));
            this.engine.leaveIfNeeded(prev, this);
            return value;
        }
        catch (Throwable throwable) {
            try {
                this.engine.leaveIfNeeded(prev, this);
                throw throwable;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(languageContext, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value eval(String languageId, Object sourceImpl) {
        PolyglotLanguage language = this.requirePublicLanguage(languageId);
        PolyglotLanguageContext languageContext = this.getContext(language);
        Object prev = this.engine.enterIfNeeded(this);
        try {
            Value hostValue;
            Source source = (Source)sourceImpl;
            languageContext.checkAccess(null);
            languageContext.ensureInitialized(null);
            CallTarget target = languageContext.parseCached(null, source, null);
            Object result = target.call(PolyglotImpl.EMPTY_ARGS);
            try {
                hostValue = languageContext.asValue(result);
            }
            catch (ClassCastException | NullPointerException e) {
                throw new AssertionError(String.format("Language %s returned an invalid return value %s. Must be an interop value.", languageId, result), e);
            }
            if (source.isInteractive()) {
                PolyglotContextImpl.printResult(languageContext, result);
            }
            Value value = hostValue;
            this.engine.leaveIfNeeded(prev, this);
            return value;
        }
        catch (Throwable throwable) {
            try {
                this.engine.leaveIfNeeded(prev, this);
                throw throwable;
            }
            catch (Throwable e) {
                throw PolyglotImpl.guestToHostException(languageContext, e);
            }
        }
    }

    private PolyglotLanguage requirePublicLanguage(String languageId) {
        PolyglotLanguage language = this.engine.idToLanguage.get(languageId);
        if (language == null || language.cache.isInternal()) {
            this.engine.requirePublicLanguage(languageId);
            assert (false);
            return null;
        }
        return language;
    }

    @CompilerDirectives.TruffleBoundary
    static void printResult(PolyglotLanguageContext languageContext, Object result) {
        String stringResult;
        if (!EngineAccessor.LANGUAGE.isVisible(languageContext.env, result)) {
            return;
        }
        try {
            stringResult = UNCACHED.asString(UNCACHED.toDisplayString(languageContext.getLanguageView(result), true));
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
        try {
            OutputStream out = languageContext.context.config.out;
            out.write(stringResult.getBytes(StandardCharsets.UTF_8));
            out.write(System.getProperty("line.separator").getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ioex) {
            throw new IllegalStateException(ioex);
        }
    }

    public Engine getEngineImpl(Context sourceContext) {
        return sourceContext == this.creatorApi ? this.engine.creatorApi : this.engine.currentApi;
    }

    public void close(Context sourceContext, boolean cancelIfExecuting) {
        try {
            this.checkCreatorAccess(sourceContext, "closed");
            boolean closeCompleted = this.closeImpl(cancelIfExecuting, cancelIfExecuting, true);
            if (cancelIfExecuting) {
                this.engine.getCancelHandler().cancel(Arrays.asList(this));
            } else if (!closeCompleted) {
                throw PolyglotEngineException.illegalState(String.format("The context is currently executing on another thread. Set cancelIfExecuting to true to stop the execution on this thread.", new Object[0]));
            }
            this.checkSubProcessFinished();
            if (this.engine.boundEngine && this.parent == null) {
                this.engine.ensureClosed(cancelIfExecuting, true);
            }
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this.engine, t);
        }
    }

    public Value asValue(Object hostValue) {
        try {
            PolyglotLanguageContext targetLanguageContext;
            this.checkClosed();
            if (hostValue instanceof Value) {
                PolyglotValue value = (PolyglotValue)this.getAPIAccess().getImpl((Value)hostValue);
                if (value.languageContext != null && value.languageContext.context == this) {
                    return (Value)hostValue;
                }
                targetLanguageContext = this.getHostContext();
            } else if (HostWrapper.isInstance(hostValue)) {
                targetLanguageContext = HostWrapper.asInstance(hostValue).getLanguageContext();
                if (this != targetLanguageContext.context) {
                    targetLanguageContext = this.getHostContext();
                }
            } else {
                targetLanguageContext = this.getHostContext();
            }
            return targetLanguageContext.asValue(targetLanguageContext.toGuestValue(hostValue));
        }
        catch (Throwable e) {
            throw PolyglotImpl.guestToHostException(this.getHostContext(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForClose() {
        while (!this.closeImpl(false, true, true)) {
            try {
                PolyglotContextImpl polyglotContextImpl = this;
                synchronized (polyglotContextImpl) {
                    this.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    boolean isSingleThreaded() {
        return this.singleThreaded.isValid();
    }

    Map<Thread, PolyglotThreadInfo> getSeenThreads() {
        assert (Thread.holdsLock(this));
        return this.threads;
    }

    synchronized boolean isActive() {
        for (PolyglotThreadInfo seenTinfo : this.threads.values()) {
            if (!seenTinfo.isActive()) continue;
            return true;
        }
        return false;
    }

    PolyglotThreadInfo getFirstActiveOtherThread(boolean includePolyglotThread) {
        assert (Thread.holdsLock(this));
        for (PolyglotThreadInfo otherInfo : this.threads.values()) {
            if (!includePolyglotThread && otherInfo.isPolyglotThread(this) || otherInfo.isCurrent() || !otherInfo.isActive()) continue;
            return otherInfo;
        }
        return null;
    }

    boolean hasActiveOtherThread(boolean includePolyglotThreads) {
        return this.getFirstActiveOtherThread(includePolyglotThreads) != null;
    }

    synchronized void notifyThreadClosed() {
        PolyglotThreadInfo currentTInfo = this.getCurrentThreadInfo();
        if (currentTInfo != PolyglotThreadInfo.NULL) {
            currentTInfo.cancelled = true;
            Thread.interrupted();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean closeImpl(boolean cancelIfExecuting, boolean waitForPolyglotThreads, boolean notifyInstruments) {
        Object prev;
        boolean waitForClose = false;
        boolean currentThreadActive = false;
        while (true) {
            if (waitForClose) {
                this.closingLock.lock();
                this.closingLock.unlock();
                waitForClose = false;
            }
            PolyglotContextImpl polyglotContextImpl = this;
            // MONITORENTER : polyglotContextImpl
            if (this.closed) {
                // MONITOREXIT : polyglotContextImpl
                return true;
            }
            Thread localClosingThread = this.closingThread;
            if (localClosingThread == null) break;
            if (localClosingThread == Thread.currentThread()) {
                // MONITOREXIT : polyglotContextImpl
                return true;
            }
            waitForClose = true;
            // MONITOREXIT : polyglotContextImpl
        }
        PolyglotThreadInfo threadInfo = this.getCurrentThreadInfo();
        this.setCachedThreadInfo(PolyglotThreadInfo.NULL);
        currentThreadActive = threadInfo.isActive();
        if (cancelIfExecuting) {
            this.cancelling = true;
            if (threadInfo != PolyglotThreadInfo.NULL) {
                threadInfo.cancelled = true;
                Thread.interrupted();
            }
        }
        if (this.hasActiveOtherThread(waitForPolyglotThreads)) {
            // MONITOREXIT : polyglotContextImpl
            return false;
        }
        this.closingThread = Thread.currentThread();
        if (!threadInfo.explicitContextStack.isEmpty()) {
            PolyglotContextImpl polyglotContextImpl = this;
            while (!threadInfo.explicitContextStack.isEmpty()) {
                void var9_11;
                prev = threadInfo.explicitContextStack.removeLast();
                this.engine.leave(prev, (PolyglotContextImpl)var9_11);
                PolyglotContextImpl polyglotContextImpl2 = (PolyglotContextImpl)prev;
            }
            threadInfo.explicitContextStack.clear();
        }
        this.closingLock.lock();
        // MONITOREXIT : polyglotContextImpl
        Thread[] remainingThreads = null;
        List<PolyglotLanguageContext> disposedContexts = null;
        boolean success = false;
        try {
            assert (this.closingThread == Thread.currentThread());
            assert (this.closingLock.isHeldByCurrentThread()) : "lock is acquired";
            assert (!this.closed);
            Object object = this.engine.enter(this);
            try {
                this.closeChildContexts(cancelIfExecuting, waitForPolyglotThreads, notifyInstruments);
                this.finalizeContext(notifyInstruments);
                disposedContexts = this.disposeContext();
                assert (this.childContexts.isEmpty());
                success = true;
            }
            finally {
                prev = this;
            }
        }
        finally {
            this.closingThread = null;
            this.closingLock.unlock();
        }
        if (disposedContexts != null) {
            for (PolyglotLanguageContext context : disposedContexts) {
                context.notifyDisposed(notifyInstruments);
            }
        }
        if (!success) return true;
        if (this.parent != null) {
            PolyglotContextImpl polyglotContextImpl = this.parent;
            // MONITORENTER : polyglotContextImpl
            this.parent.childContexts.remove(this);
            // MONITOREXIT : polyglotContextImpl
        } else if (notifyInstruments) {
            this.engine.removeContext(this);
        }
        if (notifyInstruments) {
            for (Thread thread : remainingThreads) {
                EngineAccessor.INSTRUMENT.notifyThreadFinished(this.engine, this.truffleContext, thread);
            }
            EngineAccessor.INSTRUMENT.notifyContextClosed(this.engine, this.truffleContext);
        }
        PolyglotContextImpl polyglotContextImpl = this;
        // MONITORENTER : polyglotContextImpl
        if (!currentThreadActive) {
            if (this.contexts != null) {
                for (PolyglotLanguageContext langContext : this.contexts) {
                    langContext.close();
                }
            }
            if (this.contextImpls != null) {
                for (int i = 0; i < this.contextImpls.length; ++i) {
                    this.contextImpls[i] = null;
                }
            }
        }
        // MONITOREXIT : polyglotContextImpl
        if (this.parent != null) return true;
        if (!this.config.logLevels.isEmpty()) {
            EngineAccessor.LANGUAGE.configureLoggers(this, null, PolyglotContextImpl.getAllLoggers(this.engine));
        }
        if (this.config.logHandler == null) return true;
        if (PolyglotLoggers.isSameLogSink(this.config.logHandler, this.engine.logHandler)) return true;
        this.config.logHandler.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeChildContexts(boolean cancelIfExecuting, boolean waitForPolyglotThreads, boolean notifyInstruments) {
        PolyglotContextImpl[] polyglotContextImplArray = this;
        synchronized (this) {
            PolyglotContextImpl[] childrenToClose = this.childContexts.toArray(new PolyglotContextImpl[this.childContexts.size()]);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            for (PolyglotContextImpl childContext : childrenToClose) {
                childContext.closeImpl(cancelIfExecuting, waitForPolyglotThreads, notifyInstruments);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PolyglotLanguageContext> disposeContext() {
        assert (!this.disposing);
        this.disposing = true;
        try {
            ArrayList<PolyglotLanguageContext> disposedContexts = new ArrayList<PolyglotLanguageContext>(this.contexts.length);
            Object object = this;
            synchronized (object) {
                for (int i = this.contexts.length - 1; i >= 0; --i) {
                    PolyglotLanguageContext context = this.contexts[i];
                    boolean disposed = context.dispose();
                    if (!disposed) continue;
                    disposedContexts.add(context);
                }
            }
            object = disposedContexts;
            return object;
        }
        finally {
            this.disposing = false;
        }
    }

    private void finalizeContext(boolean notifyInstruments) {
        boolean finalizationPerformed;
        do {
            finalizationPerformed = false;
            for (int i = this.contexts.length - 1; i >= 0; --i) {
                PolyglotLanguageContext context = this.contexts[i];
                if (!context.isInitialized()) continue;
                finalizationPerformed |= context.finalizeContext(notifyInstruments);
            }
        } while (finalizationPerformed);
    }

    synchronized void sendInterrupt() {
        if (!this.cancelling) {
            return;
        }
        for (PolyglotThreadInfo threadInfo : this.threads.values()) {
            if (threadInfo.isCurrent() || !threadInfo.isActive()) continue;
            threadInfo.getThread().interrupt();
        }
    }

    PolyglotThreadInfo getCurrentThreadInfo() {
        assert (Thread.holdsLock(this));
        PolyglotThreadInfo currentTInfo = this.currentThreadInfo;
        if (currentTInfo.getThread() != Thread.currentThread() && (currentTInfo = this.threads.get(Thread.currentThread())) == null) {
            currentTInfo = PolyglotThreadInfo.NULL;
        }
        assert (currentTInfo.getThread() == null || currentTInfo.getThread() == Thread.currentThread());
        return currentTInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean patch(PolyglotContextConfig newConfig) {
        CompilerAsserts.neverPartOfCompilation();
        this.config = newConfig;
        PolyglotContextImpl.initializeStaticContext(this);
        if (!newConfig.logLevels.isEmpty()) {
            EngineAccessor.LANGUAGE.configureLoggers(this, newConfig.logLevels, PolyglotContextImpl.getAllLoggers(this.engine));
        }
        Object prev = this.engine.enter(this);
        try {
            for (int i = 1; i < this.contexts.length; ++i) {
                PolyglotLanguageContext context = this.contexts[i];
                if (context.patch(newConfig)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.engine.leave(prev, this);
        }
        return true;
    }

    void replayInstrumentationEvents() {
        this.notifyContextCreated();
        for (PolyglotLanguageContext lc : this.contexts) {
            LanguageInfo language = lc.language.info;
            if (!lc.eventsEnabled || lc.env == null) continue;
            EngineAccessor.INSTRUMENT.notifyLanguageContextCreated(this, this.truffleContext, language);
            if (!lc.isInitialized()) continue;
            EngineAccessor.INSTRUMENT.notifyLanguageContextInitialized(this, this.truffleContext, language);
            if (!lc.finalized) continue;
            EngineAccessor.INSTRUMENT.notifyLanguageContextFinalized(this, this.truffleContext, language);
        }
    }

    synchronized void checkSubProcessFinished() {
        ProcessHandlers.ProcessDecorator[] processes;
        for (ProcessHandlers.ProcessDecorator process : processes = this.subProcesses.toArray(new ProcessHandlers.ProcessDecorator[this.subProcesses.size()])) {
            if (!process.isAlive()) continue;
            throw PolyglotEngineException.illegalState(String.format("The context has an alive sub-process %s created by %s.", process.getCommand(), process.getOwner().language.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PolyglotContextImpl preInitialize(PolyglotEngineImpl engine) {
        FileSystems.PreInitializeContextFileSystem fs = new FileSystems.PreInitializeContextFileSystem();
        FileSystems.PreInitializeContextFileSystem internalFs = new FileSystems.PreInitializeContextFileSystem();
        EconomicSet allowedLanguages = EconomicSet.create();
        allowedLanguages.addAll(engine.getLanguages().keySet());
        PolyglotContextConfig config = new PolyglotContextConfig(engine, engine.out, engine.err, engine.in, false, PolyglotAccess.ALL, false, false, false, false, null, Collections.emptyMap(), (EconomicSet<String>)allowedLanguages, Collections.emptyMap(), fs, internalFs, engine.logHandler, false, null, EnvironmentAccess.INHERIT, null, null, null, null);
        PolyglotContextImpl context = new PolyglotContextImpl(engine, config);
        try {
            context.sourcesToInvalidate = new ArrayList<Source>();
            String oldOption = engine.engineOptionValues.get(PolyglotEngineOptions.PreinitializeContexts);
            String newOption = ImageBuildTimeOptions.get("PreinitializeContexts");
            String optionValue = !oldOption.isEmpty() && !newOption.isEmpty() ? oldOption + "," + newOption : oldOption + newOption;
            if (!optionValue.isEmpty()) {
                HashSet languagesToPreinitialize = new HashSet();
                Collections.addAll(languagesToPreinitialize, optionValue.split(","));
                context.inContextPreInitialization = true;
                try {
                    Object prev = context.engine.enter(context);
                    try {
                        for (String languageId : engine.getLanguages().keySet()) {
                            PolyglotLanguage language;
                            if (languagesToPreinitialize.contains(languageId) && (language = engine.findLanguage(null, languageId, null, false, true)) != null) {
                                if (PolyglotContextImpl.overridesPatchContext(languageId)) {
                                    context.getContextInitialized(language, null);
                                    LOG.log(Level.FINE, "Pre-initialized context for language: {0}", language.getId());
                                } else {
                                    LOG.log(Level.WARNING, "Language {0} cannot be pre-initialized as it does not override TruffleLanguage.patchContext method.", languageId);
                                }
                            }
                            language = engine.idToLanguage.get(languageId);
                            language.clearOptionValues();
                        }
                    }
                    finally {
                        context.engine.leave(prev, context);
                    }
                }
                finally {
                    context.inContextPreInitialization = false;
                }
            }
            context.currentThreadInfo = PolyglotThreadInfo.NULL;
            context.constantCurrentThreadInfo = PolyglotThreadInfo.NULL;
            PolyglotContextImpl.disposeStaticContext(context);
            PolyglotContextImpl polyglotContextImpl = context;
            return polyglotContextImpl;
        }
        finally {
            for (Source sourceToInvalidate : context.sourcesToInvalidate) {
                EngineAccessor.SOURCE.invalidateAfterPreinitialiation(sourceToInvalidate);
            }
            context.sourcesToInvalidate = null;
            fs.onPreInitializeContextEnd();
            internalFs.onPreInitializeContextEnd();
            FileSystems.resetDefaultFileSystemProvider();
            if (!config.logLevels.isEmpty()) {
                EngineAccessor.LANGUAGE.configureLoggers(context, null, PolyglotContextImpl.getAllLoggers(engine));
            }
        }
    }

    synchronized long getTimeActive() {
        long timeExecuted = 0L;
        Collection<PolyglotThreadInfo> polyglotThreads = this.getSeenThreads().values();
        for (PolyglotThreadInfo threadInfo : polyglotThreads) {
            timeExecuted += threadInfo.getTimeExecuted();
        }
        return timeExecuted;
    }

    synchronized void resetTiming() {
        Collection<PolyglotThreadInfo> polyglotThreads = this.getSeenThreads().values();
        for (PolyglotThreadInfo threadInfo : polyglotThreads) {
            threadInfo.resetTiming();
        }
    }

    PolyglotThreadInfo getCachedThreadInfo(boolean isConstant) {
        return isConstant ? this.constantCurrentThreadInfo : this.currentThreadInfo;
    }

    private static Object[] getAllLoggers(PolyglotEngineImpl engine) {
        Object[] objectArray;
        Object defaultLoggers = EngineAccessor.LANGUAGE.getDefaultLoggers();
        Object engineLoggers = engine.getEngineLoggers();
        if (engineLoggers == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = defaultLoggers;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = defaultLoggers;
            objectArray = objectArray3;
            objectArray3[1] = engineLoggers;
        }
        return objectArray;
    }

    synchronized boolean invalidate(String message) {
        if (!this.invalid) {
            this.setCachedThreadInfo(PolyglotThreadInfo.NULL);
            this.invalidMessage = message;
            this.invalid = true;
            return true;
        }
        return false;
    }

    private static boolean overridesPatchContext(String languageId) {
        LanguageCache cache = LanguageCache.languages().get(languageId);
        for (Method m : cache.loadLanguage().getClass().getDeclaredMethods()) {
            if (!m.getName().equals("patchContext")) continue;
            return true;
        }
        return false;
    }

    static class ContextWeakReference
    extends WeakReference<PolyglotContextImpl> {
        volatile boolean removed = false;
        final List<PolyglotLanguageInstance> freeInstances = new ArrayList<PolyglotLanguageInstance>();

        ContextWeakReference(PolyglotContextImpl referent) {
            super(referent, referent.engine.contextsReferenceQueue);
        }
    }

    static final class SingleContextState {
        private final ContextThreadLocal contextThreadLocal = new ContextThreadLocal();
        private final Assumption singleContextAssumption = Truffle.getRuntime().createAssumption("Single Context");
        @CompilerDirectives.CompilationFinal
        private volatile PolyglotContextImpl singleContext;

        SingleContextState() {
            this(PolyglotContextImpl.singleContextState.singleContext);
        }

        SingleContextState(PolyglotContextImpl context) {
            this.singleContext = context;
        }

        ContextThreadLocal getContextThreadLocal() {
            return this.contextThreadLocal;
        }

        Assumption getSingleContextAssumption() {
            return this.singleContextAssumption;
        }
    }
}

