/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class MatchArm
extends Expression {
    private final List<Expression> conditions;
    private final Expression expression;
    private final boolean isDefault;

    public MatchArm(int start, int end, List<Expression> conditions, Expression expression, boolean isDefault) {
        super(start, end);
        this.conditions = new ArrayList<Expression>(conditions);
        this.expression = expression;
        this.isDefault = isDefault;
    }

    public List<Expression> getConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.conditions.forEach(condition -> {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(condition);
        });
        sb.append(" => ");
        sb.append(this.getExpression()).append(",");
        return sb.toString();
    }
}

