/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.Variadic;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class FieldsDeclaration
extends BodyDeclaration {
    private final List<SingleFieldDeclaration> fields = new ArrayList<SingleFieldDeclaration>();
    private final Expression fieldType;

    private FieldsDeclaration(int start, int end, int modifier, Expression fieldType, List<SingleFieldDeclaration> fields, List<Attribute> attributes) {
        super(start, end, modifier, false, attributes);
        this.fieldType = fieldType;
        this.fields.addAll(fields);
    }

    public FieldsDeclaration(int start, int end, int modifier, Expression fieldType, List variablesAndDefaults) {
        super(start, end, modifier);
        if (variablesAndDefaults == null || variablesAndDefaults.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (Object next : variablesAndDefaults) {
            if (next instanceof SingleFieldDeclaration) {
                this.fields.add((SingleFieldDeclaration)next);
                continue;
            }
            ASTNode[] element = (ASTNode[])next;
            SingleFieldDeclaration field = this.createField((Variable)element[0], (Expression)element[1], fieldType);
            this.fields.add(field);
        }
        this.fieldType = fieldType;
    }

    public static FieldsDeclaration create(FieldsDeclaration declaration, List<Attribute> attributes) {
        assert (attributes != null);
        int start = attributes.isEmpty() ? declaration.getStartOffset() : attributes.get(0).getStartOffset();
        return new FieldsDeclaration(start, declaration.getEndOffset(), declaration.getModifier(), declaration.getFieldType(), declaration.getFields(), attributes);
    }

    @CheckForNull
    public static FieldsDeclaration create(FormalParameter parameter) {
        if (!BodyDeclaration.Modifier.isVisibilityModifier(parameter.getModifier())) {
            return null;
        }
        Variable variable = null;
        Expression expression = parameter.getParameterName();
        if (expression instanceof Reference) {
            expression = ((Reference)expression).getExpression();
        }
        if (expression instanceof Variadic) {
            expression = ((Variadic)expression).getExpression();
        }
        if (expression instanceof Variable) {
            variable = (Variable)expression;
        }
        assert (variable != null);
        int start = variable.getStartOffset();
        Expression type = parameter.getParameterType();
        int end = variable.getEndOffset();
        Expression value = parameter.getDefaultValue();
        if (value != null) {
            end = value.getEndOffset();
        }
        SingleFieldDeclaration singleFieldDeclaration = new SingleFieldDeclaration(start, end, variable, value, type);
        return FieldsDeclaration.create(new FieldsDeclaration(parameter.getStartOffset(), parameter.getEndOffset(), parameter.getModifier(), parameter.getParameterType(), Collections.singletonList(singleFieldDeclaration)), parameter.getAttributes());
    }

    private SingleFieldDeclaration createField(Variable name, Expression value, Expression fieldType) {
        int start = name.getStartOffset();
        int end = value == null ? name.getEndOffset() : value.getEndOffset();
        SingleFieldDeclaration result = new SingleFieldDeclaration(start, end, name, value, fieldType);
        return result;
    }

    public List<SingleFieldDeclaration> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Expression[] getInitialValues() {
        Expression[] result = new Expression[this.fields.size()];
        int i = 0;
        for (SingleFieldDeclaration field : this.fields) {
            result[i++] = field.getValue();
        }
        return result;
    }

    public Variable[] getVariableNames() {
        Variable[] result = new Variable[this.fields.size()];
        int i = 0;
        for (SingleFieldDeclaration field : this.fields) {
            result[i++] = field.getName();
        }
        return result;
    }

    @CheckForNull
    public Expression getFieldType() {
        return this.fieldType;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sbAttributes = new StringBuilder();
        this.getAttributes().forEach(attribute -> sbAttributes.append(attribute).append(" "));
        StringBuilder sb = new StringBuilder();
        for (SingleFieldDeclaration singleFieldDeclaration : this.getFields()) {
            sb.append(singleFieldDeclaration).append(" ");
        }
        String modifierString = this.getModifierString();
        if (modifierString != null && modifierString.isEmpty()) {
            modifierString = modifierString + " ";
        }
        return sbAttributes.toString() + modifierString + sb.toString();
    }
}

