/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_transient_index_buffer_t")
public class BGFXTransientIndexBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;
    public static final int STARTINDEX;
    public static final int HANDLE;

    public BGFXTransientIndexBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXTransientIndexBuffer.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t *")
    public ByteBuffer data() {
        return BGFXTransientIndexBuffer.ndata(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return BGFXTransientIndexBuffer.nsize(this.address());
    }

    @NativeType(value="uint32_t")
    public int startIndex() {
        return BGFXTransientIndexBuffer.nstartIndex(this.address());
    }

    @NativeType(value="bgfx_index_buffer_handle_t")
    public short handle() {
        return BGFXTransientIndexBuffer.nhandle(this.address());
    }

    public BGFXTransientIndexBuffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
        BGFXTransientIndexBuffer.ndata(this.address(), value);
        return this;
    }

    public BGFXTransientIndexBuffer startIndex(@NativeType(value="uint32_t") int value) {
        BGFXTransientIndexBuffer.nstartIndex(this.address(), value);
        return this;
    }

    public BGFXTransientIndexBuffer handle(@NativeType(value="bgfx_index_buffer_handle_t") short value) {
        BGFXTransientIndexBuffer.nhandle(this.address(), value);
        return this;
    }

    public BGFXTransientIndexBuffer set(ByteBuffer data, int startIndex, short handle) {
        this.data(data);
        this.startIndex(startIndex);
        this.handle(handle);
        return this;
    }

    public BGFXTransientIndexBuffer set(BGFXTransientIndexBuffer src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXTransientIndexBuffer malloc() {
        return (BGFXTransientIndexBuffer)BGFXTransientIndexBuffer.wrap(BGFXTransientIndexBuffer.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static BGFXTransientIndexBuffer calloc() {
        return (BGFXTransientIndexBuffer)BGFXTransientIndexBuffer.wrap(BGFXTransientIndexBuffer.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static BGFXTransientIndexBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (BGFXTransientIndexBuffer)BGFXTransientIndexBuffer.wrap(BGFXTransientIndexBuffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static BGFXTransientIndexBuffer create(long address) {
        return (BGFXTransientIndexBuffer)BGFXTransientIndexBuffer.wrap(BGFXTransientIndexBuffer.class, (long)address);
    }

    @Nullable
    public static BGFXTransientIndexBuffer createSafe(long address) {
        return address == 0L ? null : (BGFXTransientIndexBuffer)BGFXTransientIndexBuffer.wrap(BGFXTransientIndexBuffer.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)BGFXTransientIndexBuffer.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)BGFXTransientIndexBuffer.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)BGFXTransientIndexBuffer.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXTransientIndexBuffer.__create((int)capacity, (int)SIZEOF);
        return (Buffer)BGFXTransientIndexBuffer.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)BGFXTransientIndexBuffer.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)BGFXTransientIndexBuffer.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static BGFXTransientIndexBuffer mallocStack() {
        return BGFXTransientIndexBuffer.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXTransientIndexBuffer callocStack() {
        return BGFXTransientIndexBuffer.callocStack(MemoryStack.stackGet());
    }

    public static BGFXTransientIndexBuffer mallocStack(MemoryStack stack) {
        return (BGFXTransientIndexBuffer)BGFXTransientIndexBuffer.wrap(BGFXTransientIndexBuffer.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXTransientIndexBuffer callocStack(MemoryStack stack) {
        return (BGFXTransientIndexBuffer)BGFXTransientIndexBuffer.wrap(BGFXTransientIndexBuffer.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXTransientIndexBuffer.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXTransientIndexBuffer.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)BGFXTransientIndexBuffer.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)BGFXTransientIndexBuffer.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)), (int)BGFXTransientIndexBuffer.nsize(struct));
    }

    public static int nsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIZE);
    }

    public static int nstartIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)STARTINDEX);
    }

    public static short nhandle(long struct) {
        return UNSAFE.getShort(null, struct + (long)HANDLE);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
        BGFXTransientIndexBuffer.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIZE, value);
    }

    public static void nstartIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STARTINDEX, value);
    }

    public static void nhandle(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)HANDLE, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXTransientIndexBuffer.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = BGFXTransientIndexBuffer.__struct((Struct.Member[])new Struct.Member[]{BGFXTransientIndexBuffer.__member((int)POINTER_SIZE), BGFXTransientIndexBuffer.__member((int)4), BGFXTransientIndexBuffer.__member((int)4), BGFXTransientIndexBuffer.__member((int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        STARTINDEX = layout.offsetof(2);
        HANDLE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<BGFXTransientIndexBuffer, Buffer>
    implements NativeResource {
        private static final BGFXTransientIndexBuffer ELEMENT_FACTORY = BGFXTransientIndexBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected BGFXTransientIndexBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t *")
        public ByteBuffer data() {
            return BGFXTransientIndexBuffer.ndata(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return BGFXTransientIndexBuffer.nsize(this.address());
        }

        @NativeType(value="uint32_t")
        public int startIndex() {
            return BGFXTransientIndexBuffer.nstartIndex(this.address());
        }

        @NativeType(value="bgfx_index_buffer_handle_t")
        public short handle() {
            return BGFXTransientIndexBuffer.nhandle(this.address());
        }

        public Buffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
            BGFXTransientIndexBuffer.ndata(this.address(), value);
            return this;
        }

        public Buffer startIndex(@NativeType(value="uint32_t") int value) {
            BGFXTransientIndexBuffer.nstartIndex(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="bgfx_index_buffer_handle_t") short value) {
            BGFXTransientIndexBuffer.nhandle(this.address(), value);
            return this;
        }
    }
}

