/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupDeviceCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PHYSICALDEVICECOUNT;
    public static final int PPHYSICALDEVICES;

    public VkDeviceGroupDeviceCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDeviceGroupDeviceCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceGroupDeviceCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceGroupDeviceCreateInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int physicalDeviceCount() {
        return VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(this.address());
    }

    @Nullable
    @NativeType(value="VkPhysicalDevice const *")
    public PointerBuffer pPhysicalDevices() {
        return VkDeviceGroupDeviceCreateInfo.npPhysicalDevices(this.address());
    }

    public VkDeviceGroupDeviceCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupDeviceCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupDeviceCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfo pPhysicalDevices(@Nullable @NativeType(value="VkPhysicalDevice const *") PointerBuffer value) {
        VkDeviceGroupDeviceCreateInfo.npPhysicalDevices(this.address(), value);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfo set(int sType, long pNext, @Nullable PointerBuffer pPhysicalDevices) {
        this.sType(sType);
        this.pNext(pNext);
        this.pPhysicalDevices(pPhysicalDevices);
        return this;
    }

    public VkDeviceGroupDeviceCreateInfo set(VkDeviceGroupDeviceCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDeviceGroupDeviceCreateInfo malloc() {
        return (VkDeviceGroupDeviceCreateInfo)VkDeviceGroupDeviceCreateInfo.wrap(VkDeviceGroupDeviceCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfo calloc() {
        return (VkDeviceGroupDeviceCreateInfo)VkDeviceGroupDeviceCreateInfo.wrap(VkDeviceGroupDeviceCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDeviceGroupDeviceCreateInfo)VkDeviceGroupDeviceCreateInfo.wrap(VkDeviceGroupDeviceCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDeviceGroupDeviceCreateInfo create(long address) {
        return (VkDeviceGroupDeviceCreateInfo)VkDeviceGroupDeviceCreateInfo.wrap(VkDeviceGroupDeviceCreateInfo.class, (long)address);
    }

    @Nullable
    public static VkDeviceGroupDeviceCreateInfo createSafe(long address) {
        return address == 0L ? null : (VkDeviceGroupDeviceCreateInfo)VkDeviceGroupDeviceCreateInfo.wrap(VkDeviceGroupDeviceCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDeviceGroupDeviceCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDeviceGroupDeviceCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDeviceGroupDeviceCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceGroupDeviceCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDeviceGroupDeviceCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDeviceGroupDeviceCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDeviceGroupDeviceCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkDeviceGroupDeviceCreateInfo mallocStack() {
        return VkDeviceGroupDeviceCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupDeviceCreateInfo callocStack() {
        return VkDeviceGroupDeviceCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupDeviceCreateInfo mallocStack(MemoryStack stack) {
        return (VkDeviceGroupDeviceCreateInfo)VkDeviceGroupDeviceCreateInfo.wrap(VkDeviceGroupDeviceCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupDeviceCreateInfo callocStack(MemoryStack stack) {
        return (VkDeviceGroupDeviceCreateInfo)VkDeviceGroupDeviceCreateInfo.wrap(VkDeviceGroupDeviceCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupDeviceCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupDeviceCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDeviceGroupDeviceCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDeviceGroupDeviceCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nphysicalDeviceCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)PHYSICALDEVICECOUNT);
    }

    @Nullable
    public static PointerBuffer npPhysicalDevices(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PPHYSICALDEVICES)), (int)VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nphysicalDeviceCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PHYSICALDEVICECOUNT, value);
    }

    public static void npPhysicalDevices(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPHYSICALDEVICES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PPHYSICALDEVICES)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDeviceGroupDeviceCreateInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkDeviceGroupDeviceCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkDeviceGroupDeviceCreateInfo.__member((int)4), VkDeviceGroupDeviceCreateInfo.__member((int)POINTER_SIZE), VkDeviceGroupDeviceCreateInfo.__member((int)4), VkDeviceGroupDeviceCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PHYSICALDEVICECOUNT = layout.offsetof(2);
        PPHYSICALDEVICES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupDeviceCreateInfo, Buffer>
    implements NativeResource {
        private static final VkDeviceGroupDeviceCreateInfo ELEMENT_FACTORY = VkDeviceGroupDeviceCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDeviceGroupDeviceCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceGroupDeviceCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceGroupDeviceCreateInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int physicalDeviceCount() {
            return VkDeviceGroupDeviceCreateInfo.nphysicalDeviceCount(this.address());
        }

        @Nullable
        @NativeType(value="VkPhysicalDevice const *")
        public PointerBuffer pPhysicalDevices() {
            return VkDeviceGroupDeviceCreateInfo.npPhysicalDevices(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupDeviceCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupDeviceCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pPhysicalDevices(@Nullable @NativeType(value="VkPhysicalDevice const *") PointerBuffer value) {
            VkDeviceGroupDeviceCreateInfo.npPhysicalDevices(this.address(), value);
            return this;
        }
    }
}

