/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nanovg;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct NVGtextRow")
public class NVGTextRow
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int START;
    public static final int END;
    public static final int NEXT;
    public static final int WIDTH;
    public static final int MINX;
    public static final int MAXX;

    public NVGTextRow(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NVGTextRow.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char *")
    public long start() {
        return NVGTextRow.nstart(this.address());
    }

    @NativeType(value="char *")
    public long end() {
        return NVGTextRow.nend(this.address());
    }

    @NativeType(value="char *")
    public long next() {
        return NVGTextRow.nnext(this.address());
    }

    public float width() {
        return NVGTextRow.nwidth(this.address());
    }

    public float minx() {
        return NVGTextRow.nminx(this.address());
    }

    public float maxx() {
        return NVGTextRow.nmaxx(this.address());
    }

    public static NVGTextRow malloc() {
        return (NVGTextRow)NVGTextRow.wrap(NVGTextRow.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NVGTextRow calloc() {
        return (NVGTextRow)NVGTextRow.wrap(NVGTextRow.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NVGTextRow create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NVGTextRow)NVGTextRow.wrap(NVGTextRow.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NVGTextRow create(long address) {
        return (NVGTextRow)NVGTextRow.wrap(NVGTextRow.class, (long)address);
    }

    @Nullable
    public static NVGTextRow createSafe(long address) {
        return address == 0L ? null : (NVGTextRow)NVGTextRow.wrap(NVGTextRow.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NVGTextRow.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NVGTextRow.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NVGTextRow.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NVGTextRow.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NVGTextRow.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NVGTextRow.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NVGTextRow.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static NVGTextRow mallocStack() {
        return NVGTextRow.mallocStack(MemoryStack.stackGet());
    }

    public static NVGTextRow callocStack() {
        return NVGTextRow.callocStack(MemoryStack.stackGet());
    }

    public static NVGTextRow mallocStack(MemoryStack stack) {
        return (NVGTextRow)NVGTextRow.wrap(NVGTextRow.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NVGTextRow callocStack(MemoryStack stack) {
        return (NVGTextRow)NVGTextRow.wrap(NVGTextRow.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NVGTextRow.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NVGTextRow.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)NVGTextRow.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)NVGTextRow.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nstart(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)START));
    }

    public static long nend(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)END));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static float nwidth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)WIDTH);
    }

    public static float nminx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MINX);
    }

    public static float nmaxx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MAXX);
    }

    static {
        Struct.Layout layout = NVGTextRow.__struct((Struct.Member[])new Struct.Member[]{NVGTextRow.__member((int)POINTER_SIZE), NVGTextRow.__member((int)POINTER_SIZE), NVGTextRow.__member((int)POINTER_SIZE), NVGTextRow.__member((int)4), NVGTextRow.__member((int)4), NVGTextRow.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        START = layout.offsetof(0);
        END = layout.offsetof(1);
        NEXT = layout.offsetof(2);
        WIDTH = layout.offsetof(3);
        MINX = layout.offsetof(4);
        MAXX = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<NVGTextRow, Buffer>
    implements NativeResource {
        private static final NVGTextRow ELEMENT_FACTORY = NVGTextRow.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NVGTextRow getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char *")
        public long start() {
            return NVGTextRow.nstart(this.address());
        }

        @NativeType(value="char *")
        public long end() {
            return NVGTextRow.nend(this.address());
        }

        @NativeType(value="char *")
        public long next() {
            return NVGTextRow.nnext(this.address());
        }

        public float width() {
            return NVGTextRow.nwidth(this.address());
        }

        public float minx() {
            return NVGTextRow.nminx(this.address());
        }

        public float maxx() {
            return NVGTextRow.nmaxx(this.address());
        }
    }
}

