"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var commons_1 = require("../../../../utils/commons");
var geometries_1 = require("./geometries");
var get_flat_hierarchy_1 = require("./get_flat_hierarchy");
var pie_spec_1 = require("./pie_spec");
exports.computeLegendSelector = re_reselect_1.default([pie_spec_1.getPieSpec, get_settings_specs_1.getSettingsSpecSelector, geometries_1.partitionGeometries, get_flat_hierarchy_1.getFlatHierarchy], function (pieSpec, settings, geoms, sortedItems) {
    if (!pieSpec) {
        return [];
    }
    var id = pieSpec.id, labelFormatters = pieSpec.layers;
    var uniqueNames = geoms.quadViewModel.reduce(function (acc, _a) {
        var dataName = _a.dataName, fillColor = _a.fillColor;
        var key = [dataName, fillColor].join('---');
        if (!acc[key]) {
            acc[key] = 0;
        }
        acc[key] += 1;
        return acc;
    }, {});
    var flatLegend = settings.flatLegend, legendMaxDepth = settings.legendMaxDepth, legendPosition = settings.legendPosition;
    var forceFlatLegend = flatLegend || legendPosition === commons_1.Position.Bottom || legendPosition === commons_1.Position.Top;
    var excluded = new Set();
    var items = geoms.quadViewModel.filter(function (_a) {
        var depth = _a.depth, dataName = _a.dataName, fillColor = _a.fillColor;
        if (legendMaxDepth != null) {
            return depth <= legendMaxDepth;
        }
        if (forceFlatLegend) {
            var key = [dataName, fillColor].join('---');
            if (uniqueNames[key] > 1 && excluded.has(key)) {
                return false;
            }
            excluded.add(key);
        }
        return true;
    });
    if (forceFlatLegend) {
        items = items.sort(function (_a, _b) {
            var a = _a.depth;
            var b = _b.depth;
            return a - b;
        });
    }
    return items
        .sort(function (a, b) {
        var aIndex = findIndex(sortedItems, a);
        var bIndex = findIndex(sortedItems, b);
        return aIndex - bIndex;
    })
        .map(function (_a) {
        var dataName = _a.dataName, fillColor = _a.fillColor, depth = _a.depth;
        var _b;
        var labelFormatter = labelFormatters[depth - 1];
        var formatter = (_b = labelFormatter) === null || _b === void 0 ? void 0 : _b.nodeLabel;
        return {
            color: fillColor,
            label: formatter ? formatter(dataName) : dataName,
            dataName: dataName,
            childId: dataName,
            depth: forceFlatLegend ? 0 : depth - 1,
            seriesIdentifier: {
                key: dataName,
                specId: id,
            },
        };
    });
})(get_chart_id_1.getChartIdSelector);
function findIndex(items, child) {
    return items.findIndex(function (_a) {
        var _b = __read(_a, 3), dataName = _b[0], depth = _b[1], value = _b[2];
        return dataName === child.dataName && depth === child.depth && value === child.value;
    });
}
//# sourceMappingURL=compute_legend.js.map