"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var geometries_1 = require("./geometries");
function getCurrentPointerPosition(state) {
    return state.interactions.pointer.current.position;
}
exports.getPickedShapes = re_reselect_1.default([geometries_1.geometries, getCurrentPointerPosition], function (geoms, pointerPosition) {
    var picker = geoms.pickQuads;
    var x = pointerPosition.x, y = pointerPosition.y;
    return picker(x, y);
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=picked_shapes.js.map