"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_last_drag_1 = require("../../../../state/selectors/get_last_drag");
var geometries_1 = require("./geometries");
exports.getPickedCells = re_reselect_1.default([geometries_1.geometries, get_last_drag_1.getLastDragSelector], function (geoms, dragState) {
    if (!dragState) {
        return null;
    }
    var _a = dragState.start.position, startX = _a.x, startY = _a.y, _b = dragState.end.position, endX = _b.x, endY = _b.y;
    return geoms.pickDragArea([
        { x: startX, y: startY },
        { x: endX, y: endY },
    ]);
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_picked_cells.js.map