/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.HashSet;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

class OutboundMessageDistributor {
    private final RouterContext _context;
    private final int _priority;
    private final Log _log;
    private final Set<Hash> _toRouters;
    private int _newRouterCount;
    private long _newRouterTime;
    private static final long MAX_DISTRIBUTE_TIME = 15000L;
    private static final int MAX_ROUTERS_PER_PERIOD = 60;
    private static final long NEW_ROUTER_PERIOD = 30000L;

    public OutboundMessageDistributor(RouterContext ctx, int priority) {
        this._context = ctx;
        this._priority = priority;
        this._log = ctx.logManager().getLog(OutboundMessageDistributor.class);
        if (priority <= 200) {
            this._toRouters = new HashSet<Hash>(4);
            this._toRouters.add(ctx.routerHash());
        } else {
            this._toRouters = null;
        }
    }

    public void distribute(I2NPMessage msg, Hash target) {
        this.distribute(msg, target, null);
    }

    public void distribute(I2NPMessage msg, Hash target, TunnelId tunnel) {
        if (this.shouldDrop(target)) {
            this._context.statManager().addRateData("tunnel.dropAtOBEP", 1L);
            if (this._log.shouldLog(30)) {
                this._log.warn("Drop msg at OBEP (new conn throttle) to " + target + ' ' + msg);
            }
            return;
        }
        RouterInfo info = this._context.netDb().lookupRouterInfoLocally(target);
        if (info == null) {
            if (this._log.shouldLog(20)) {
                this._log.info("outbound distributor to " + target + "." + (tunnel != null ? tunnel.getTunnelId() + "" : "") + ": no info locally, searching...");
            }
            this._context.netDb().lookupRouterInfo(target, new DistributeJob(this._context, msg, target, tunnel), null, 15000L);
            return;
        }
        this.distribute(msg, info, tunnel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldDrop(Hash target) {
        if (this._toRouters == null) {
            return false;
        }
        OutboundMessageDistributor outboundMessageDistributor = this;
        synchronized (outboundMessageDistributor) {
            if (!this._toRouters.add(target) || this._context.commSystem().isEstablished(target) || ++this._newRouterCount <= 60) {
                return false;
            }
            long now = this._context.clock().now();
            if (this._newRouterTime < now - 30000L) {
                this._newRouterCount = 1;
                this._newRouterTime = now;
                return false;
            }
            this._toRouters.remove(target);
        }
        return true;
    }

    private void distribute(I2NPMessage msg, RouterInfo target, TunnelId tunnel) {
        I2NPMessage m = msg;
        if (tunnel != null) {
            TunnelGatewayMessage t = new TunnelGatewayMessage(this._context);
            t.setMessage(msg);
            t.setTunnelId(tunnel);
            t.setMessageExpiration(m.getMessageExpiration());
            m = t;
        }
        if (this._context.routerHash().equals(target.getIdentity().calculateHash())) {
            if (this._log.shouldLog(10)) {
                this._log.debug("queueing inbound message to ourselves: " + m);
            }
            this._context.inNetMessagePool().add(m, null, null);
            return;
        }
        OutNetMessage out = new OutNetMessage(this._context, m, this._context.clock().now() + 15000L, this._priority, target);
        if (this._log.shouldLog(10)) {
            this._log.debug("queueing outbound message to " + target.getIdentity().calculateHash());
        }
        this._context.outNetMessagePool().add(out);
    }

    private class DistributeJob
    extends JobImpl {
        private final I2NPMessage _message;
        private final Hash _target;
        private final TunnelId _tunnel;

        public DistributeJob(RouterContext ctx, I2NPMessage msg, Hash target, TunnelId id) {
            super(ctx);
            this._message = msg;
            this._target = target;
            this._tunnel = id;
        }

        @Override
        public String getName() {
            return "OBEP distribute after lookup";
        }

        @Override
        public void runJob() {
            int stat;
            RouterInfo info = this.getContext().netDb().lookupRouterInfoLocally(this._target);
            if (info != null) {
                if (OutboundMessageDistributor.this._log.shouldLog(10)) {
                    OutboundMessageDistributor.this._log.debug("outbound distributor to " + this._target + "." + (this._tunnel != null ? this._tunnel.getTunnelId() + "" : "") + ": found on search");
                }
                OutboundMessageDistributor.this.distribute(this._message, info, this._tunnel);
                stat = 1;
            } else {
                if (OutboundMessageDistributor.this._log.shouldLog(30)) {
                    OutboundMessageDistributor.this._log.warn("outbound distributor to " + this._target + "." + (this._tunnel != null ? this._tunnel.getTunnelId() + "" : "") + ": NOT found on search");
                }
                stat = 0;
            }
            OutboundMessageDistributor.this._context.statManager().addRateData("tunnel.distributeLookupSuccess", stat);
        }
    }
}

