/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import net.i2p.I2PAppContext;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.i2ptunnel.udp.Source;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public class UDPSource
implements Source,
Runnable {
    public static final int MAX_SIZE = 15360;
    protected final DatagramSocket sock;
    protected Sink sink;
    protected final Thread thread;

    public UDPSource(int port) {
        try {
            this.sock = new DatagramSocket(port);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to listen...", e);
        }
        this.thread = new I2PAppThread(this);
    }

    public UDPSource(DatagramSocket sock) {
        this.sock = sock;
        this.thread = new I2PAppThread(this);
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    @Override
    public void start() {
        this.thread.start();
    }

    @Override
    public void run() {
        byte[] buf = new byte[15360];
        DatagramPacket pack = new DatagramPacket(buf, buf.length);
        try {
            while (true) {
                this.sock.receive(pack);
                byte[] nbuf = new byte[pack.getLength()];
                System.arraycopy(pack.getData(), 0, nbuf, 0, nbuf.length);
                this.sink.send(null, nbuf);
            }
        }
        catch (Exception e) {
            block3: {
                Log log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
                if (!log.shouldWarn()) break block3;
                log.warn("error sending", e);
            }
            return;
        }
    }

    public void stop() {
        this.sock.close();
    }
}

